/*** ARRYHS-SUPP.C ***/					#include	"main.h"

/************************************************************************************************/
// CKASGN_SAIDX() check & assign Std.Arry[] index into idx[] and return dim or 0.
/************************************************************************************************/
int ckasgn_saidx(ctree *ptr,int idx[]){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*e;				int		cnt,dep,val;
char	*str;

/* Std.Arry[] Index = Norm CSL */
	cnt=lcnt(ptr); if( cnt==0 || MAX_SADIM<cnt ) return 0;
	for( dep=0 ; dep<cnt ; dep++ ){
		e = ctr2p_dtab( eva_expr(lptr(ptr,dep),1) );
		if( e==0x00      ){ flag_exerr=E_ARYIDX; epar[0]='U'; return 0; }	// インデックス値が算出不能。（間接未定義）
		if( e->type=='U' ){ flag_exerr=E_ARYIDX; epar[0]='U'; return 0; }	// インデックス値が未定義。  （直接未定義）
		if( e->type!='I' || cint(e)<0 || MAX_SAIDX<=cint(e) ) goto L_NOTSTD;
		idx[dep] = cint(e);
	}
	return cnt;			/* = dimension ( 1, 2, 3, ... ) */

L_NOTSTD:
/* ( Index = Raw Ukey ) */
	str = (e->str);						// Ukey = FS+"0003" FS+I:100 FS+I:200 FS+I:300
	if( cnt==1 && e->type=='S' && str[0]==0x1C ){			/* RAW Ukey							*/
		cnt = atoi2(&str[1]); if( cnt==0 || MAX_SAIDX<cnt ) return 0;
		str = strchr(&str[1],0x1C);
		for( dep=0 ; dep<cnt ; dep++ ){
			val = atoi2(&str[3]); if( str[1]!='I' || val<0 || MAX_SAIDX<=val ) return 0;
			str = strchr(&str[1],0x1C);
			idx[dep] = val;
		}
		return cnt;		/* = dimension ( 1, 2, 3, ... ) */
	}
/* ( Index = Other Data ) */
	else
		return 0;
}

/************************************************************************************************/
// MK_UKEY() returns U + Unified Hash Key (UKEY) generated from DTAB (K).
/************************************************************************************************/
char *mk_ukey(char *u,dtab *k){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	buf[BUFSIZ];					/* Working Buffer for UKEY								*/
int		dim,len;

// Note1: Ukey Format = "%04d S:%s I:%d D:%f P:%p" [ %04d = Arry&Hash Dimension ]
// Note2: ASCII FS    = Oct 034 / Dec 28 / Hex 0x1C

/* { Set Init UKEY || Set Curr UKEY ( Inc Dim ) } + ASCII FS Char */
	if( u==NULL ){         buf[0]=0x1C; sprintf(buf+1,"%04d",dim=1);                     strcat2(buf,"\034"); }
	else{ dim=atol(&u[1]); buf[0]=0x1C; sprintf(buf+1,"%04d",dim+1); strcat2(buf,&u[5]); strcat2(buf,"\034"); }
	len=strlen2(buf);
/* Add New UKEY */
	switch( k->type ){
	case 'S': sprintf(&buf[len],"S:%s"              ,k->str ); break;
	case 'I': sprintf(&buf[len],"I:%"PRIdTINT       ,k->ival); break;
	case 'D': sprintf(&buf[len],"D:%+.15"PFX_TDBL"g",k->dval); break;
	case 'P':
		if( k->ptr==NULL ){ sprintf(&buf[len],"P:NULL"                                ); }
		else{               sprintf(&buf[len],"P:%p"                           ,k->ptr); } break;
	case 'X':
		if( k->ptr==NULL ){ sprintf(&buf[len],"X:%04d+NULL",(k->attr)&ATTR_FXID);        }
		else{               sprintf(&buf[len],"X:%04d+%p"  ,(k->attr)&ATTR_FXID,k->ptr); } break;
	default:
		flag_exerr=E_ARYIDX; epar[0]=k->type; return(NULL);
	}
/* Return UKEY */
	return X_SDUP(buf);
}

/************************************************************************************************/
// RV_UKEY() reversely converts UKEY into "Key,Key,Key, ... "|"Id.Id.Id. ... " string and return
// the result.  It also set p_dtab if p_dtab!=NULL.
/************************************************************************************************/
char *rv_ukey(char *ukey,int attr,dtab *p_dtab){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	buf[BUFSIZ],*p_type;			/* Working Buffer for UKEY / Current {Key|Id} Type		*/
int		idx,flag_struct=(attr&ATTR_STID)?TRUE:FALS;
dtab	*p_func;

/* Set DTAB */
	if( p_dtab!=NULL ){
	/* Dim!=1 -> Set AsIs Ukey */
		init_dtab(p_dtab);
		if( atol(&ukey[1])!=1 ){ p_dtab->type='S'; p_dtab->str=X_SDUP(ukey); }
	/* Dim==1 -> Set Orig Data */
		else{
			switch( ukey[6] ){			/* Ukey = FS+"####"+FS+Type:(Value)						*/
				case 'S': p_dtab->type='S'; p_dtab->str = X_SDUP(ukey+8);							break;
				case 'I': p_dtab->type='I'; p_dtab->ival= atol  (ukey+8);							break;
				case 'D': p_dtab->type='D'; p_dtab->dval= atof2 (ukey+8);							break;
				case 'P': p_dtab->type='P'; p_dtab->ptr =(void *)((tint)strtoll(ukey+8  ,NULL,16));	break;
				case 'X': p_dtab->type='X'; p_dtab->attr= atol  (ukey+8);	/*** Full Attr!! ***/
											p_dtab->ptr =(void *)((tint)strtoll(ukey+8+5,NULL,16));
					p_func = seek_origfunc(p_dtab->attr,p_dtab->ptr); cpy_dtab(p_dtab,p_func);		break;
				default: assert(FALS);
			}
		}
	}
/* Rev Convert */
	idx=0; ukey+=6;						/* Skip FS+####+FS										*/
	while( *ukey!='\0' ){
		p_type=ukey;
		if( *p_type=='X' ){
			p_func = seek_origfunc(atol(ukey+2),(void *)strtoll(ukey+2+4+1,NULL,16));
			sprintf(&buf[idx],"&%s()",(p_func==NULL?"NoName":p_func->name));
			while( buf[idx]!='\0' ){ idx++; }
			while( *ukey!='\0'&&*ukey!=0x1C ){ ukey++; }
			continue;
		}
		if( *p_type=='S' && !flag_struct ){ buf[idx++]='\"'; }		/// Key => "Key ///
		for( ukey+=2 ; *ukey!=0x1C && *ukey!=0x00 ; idx++,ukey++ ){
			buf[idx]=*ukey;
		}
		if( *p_type=='S' && !flag_struct ){ buf[idx++]='\"'; }		/// Key => Key" ///
		if( flag_struct==TRUE && *ukey==0x1C ){ buf[idx++]='.'; ukey++; }
		if( flag_struct==FALS && *ukey==0x1C ){ buf[idx++]=','; ukey++; }
	}
	buf[idx]='\0';
/* Return UKEY */
	return X_SDUP(buf);
}

/************************************************************************************************/
// BE_STID() checks UKEY can be Struct.Id or Not, then returns TRUE/FALS.
/************************************************************************************************/
int be_stid(char *ukey){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		dim,len;		int		dx,ux;

/* Check Dim&Len */
	dim=atoi2  (ukey+1); if( dim<1 ) return(FALS);	/*** At least 1 ***/
	len=strlen2(ukey  ); if( len<8 ) return(FALS);	/*** At least 8 ***/
/* Check S:"Struct.Id" */
	for( dx=0,ux=6 ; dx<dim ; dx++ ){			/* DX = Dim Index / UX = Ukey Index				*/
		if( ukey[ux]!='S' ){ return(FALS); }; ux++;
		if( ukey[ux]!=':' ){ return(FALS); }; ux++;
			if( !isalpha(ukey[ux]) && ukey[ux]!='_' ){ return(FALS); }; ux++;
		while( ukey[ux]!=0x1C && ukey[ux]!='\0' ){			/* ASCII FS = 0x1C					*/
			if( !isalnum(ukey[ux]) && ukey[ux]!='_' ){ return(FALS); }; ux++;
		}
		if( ukey[ux]==0x1C ) ux++;
	}
/* Return */
	return TRUE;
}

/************************************************************************************************/
// FX_HASH() calculates & returns Hash Value from (char *)UKEY.
/************************************************************************************************/
int fx_hash(char *ukey){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		hval=0x00;						/* Hash Value											*/

/* Calculate Hash Value */
	for( int idx=0 ; ukey[idx]!='\0' ; idx++ ){
/*==============================================================================================*/
/* The Practice of Programming. ( [Addison-Wesley] Brian W.Kernighan & Rob Pike )				*/
/*==============================================================================================*/
		hval = 37*hval+ukey[idx];		/* Page.88 ( Japanese Edition )							*/
/*==============================================================================================*/
	}
/* Return */
	return(abs(hval));					/*** Positive!! ***/
}
