/*** I_FPCTRL.C ***/					#include	"main.h"

/************************************************************************************************/
// RET_FP() opens and/or returns File Pointer. ( If mode==NULL, it will not try to open. )
/************************************************************************************************/
FILE *ret_fp(ctree *ctr,char *mode){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
dtab	*x = ctr2p_dtab(ctr);			/* File Object {FileName|FilePointer}					*/
FILE	*fp,*fpipe;		char	*xcmd;

/* Set Param(s) & Check Type(s) */
	chk_vtype(x,"SP",0);				/* Note: Always, FP argpos is 0 in X_FUNC().			*/

/* Do RET_FP()!! */
	if( x->type=='S' ){							// Name=*** / Str="FileName" / Ptr={FILE*|NULL}
		if( x->ptr!=NULL ) return (FILE*)(x->ptr);
		if( mode  ==NULL ) return NULL;
		if( strcmp(x->name,"EXT_SHELL")==0 ){	// EXT_SHELL(NAME) 初回参照
			xcmd = cstr(EXT_SHELL());
			if( (fpipe=popen(xcmd,"w" ))==NULL ){ flag_exerr=PipeOpen; return NULL; }
			x->ptr = fpipe;
		}
		else{									// 一般文字列      初回参照
			if( (fp   =fopen(cstr(x)  ,mode))==NULL ){ flag_exerr=FileOpen; return NULL; }
			x->ptr = fp;
		}
	}
	if( x->type=='P' &&  ((x->attr)&ATTR_FPCD) )// Name={:CODE|:DATA} / Str=NULL / Ptr={FILE*} / IVAL=RewPos
		;
	if( x->type=='P' && !((x->attr)&ATTR_FPCD) )// Name=***           / Str=NULL / Ptr={FILE*} / IVAL=0x00
		;
	return (FILE *)(x->ptr);
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_open(ctree *ctr){				/*** TT-Lang: A = OPEN(X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S",0);
	y = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(y,"S",1);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do OPEN()!! */
	a->type='P'; a->ptr=fopen(cstr(x),cstr(y)); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_close(ctree *ctr){				/*** TT-Lang: A = CLOSE(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
FILE	*fp;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SIDP",0);	/*** {Socket|File Pinter} ***/
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );
	if( issptr(x) ){
		if( (fp=ret_fp(par,NULL)) == NULL ){ null_dtab(a); return ans; }
	}

/* Do CLOSE()!! */
	if( isdigv(x) ){					// Socket!!
		a->type='I'; a->ival= close(cint(x)); if( a->ival!=0   ){ null_dtab(a); }
	}
	else{								// File Pointer!!
		x->ptr =NULL;					// Clear FP in X
		a->type='I'; a->ival=fclose(fp     ); if( a->ival==EOF ){ null_dtab(a); }
	}
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_flush(ctree *ctr){				/*** TT-Lang: A = FLUSH(X) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
FILE	*fp;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SP",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );
	if( isnull(x) ){ fp=NULL; }			// NULL = Flush All Open Output Stream(s)
	else if( (fp=ret_fp(par,NULL)) == NULL ){ null_dtab(a); return ans; }

/* Do FLUSH()!! */
	a->type='I'; a->ival=fflush(fp); if( a->ival==EOF ){ null_dtab(a); } return ans;
}

ctree *i_getpos(ctree *ctr){ return do_ctrpos(ctr,'G'); }	/*** TT-Lang: A = GETPOS(X  ) ***/
ctree *i_setpos(ctree *ctr){ return do_ctrpos(ctr,'S'); }	/*** TT-Lang: A = SETPOS(X,Y) ***/
ctree *i_movpos(ctree *ctr){ return do_ctrpos(ctr,'M'); }	/*** TT-Lang: A = MOVPOS(X,Y) ***/
ctree *i_rewind(ctree *ctr){ return do_ctrpos(ctr,'R'); }	/*** TT-Lang: A = REWIND(X  ) ***/

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_ctrpos(ctree *ctr,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;
FILE	*fp;

/* Set Param(s) & Check Type(s) */
								  x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SP",0);
	if( mode=='S' || mode=='M' ){ y = ctr2p_dtab(     lptr(ctr,1) ); chk_vtype(y,"ID",1); }
								  a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );
	if( (fp=ret_fp(par,NULL)) == NULL ){ null_dtab(a); return ans; }

/* Do CTRLPOS()!! */
	if( mode=='G'               ){ a->type='I'; a->ival=ftell(fp);                           return ans; }
	if( mode=='S' && 0<=cint(y) ){ a->type='I'; a->ival=fseek(fp,(long)cint(y)+0L,SEEK_SET); return ans; }
	if( mode=='S' && cint(y)< 0 ){ a->type='I'; a->ival=fseek(fp,(long)cint(y)+1L,SEEK_END); return ans; }
	if( mode=='M'               ){ a->type='I'; a->ival=fseek(fp,(long)cint(y)   ,SEEK_CUR); return ans; }
	if( mode=='R'               ){
// Never use cint(x) for {:CODE|:DATA} here, bacause x->type=='P' but rewind position is in x->ival!!
		if( (x->attr)&ATTR_FPCD ){ a->type='I'; a->ival=fseek(fp,(long)(x->ival) ,SEEK_SET); return ans; }	/* {:CODE|:DATA} */
		else                     { a->type='I'; a->ival=fseek(fp,(long)        0L,SEEK_SET); return ans; }
	}
	return NULL;
}
