/*** X_IMED.C ***/						#include	"main.h"

static void set_arryimed(ctree *ptr,dtab *arry,int idx[],int dep);

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *x_imed(ctree *ptr){				/*** TT-Lang: A = {V,V,...} | {K=>V,K=>V,...} ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/

int		op = (ptr==NULL?0x00:ptr->op);
ctree	*ans,*val;	dtab	*a,*e,*k,*v;
char	*ukey=NULL;
int		idx[MAX_SADIM],dep,cnt,i;				/* Current Array Index / Current Dimmension		*/

/* Debug & PreCheck */
	chk_point(ptr);

/* Set Param(s) & Check Type(s) */
	a = ctr2p_dtab( ans=ext_ctrdtab(ptr) );

/* Do {V,V,V,...    }!!	- Generates *NoName* ARRY for IMED_DATA */
	if( op=='{' ){
		set_arryimed(ptr,a,idx,dep=0); if(flag_exerr){ return NULL; }
		if( a->ptr==NULL &&  a->ptr2==NULL ){ null_dtab(a); }	// { Empty } //
		return ans;
	}

/* Do {K=>V,K=>V,...}!!	- Generates *NoName* HASH for IMED_DATA */
	if( op=='}' ){
		for( i=0,cnt=lcnt(ptr->l) ; i<cnt ; i++ ){
			val = lptr(ptr->l,i);				/* >Retrieve IMED_DATA(K=>V) for Index=I		*/
			if( iscgap(val) ) continue;			/* >( Skip GAP Elmt )							*/
			k = ctr2p_dtab( eva_expr(val->l,1) ); chk_error(ptr);
			v = ctr2p_dtab( eva_expr(val->r,1) ); chk_error(ptr);
		/* Std.Array[] */
			if( k->type=='I' && 0<=(k->ival) && (k->ival)<MAX_SAIDX ){
				e = di2p_dtab(a,k->ival);		/* >Regist 'U' Elmt								*/
				cpy_dtab(e,v);					/* >Assign Value to Elmt						*/
			}
		/* Ext.Array[] */
			else{
				if( (ukey=mk_ukey(NULL,k))==NULL ) return(NULL);
				e = du2p_dtab(a,ukey);			/* >Regist 'U' Elmt								*/
				cpy_dtab(e,v);					/* >Assign Value to Elmt						*/
			}
		}
		if( a->ptr==NULL &&  a->ptr2==NULL ){ null_dtab(a); }	// { Empty } //
		return ans;
	}

/* Assert!! */
	return NULL;

}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
static void set_arryimed(ctree *ptr,dtab *arry,int idx[],int dep){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*sub_ptr;	dtab	*e,*v;
int		cnt;

/* Dim Check */
	if( MAX_SADIM<dep+1 ){ flag_exerr=E_ARYIDX; return; }
/* Make Std.Arry[] */
	for( idx[dep]=0,cnt=lcnt(ptr->l) ; idx[dep]<cnt ; idx[dep]++ ){
		sub_ptr =  lptr(ptr->l,idx[dep]);
		if( sub_ptr->op=='{' ){					// Nest!! //
			set_arryimed(sub_ptr,arry,idx,dep+1); if(flag_exerr){ return; }
		}
		else{									// Term!! //
			if( iscgap(sub_ptr) ) continue;
			v = ctr2p_dtab( eva_expr(sub_ptr,1) ); if(flag_exerr){ return; } /* chk_error() */
			e = dn2p_dtab(arry,idx,dep+1);		/* dim = dep+1									*/
			if( !ismatv(v) ) matx_dis(arry);	/* Disable Matrix								*/
			cpy_dtab(e,v);						/* Assign Value to Elmt							*/
		}
	}
}
