/*** I_SIGNAL.C ***/					#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_tx_sig(ctree *ctr){			/*** TT-Lang: A = TX_SIG(X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);	// PID
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);	// SIG
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TX_SIG()!! */
	a->type = 'I';
	a->ival = kill(cint(x),cint(y));	// KILL(PID,SIG)
	if( a->ival!=0 ){ null_dtab(a); }	// Error!!
	return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_rx_sig(ctree *ctr){			/*** TT-Lang: A = RX_SIG(X,Y) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y;

void	(*rt_prev)(int);				/* <RT> Signal-Handler									*/
void	*ud_prev;						/* <UD> Signal-Handler { MEM[] Addr (>FX_UNIT) }		*/

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"PX",0);	// SIG_DFL | SIG_IGN | (UsrFunc)DTAB
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);	// SIG
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

// Note: SIG_DFL & SIG_IGN are 'P'ointer, and their values are 0 & 1 respectively.
// &UsrFunc() generates 'X' DTAB.

/* Do RX_SIG()!! */

// ( Get Prev Handler & Set Next Handler ) //
	ud_prev = sig_vect[cint(y)];
	if( x->type=='P' ){								/*** SIG_DFL|SIG_IGN   -> Handled by OS	***/
		sig_vect[cint(y)] = 0;								// <UD> Clear!!
		rt_prev = signal(cint(y),cptr(x)   );				// <RT> SetUp!! (SIG_DFL|SIG_IGN)
	}
	else{											/*** &UsrFunc()        -> Handled by TT	***/
		sig_vect[cint(y)] = (void *)(tint)(GL_DTAB+((x->attr)&ATTR_FXID)*FX_UNIT);	// <UD> SetUP!! ( MEM[] Addr )
		rt_prev = signal(cint(y),rt_handler);				// <RT> SetUp!!
	}

	if( rt_prev==SIG_ERR ){ null_dtab(a); return ans; }		/*** Error!! ***/

// ( Set Prev Handler for Return ) //
	if( rt_prev==SIG_DFL || rt_prev==SIG_IGN ){		/*** OS Handler ***/
		a->type = 'P';
		a->ptr  = rt_prev;									// SIG_DFL(0)|SIG_IGN(1)
	}
	else{											/*** TT Handler ***/
		a->type = 'P';
		a->ptr  = ud_prev;									// MEM[] Addr (>FX_UNIT)
	}

	return ans;
}
