/*** I_ACONV.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_ux2tm(ctree *ctr,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*e;
struct	tm *p_tm,tm;	time_t	tsec=0;			tdbl	frac=0.0L;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do UX2TM()!! */
	tsec=cint(x); frac=fmod(cdbl(x),1.0L);
	if( mode=='U' ){                     p_tm=gmtime(&tsec); asgn_tm2dtab(p_tm,a,'A'); /* 'A'=All  */ }
	if( mode=='L' ){ tsec+=LTZ_OFFSET(); p_tm=gmtime(&tsec); asgn_tm2dtab(p_tm,a,'A'); /* 'A'=All  */ }
	if( mode=='E' ){
		tm.tm_mday=tsec/(24*60*60); tsec =tsec%(24*60*60);
		tm.tm_hour=tsec/(60*60);    tsec =tsec%(60*60);
		tm.tm_min =tsec/(60);       tsec =tsec%(60);
		tm.tm_sec =tsec;                 p_tm=&tm;           asgn_tm2dtab(p_tm,a,'E'); /* 'E'=Elp  */
	}
	e=ds2p_dtab(a,"sec"); e->dval+=frac;

	a->attr |= ATTR_STID; return ans;	/*** Arry&Hash => StId ***/
}
ctree *i_t2utc(ctree *ctr){ /*** TT-Lang: A = T2UTC(X) ***/ return do_ux2tm(ctr,'U'); }
ctree *i_t2ltz(ctree *ctr){ /*** TT-Lang: A = T2LTZ(X) ***/ return do_ux2tm(ctr,'L'); }
ctree *i_t2elp(ctree *ctr){ /*** TT-Lang: A = T2ELP(X) ***/ return do_ux2tm(ctr,'E'); }


/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_tm2ux(ctree *ctr,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*e;
struct	tm tm;			time_t	tsec=0;			tdbl	frac=0.0L;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"A",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TM2UX()!! */
	if( mode=='U' ){ asgn_dtab2tm(x,&tm,'M'); /* 'M'=Make */ tsec=mktime(&tm)+gl_gmtoff;				}
	if( mode=='L' ){ asgn_dtab2tm(x,&tm,'M'); /* 'M'=Make */ tsec=mktime(&tm)+gl_gmtoff-LTZ_OFFSET();	}
	if( mode=='E' ){ asgn_dtab2tm(x,&tm,'E'); /* 'E'=Elp  */
		tsec=(tm.tm_mday)*24*60*60+(tm.tm_hour)*60*60+(tm.tm_min)*60+(tm.tm_sec);
	}
	e=ds2p_dtab(x,"sec"); frac=fmod(cdbl(e),1.0L);

	a->type='D'; a->dval=tsec+frac; return ans;
}
ctree *i_utc2t(ctree *ctr){ /*** TT-Lang: A = UTC2T(X) ***/ return do_tm2ux(ctr,'U'); }
ctree *i_ltz2t(ctree *ctr){ /*** TT-Lang: A = LTZ2T(X) ***/ return do_tm2ux(ctr,'L'); }
ctree *i_elp2t(ctree *ctr){ /*** TT-Lang: A = ELP2T(X) ***/ return do_tm2ux(ctr,'E'); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_tm2tm(ctree *ctr,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*e,*p_year,*p_mon,*p_day;
struct	tm *p_tm,tm;	time_t	tsec=0;			tdbl	frac=0.0L;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"A",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do TM2TM()!! */

// ( Arry&Hash -> Tsec )
	if( mode=='+' ){ asgn_dtab2tm(x,&tm,'M'); /* 'M'=Make */ tsec = mktime(&tm)+gl_gmtoff;				}
	if( mode=='-' ){ asgn_dtab2tm(x,&tm,'M'); /* 'M'=Make */ tsec = mktime(&tm)+gl_gmtoff-LTZ_OFFSET();	}
	if( mode=='0' ){
		p_year=ds2p_dtab(x,"year"); 
		p_mon =ds2p_dtab(x,"mon" ); 
		p_day =ds2p_dtab(x,"day" ); 
		if( p_year->type=='U' && p_mon->type=='U' && p_day->type!='U' ){	/*** TM_NORM('E') ***/
			asgn_dtab2tm(x,&tm,'E'); /* 'E'=Elp  */
			tsec = (tm.tm_mday)*24*60*60+(tm.tm_hour)*60*60+(tm.tm_min)*60+(tm.tm_sec);
		}
		else{
			asgn_dtab2tm(x,&tm,'M'); /* 'M'=Make */
			tsec = mktime(&tm)+gl_gmtoff;
		}
	}
	e=ds2p_dtab(x,"sec"); frac=fmod(cdbl(e),1.0L);

// ( Tsec -> Arry&Hash )
	if( mode=='+' ){ tsec+=LTZ_OFFSET(); p_tm=gmtime(&tsec); asgn_tm2dtab(p_tm,a,'A'); /* 'A'=All  */ }
	if( mode=='-' ){                     p_tm=gmtime(&tsec); asgn_tm2dtab(p_tm,a,'A'); /* 'A'=All  */ }
	if( mode=='0' ){
		if( p_year->type=='U' && p_mon->type=='U' && p_day->type!='U' ){	/*** TM_NORM('E') ***/
			tm.tm_mday=tsec/(24*60*60); tsec =tsec%(24*60*60);
			tm.tm_hour=tsec/(60*60);    tsec =tsec%(60*60);
			tm.tm_min =tsec/(60);       tsec =tsec%(60);
			tm.tm_sec =tsec;             p_tm=&tm;           asgn_tm2dtab(p_tm,a,'E'); /* 'E'=Elp  */ }
		else{                            p_tm=gmtime(&tsec); asgn_tm2dtab(p_tm,a,'A'); /* 'A'=All  */ }
	}
	e=ds2p_dtab(a,"sec"); e->dval+=frac;

	a->attr |= ATTR_STID; return ans;	/*** Arry&Hash => StId ***/
}
ctree *i_utc2ltz(ctree *ctr){ /*** TT-Lang: A = UTC2LTZ(X) ***/ return do_tm2tm(ctr,'+'); }
ctree *i_ltz2utc(ctree *ctr){ /*** TT-Lang: A = LTZ2UTC(X) ***/ return do_tm2tm(ctr,'-'); }
ctree *i_tm_norm(ctree *ctr){ /*** TT-Lang: A = TM_NORM(X) ***/ return do_tm2tm(ctr,'0'); }
