/*** USRMISC.C ***/						#include	"main.h"

#ifdef	USER

#define	Dx	0.01
#define	Dt	1.00
#define	Du	+2.0E-5
#define	Dv	+1.0E-5

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_grayscott(ctree *ctr){			/*** TT-Lang: A = GRAYSCOTT(U,V,Gs,F,K) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*dtab_a,*dtab_u,*dtab_v,*dtab_g,*dtab_f,*dtab_k;
double	*pu,*pv,f,k;	static double *lu,*lv,*dudt,*dvdt;
tint	xa,xb,x,ya,yb,y,gs,sq;

/* Set Param(s) & Check Type(s) */
	dtab_u = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(dtab_u,"P" ,0);	// U
	dtab_v = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(dtab_v,"P" ,1);	// V
	dtab_g = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(dtab_g,"ID",2);	// GRID_SIZE
	dtab_f = ctr2p_dtab( par=lptr(ctr,3) ); chk_vtype(dtab_f,"ID",3);	// F
	dtab_k = ctr2p_dtab( par=lptr(ctr,4) ); chk_vtype(dtab_k,"ID",4);	// K
	dtab_a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

	pu = cptr(dtab_u);					// Ptr2U
	pv = cptr(dtab_v);					// Ptr2V
	gs = cint(dtab_g);					// Grid Size
	f  = cdbl(dtab_f);					// F Value
	k  = cdbl(dtab_k);					// K Value

/* Do GRAYSCOTT()!! */
// 初回：初期化の実施（領域確保＋オール0or1＋中央に正方形＋全体にノイズ混入）
	if( pu==NULL && pv==NULL ){
		sq=20;							// Square Size
		dtab_u->ptr = pu = X_MALL(gs*gs*sizeof(double));	// U-World  : Zero Cleared!!
		dtab_v->ptr = pv = X_MALL(gs*gs*sizeof(double));	// V-World  : Zero Cleared!!
		lu               = X_MALL(gs*gs*sizeof(double));	// Laplace_u: Zero Cleared!!
		lv               = X_MALL(gs*gs*sizeof(double));	// Laplace_v: Zero Cleared!!
		dudt             = X_MALL(gs*gs*sizeof(double));	// DuDt     : Zero Cleared!!
		dvdt             = X_MALL(gs*gs*sizeof(double));	// DvDt     : Zero Cleared!!
		for( y=0 ; y<gs ; y++ ){
			for( x=0 ; x<gs ; x++ ){
				pu[y*gs+x] = ( (x<gs/2-sq/2||gs/2+sq/2<x||y<gs/2-sq/2||gs/2+sq/2<y)?1.00:0.50 ) + rand()/(RAND_MAX+1.0)*0.10 ;
				pv[y*gs+x] = ( (x<gs/2-sq/2||gs/2+sq/2<x||y<gs/2-sq/2||gs/2+sq/2<y)?0.00:0.25 ) + rand()/(RAND_MAX+1.0)*0.10 ;
			}
		}

	goto INIT_END;
	}

// ラプラシアンの計算
	for( y=0 ; y<gs ; y++ ){
		for( x=0 ; x<gs ; x++ ){
			yb = y-1<0    ? gs-1 : y-1 ;
			ya = y+1>gs-1 ? 0    : y+1 ;
			xb = x-1<0    ? gs-1 : x-1 ;
			xa = x+1>gs-1 ? 0    : x+1 ;
			lu[y*gs+x] = ( pu[y*gs+xa]+pu[y*gs+xb]+pu[ya*gs+x]+pu[yb*gs+x] - 4.0*pu[y*gs+x] ) / (Dx*Dx) ;
			lv[y*gs+x] = ( pv[y*gs+xa]+pv[y*gs+xb]+pv[ya*gs+x]+pv[yb*gs+x] - 4.0*pv[y*gs+x] ) / (Dx*Dx) ;
		}
	}
// PU&PV の更新
	for( y=0 ; y<gs ; y++ ){
		for( x=0 ; x<gs ; x++ ){
			dudt[y*gs+x] = Du*lu[y*gs+x] - pu[y*gs+x]*pv[y*gs+x]*pv[y*gs+x] + f*(1.0-pu[y*gs+x]);
			dvdt[y*gs+x] = Dv*lv[y*gs+x] + pu[y*gs+x]*pv[y*gs+x]*pv[y*gs+x] - (f+k) *pv[y*gs+x] ;
			pu[y*gs+x] += Dt*dudt[y*gs+x];
			pv[y*gs+x] += Dt*dvdt[y*gs+x];
		}
	}

// 戻り値(VOID)
INIT_END:
	void_dtab(dtab_a); return ans;
}

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *i_cellautom(ctree *ctr){			/*** TT-Lang: A = CELLAUTOM(Pt,Gs,Ru) ***/
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*dtab_a,*dtab_p,*dtab_g,*dtab_r;
int		*pt,l,c,r,n;
tint	x,gs,ru;

/* Set Param(s) & Check Type(s) */
	dtab_p = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(dtab_p,"P" ,0);	// PTR
	dtab_g = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(dtab_g,"ID",1);	// GRID_SIZE
	dtab_r = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(dtab_r,"ID",2);	// RULE
	dtab_a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

	pt = cptr(dtab_p);					// Ptr2(Memory)
	gs = cint(dtab_g);					// Grid Size
	ru = cint(dtab_r);					// Rule Value

/* Do CELLAUTOM()!! */
// 初回：初期化の実施（領域確保＋オール0＋中央に1）
	if( pt==NULL ){
		dtab_p->ptr = pt = X_MALL(gs*gs*sizeof(int));	// Grid World: Zero Cleared!!
		pt[gs/2] = 1;

	goto INIT_END;
	}

// CA の更新
	memmove(&pt[gs],&pt[0],gs*(gs-1)*sizeof(int));		// 2行目以降    を更新
	for( x=0 ; x<gs ; x++ ){							// 1行目(先頭行)を更新
		l = pt[ 1*gs + (x-1<0   ?gs-1:x-1) ];
		c = pt[ 1*gs + (x                ) ];
		r = pt[ 1*gs + (x+1>gs-1?0   :x+1) ];
		n = 4*l + 2*c + 1*r ;			// L+C+R Bit -> N
		pt[x] = ((ru>>n)&0x01);			// 1         -> Live
	}

// 戻り値(VOID)
INIT_END:
	void_dtab(dtab_a); return ans;
}

/************************************************************************************************/
// INST_USRMISC() - ユーザー事前定義{定数|関数}のインストール
/************************************************************************************************/
void inst_usrmisc(){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
// ユーザー事前定義{定数}のインストール [ See INST_SYSCNST() ]
	wr_dtab(GL_DTAB,"true"          ,'I',0,TRUE           );
	wr_dtab(GL_DTAB,"fals"          ,'I',0,FALS           );
// ユーザー事前定義{関数}のインストール [ See INST_SYSFUNC() ]
	wr_dtab(GL_DTAB,"grayscott"     ,'X',0,i_grayscott  ,5);
	wr_dtab(GL_DTAB,"cellautom"     ,'X',0,i_cellautom  ,3);
}

#endif
