/*** I_MDFYS.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_xsub(ctree *ctr,int flag_global){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y,*z;
char	*ps,*pe,*ms,*me;
int		alen;
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
regmatch_t	pmatch;						/* /RE/ Substr Address Info Buffer						*/
int			errcode;					/* /RE/ Error Code										*/
/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SP"  ,0);
	y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"SPID",1);
	z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"SPID",2);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

	if( isnull(x)||isnull(y)||isnull(z) ){ null_dtab(a); return ans; }

/* Do XSUB()!! */
	ps = cstr(x);			ms = NULL;			// STR = "... CCC ... CCCMMMMMCCC ... CCC\0"
	pe = ps+strlen2(ps);	me = NULL;			//            ^PS        ^MS  ^ME        ^PE

	if( (y->type=='S'||y->type=='P') && cstr(y)[0]=='\0' ){ null_dtab(a); return ans; }	/* Empty */
	a->type='S'; a->str=X_SDUP("");

// *** Main Loop Start *** //
	for( int idx=0 ; TRUE ; idx++ ){	/* IDX = 0,1,2, ... ( Match Index )						*/

	//+++ Call Regexp +++//
		if( (y->type=='S'||y->type=='P') &&  isreg(y) ){	// XSUB(STR,/RE/,---)
			if( y->ptr2==NULL ){ regcc(y); }				// Compile & Save /RE/
			errcode = regexec(y->ptr2,ps,1,&pmatch,0);		// Try Match
			if( errcode==0 ){								//*** Matched !! ***
				ms = ps+pmatch.rm_so;
				me = ps+pmatch.rm_eo;
				if( pmatch.rm_eo==0 ){ flag_exerr=E_REGINF; last_ct=lptr(ctr,1); return NULL; }	//*** Infinit !! ***
			}
			else{											//*** NoMatch !! ***
				ms = NULL;
				me = NULL;
			}
		}
	//+++ Call Strstr +++//
		if( (y->type=='S'||y->type=='P') && !isreg(y) ){	// XSUB(STR,STR,---)
			ms = strstr(ps,cstr(y));
			me = (ms==NULL) ? NULL:(ms+strlen2(y->str));
		}
	//+++ Call Strchr +++//
		if( y->type=='I' || y->type=='D' ){ 				// XSUB(STR,CHR,---)
			ms = strchr(ps,cint(y));
			me = (ms==NULL) ? NULL:(ms+1             );
		}

	//+++ Copy & Xsub +++//
	/* (NoMatch) */
		if( ms==NULL || me==NULL ){ a->str=X_SCAT(a->str,ps); break; }	/* 0. Copy RemStr */
	/* (Matched) */
		if( ps!=ms       ){ a->str=X_NCAT(a->str,ps,ms-ps);  }			/* 1. Copy PreStr */
		if( z->type=='S' ){ a->str=X_SCAT(a->str,cstr(z) );  }			/* 2. Do Xsub()!! */
		else{
			alen=strlen2(a->str); a->str=X_RALL(a->str,alen+2);
			(a->str)[alen  ]=cint(z)&0xFF;
			(a->str)[alen+1]='\0';
		}
		if( !flag_global ){ a->str=X_SCAT(a->str,me); break; }			/* 3. Copy RemStr - SSUB() Only!! - */
	//+++ Asgn & Next +++/
		if( (ps=me)==pe ){ break; }

	}
	return ans;
}
ctree *i_ssub(ctree *ctr){ /*** TT-Lang: A = SSUB(X,Y,Z) ***/ return do_xsub(ctr,FALS); }
ctree *i_gsub(ctree *ctr){ /*** TT-Lang: A = GSUB(X,Y,Z) ***/ return do_xsub(ctr,TRUE); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_xvalesc(ctree *ctr,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SP",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

	if( isnull(x) ){ null_dtab(a); return ans; }

/* Do XVALESC()!! */
	if( mode=='E' ){ a->type='S'; a->str=evalesc(cstr(x)); /* "\c" => 0x?? */ }
	if( mode=='R' ){ a->type='S'; a->str=rvalesc(cstr(x)); /* 0x?? => "\c" */ }
	return ans;
}
ctree *i_evalesc(ctree *ctr){ /*** TT-Lang: A = EVALESC(X) ***/ return do_xvalesc(ctr,'E'); }
ctree *i_rvalesc(ctree *ctr){ /*** TT-Lang: A = RVALESC(X) ***/ return do_xvalesc(ctr,'R'); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_xc(ctree *ctr,int mode){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
char	cval;			int		i;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"SPID",0);
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

	if( isnull(x) ){ null_dtab(a); return ans; }

/* Do XC()!! */
	if( x->type=='S'||x->type=='P' ){	// Str to Str
		cpy_dtab(a,x);
		for( i=0 ; (a->str)[i]!='\0' ; i++ )
		{ cval = (a->str)[i]; (a->str)[i] = mode=='U' ? (char)toupper((int)cval):(char)tolower((int)cval); }
	}
	else{								// Chr to Chr
		a->type='I'; a->ival = mode=='U' ? toupper(cint(x)):tolower(cint(x));
	}
	return ans;
}
ctree *i_uc(ctree *ctr){ /*** TT-Lang: A = UC(X) ***/ return do_xc(ctr,'U'); }
ctree *i_lc(ctree *ctr){ /*** TT-Lang: A = LC(X) ***/ return do_xc(ctr,'L'); }
