/*** I_ICONV.C ***/						#include	"main.h"

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_t2xymd(ctree *ctr,int zone){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x;
struct	tm *p_tm;		time_t	tsec=0;			tdbl	frac=0.0L;

/* Set Param(s) & Check Type(s) */
	x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
	ans = ext_ctrdtabmult(ctr,6);

/* Do T2XYMD()!! */
	tsec = cint(x) + ( zone=='G' ? 0:LTZ_OFFSET() ); frac = fmod(cdbl(x),1.0L);
	p_tm = gmtime(&tsec);
	a=ctr2p_dtab(lptr(ans,0)); a->type='I'; a->ival=(p_tm->tm_year)+1900;	/* year */
	a=ctr2p_dtab(lptr(ans,1)); a->type='I'; a->ival=(p_tm->tm_mon )+   1;	/* mon  */
	a=ctr2p_dtab(lptr(ans,2)); a->type='I'; a->ival=(p_tm->tm_mday);		/* day  */
	a=ctr2p_dtab(lptr(ans,3)); a->type='I'; a->ival=(p_tm->tm_hour);		/* hour */
	a=ctr2p_dtab(lptr(ans,4)); a->type='I'; a->ival=(p_tm->tm_min );		/* min  */
	a=ctr2p_dtab(lptr(ans,5)); a->type='D'; a->dval=(p_tm->tm_sec )+frac;	/* sec! */
	return ans;
}
ctree *i_t2ymd (ctree *ctr){ /*** TT-Lang: A = T2YMD (X) ***/ return do_t2xymd(ctr,'G'); }
ctree *i_t2lymd(ctree *ctr){ /*** TT-Lang: A = T2LYMD(X) ***/ return do_t2xymd(ctr,'L'); }

/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree *do_xymd2t(ctree *ctr,int zone){
/***1***2***3***4***5***6***7***8***9***A***B***C***D***E***F***G***H***I***J***K***L***M***N****/
ctree	*ans,*par;		dtab	*a,*x,*y,*z,*p,*q,*r;		int		cnt;
struct	tm tm;			time_t	tsec=0;			tdbl	frac=0.0L;
char	*fmt;

/* Set Param(s) & Check Type(s) */
	switch( cnt=lcnt(ctr) ){			/* CNT = ARGC of this Func()							*/
		case 1:							// "1970-01-01" or "00:00:00"
			x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"S" ,0); break;
		case 3:							// (1970,01,01)
			x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
			y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
			z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"ID",2); break;
		case 6:							// (1970,01,01,00,00,00)
			x = ctr2p_dtab( par=lptr(ctr,0) ); chk_vtype(x,"ID",0);
			y = ctr2p_dtab( par=lptr(ctr,1) ); chk_vtype(y,"ID",1);
			z = ctr2p_dtab( par=lptr(ctr,2) ); chk_vtype(z,"ID",2);
			p = ctr2p_dtab( par=lptr(ctr,3) ); chk_vtype(x,"ID",3);
			q = ctr2p_dtab( par=lptr(ctr,4) ); chk_vtype(y,"ID",4);
			r = ctr2p_dtab( par=lptr(ctr,5) ); chk_vtype(z,"ID",5); break;
		default:
			flag_exerr=NgARGCnn; epar[0]=cnt,epar[1]=1,epar[2]=3,epar[3]=6; return NULL;
	}
	a = ctr2p_dtab( ans=ext_ctrdtab(ctr) );

/* Do XYMD2T()!! */

// Init TM ( 1970-01-01 00:00:00 ) - This seems to be required by STRPTIME().
	tm.tm_year = (1970)-1900;			/*** ! ***/
	tm.tm_mon  = (   1)-   1;			/*** ! ***/
	tm.tm_mday = 1;
	tm.tm_hour = 0;	tm.tm_min  = 0;	tm.tm_sec  = 0;
	tm.tm_yday = 0;	tm.tm_wday = 0;	tm.tm_isdst= FALS;

// Set TM
	if( cnt==1 ){						/*** ymd2t("                   ")	***/
		if(strlen2(x->str)==10)			/*** ymd2t("1970-01-01"         )	***/
			fmt=       FMT_SDATE();
		else							/*** ymd2t("1970-01-01 00:00:00")	***/
			fmt=X_SCAT(FMT_SDATE(),FMT_STIME());
		if( strptime(x->str,fmt,&tm)==NULL ){ flag_exerr=NgARGVAL; last_ct=lptr(ctr,0); return NULL; }
	}
	if( cnt==3 ){						/*** ymd2t( 1970,01,01 )			***/
		tm.tm_year = cint(x)-1900;		/*** ! ***/
		tm.tm_mon  = cint(y)-1;			/*** ! ***/
		tm.tm_mday = cint(z);			frac = 0.0L;
	}
	if( cnt==6 ){						/*** ymd2t( 1970,01,01,00,00,00 )	***/
		tm.tm_year = cint(x)-1900;		/*** ! ***/
		tm.tm_mon  = cint(y)-1;			/*** ! ***/
		tm.tm_mday = cint(z);			frac = 0.0L;
		tm.tm_hour = cint(p);
		tm.tm_min  = cint(q);
		tm.tm_sec  = cint(r);			frac = fmod(cdbl(z),1.0L);
	}

// Set Result
	tsec = mktime(&tm) + gl_gmtoff - ( zone=='G' ? 0:LTZ_OFFSET() );
	a->type='D'; a->dval=tsec+frac; return ans;
}
ctree *i_ymd2t (ctree *ctr){ /*** TT-Lang: A = YMD2T (X[,Y,Z[,P,Q,R]) ***/ return do_xymd2t(ctr,'G'); }
ctree *i_lymd2t(ctree *ctr){ /*** TT-Lang: A = LYMD2T(X[,Y,Z[,P,Q,R]) ***/ return do_xymd2t(ctr,'L'); }
