/*** FSUP.C - Flex(1) Support Code in C-Lang {yytext|yyleng|yylineno} ***/

/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
/* Define Macro(s) for FLEX */
#define	f(MSG)		if( flag_debug&DF_FLEX ){\
	int adj = (strchr(yytext,'\n')==NULL)?0:1 ;\
	eprin("[%sFs%s] YYTEXT = \"%s\" %s ", C_GRE(2), C_DEF(2), rvalesc(yytext), MSG);\
	eprin("[File=%d,Line=%d,Colm=%d]\n" , sx, yylineno-adj, gl_colm);\
}
#define	YY_NO_INPUT	1					/* Supress Flex Error - "INPUT defined but not used"	*/
#undef	YY_INPUT						/* UnDefine & ReDefine YY_INPUT() Macro for Replace		*/
#define	YY_INPUT(buf,ret,max)	(ret=yy_input2(buf,max))

/* SET_X(): 文字列等の先頭位置情報を一時変数に保存します。(又、フラグを上げます。)				*/
#define	set_x()		{ int adj = (strchr(yytext,'\n')==NULL)?0:1 ;\
	x_data=TRUE; x_file=sx; x_line=(yylineno-adj); x_colm=gl_colm;\
}
/* SET_P(): トークン又は文字列等の先頭位置情報を yylval に設定します。(又、フラグを下げます。)	*/
#define	set_p()		{ int adj = (strchr(yytext,'\n')==NULL)?0:1 ;\
	if(x_data){ x_data=FALS; yylval.tk.file=x_file; yylval.tk.line=x_line        ; yylval.tk.colm= x_colm; }\
	else{       x_data=FALS; yylval.tk.file=sx    ; yylval.tk.line=(yylineno-adj); yylval.tk.colm=gl_colm; }\
}
/* ADJ_I(): (次回トークン用に)スコープ情報、カラム位置情報、及び、パース状態を調整します。		*/
// パース状態は、"/" と "/RE/" や "<<" と "<<STR>>" の判別、及び、排他的ステートに利用します。
// 値を持つ可能性のあるトークンに続くことが出来るのは、演算子(S_OPER)のみです。
// 値を持つ可能性のないトークンに続くことが出来るのは、即  値(S_IMED)のみです。(初期値)
// ただし、既に排他的ステートにある時はそのパース状態を継続(S_KEEP)しなければなりません。
// すなわち、パース状態はS_KEEP指定時には継続し、それ以外の指定時には指定値に移行します。また、
// 内包的ステートは S_IMED&INITIA->INITIAL とし、実際には S_OPER のみをマッチ抑制用に利用します。
#define	adj_i(STAT)	{\
	if(yytext[yyleng-1]=='\n'){			/* 行末（gl_skip が負の時は、改行された    ことを示します。）*/\
		gl_skip=-yyleng; gl_colm=1;       if(yyleng==2&&yytext[0]=='\\'){ ; }else{ flag_global=flag_local=flag_static=0; }\
	}\
	else{								/* 途中（gl_skip が正の時は、改行されてないことを示します。） */\
		gl_skip=+yyleng; gl_colm+=yyleng;\
	}\
	if(STAT!=S_KEEP){ BEGIN((STAT==S_IMED||STAT==INITIA)?INITIAL:STAT); }\
}

#define	inst_imedstr(SVAL)		yylval.tk.cdx=idx2cdx('L',wr_dtab(mp_base+LC_DTAB,"(IMED)",'S',0,      SVAL))
#define	inst_imedreg(SVAL)		yylval.tk.cdx=idx2cdx('L',wr_dtab(mp_base+LC_DTAB,"(IMED)",'~',0,      SVAL))
#define	inst_imedint(IVAL)		yylval.tk.cdx=idx2cdx('L',wr_dtab(mp_base+LC_DTAB,"(IMED)",'I',0,(tint)IVAL))
#define	inst_imeddbl(DVAL)		yylval.tk.cdx=idx2cdx('L',wr_dtab(mp_base+LC_DTAB,"(IMED)",'D',0,(tdbl)DVAL))

/* Define Variable(s) for FLEX */
int		flag_global=FALS;						// Flag for GLOBAL Scope (T/F)
int		flag_static=FALS;						// Flag for STATIC Scope (T/F)
int		flag_local =FALS;						// Flag for LOCAL  Scope (T/F)

char	*sbuf;	int		slen;					// Pointer to "STR" & Length of "STR"
int		x_data=FALS, x_file, x_line, x_colm;	// Starting Position for Multi Token Data

/************************************************************************************************/
// {FN()|FV()} return {FileName|FileLinv} from FileTb[].
/************************************************************************************************/
char * fn(int idx){ return(FileTb[idx].name); }
char **fv(int idx){ return(FileTb[idx].linv); }
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/

/************************************************************************************************/
// YY_INPUT2() replace YY_INPUT().  It utilize GNU ReadLine when TT-Engine is in "-i" mode.
/************************************************************************************************/
int yy_input2(char *buf,int max_size){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
static int	flag_rlinit=FALS;			/* Flag for ReadLine() Initial Status             (T/F) */
static char	*p_curr, *p_prev;			/* Curr/Prev Input String								*/
char	prompt[BUFSIZ];					/* Buffer for Prompt String								*/
int		len;							/* Input Length											*/
/* Non-Interactive Mode => Disable ReadLine()!!                                */
	if( flag_imode!='I' ){
		if( fgets(buf,max_size,yyin)==NULL ){ return(0); }
		return strlen2(buf);
	}
/* Init ReadLine()      => Enable  ReadLine()!! *** Disable TAB Completion *** */
	if( flag_rlinit==FALS ){ flag_rlinit=TRUE; rl_bind_key('\t',rl_insert); p_curr=NULL; p_prev=NULL; }
/* Make Promtp String ( Avoid ANSI-Color in PROMPT[] - It's Buggy. ) */
	sprintf(prompt,"%s> ",TTdeAM_CMD);
/* Do ReadLine() */
	p_curr=readline(prompt);			// Display Prompt & Read Data
	if( p_curr==NULL ){					// ( EOF )
		printf("\n"); buf[0]='\0'; free(p_prev); p_prev=NULL; return(0);	/* free() => NULL Safe */
	}
	else{								// (NoEOF)
		strncpy2(buf,p_curr,max_size-1); strcat2(buf,"\n");
		FileTb[sx].linv = set_scriptbyargv(buf);	// This is required for Error Message!!
		len=strlen2(buf);
	// Add input string into GNU ReadLine History, if it is Unique && Non-Empty. //
		if( len!=1 && (p_prev==NULL||strcmp(p_curr,p_prev)!=0) ){
			add_history(p_curr); free(p_prev); p_prev=p_curr; p_curr=NULL;	/* free() => NULL Safe */
		}
	}
	return(len);
}

/************************************************************************************************/
// CHK_RSVDKEYWD() check Reserved Keyword, and return matched Token Number (!=0) or Zero.
/************************************************************************************************/
int chk_rsvdkeywd(char *str){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
/* Match to Reserved Keyword */
	if( strcmp(str,"global"  )==0							){ f("[GLKW]"); flag_global=1; return(GLKW); }
	if( strcmp(str,"static"  )==0							){ f("[STKW]"); flag_static=1; return(STKW); }
	if( strcmp(str,"local"   )==0							){ f("[LCKW]"); flag_local =1; return(LCKW); }
	if( strcmp(str,"func"    )==0 || strcmp(str,"def"  )==0	){ f("[DEFX]");                return(DEFX); }
	if( strcmp(str,"if"      )==0							){ f("[IF  ]");                return(IF  ); }
	if( strcmp(str,"elif"    )==0							){ f("[ELIF]");                return(ELIF); }
	if( strcmp(str,"else"    )==0							){ f("[ELSE]");                return(ELSE); }
	if( strcmp(str,"switch"  )==0 || strcmp(str,"swch" )==0	){ f("[SWCH]");                return(SWCH); }
	if( strcmp(str,"case"    )==0							){ f("[CASE]");                return(CASE); }
	if( strcmp(str,"default" )==0 || strcmp(str,"deft" )==0	){ f("[DEFT]");                return(DEFT); }
	if( strcmp(str,"while"   )==0							){ f("[WHIL]");                return(WHIL); }
	if( strcmp(str,"do_while")==0							){ f("[DOWH]");                return(DOWH); }
	if( strcmp(str,"for"     )==0							){ f("[FORS]");                return(FORS); }
	if( strcmp(str,"loop"    )==0							){ f("[LOOP]");                return(LOOP); }
	if( strcmp(str,"each"    )==0							){ f("[EACH]");                return(EACH); }
	if( strcmp(str,"continue")==0 || strcmp(str,"next" )==0	){ f("[NEXT]");                return(NEXT); }
	if( strcmp(str,"last"    )==0 || strcmp(str,"break")==0	){ f("[LAST]");                return(LAST); }
	if( strcmp(str,"return"  )==0 || strcmp(str,"retn" )==0	){ f("[RETN]");                return(RETN); }
/* NoMatch */
	return(0);
}

/************************************************************************************************/
// CONV_ESC2INT() convert 2nd character of ESC Sequence into ASCII code.
/************************************************************************************************/
int conv_esc2int(char cval){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	switch(cval){
		case '0': return(0x00); case 'a': return('\a'); case 'b': return('\b');
		case 't': return('\t'); case 'n': return('\n'); case 'v': return('\v');
		case 'f': return('\f'); case 'r': return('\r'); case 'e': return(0x1B);	/*** ESC  ***/
		default:  return(cval);													/*** AsIs ***/
	}
}

/************************************************************************************************/
// SAVCHG_F4YY save(push) & change Input Stream for YYIN. [ Data =  FileName||TT-Script ]
/************************************************************************************************/
void savchg_f4yy(int mode,char *data){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
static int flag_ftinit=FALS;			/* Static Flag for FileTb[] Init Status           (T/F) */
char	*p_open;						/* Pointer to File Name to Open							*/
int		flag_direct;					/* Flag for Direct Use of NAME                    (T/F) */
int		prev,curr,next;					/* Index for FileTb[]									*/

// 1、現在位置(=最終位置) CURR と、新規位置 NEXT を求めてリンクを設定する。
// 2、現在位置 CURR に、復帰の為に必要な情報をセーブする。
// 3、新規位置 NEXT に、遷移の為に必要な情報をセーブして、そこに遷移する。

/* Init FileTb[] ( 1st Call Only ) */
	if( flag_ftinit==FALS ){
		flag_ftinit=TRUE;
		FileTb[0].alloc = IFT_SIZE;
		FileTb[0].valid = 1;			// Number of Valid Element
		FileTb[0].next  = INVA;
		FileTb[0].prev  = INVA;
		prev=INVA; curr=INVA; next=0;	goto NEXT_ONLY;
	}

/* Save Curr Data */
	curr=0; while(FileTb[curr].next!=INVA){ curr=FileTb[curr].next; } prev=FileTb[curr].prev;
	next = (FileTb[0].valid)++;			// NEXT = Index of Unused Element

	if( FileTb[0].alloc <= next )		/*** Check OverFlow!! ***/
		dying("Panic!! - Out Of FileTb[] (Alloc=%d,next=%d)\n",FileTb[0].alloc,next);

	FileTb[curr].next = next;
	FileTb[curr].ybuf = YY_CURRENT_BUFFER;
	FileTb[curr].ylin = yylineno-1;
	FileTb[curr].mode = flag_imode;

/* Exec Change ( Goto Next Data ) */
NEXT_ONLY:;
	FileTb[next].prev = curr;
	FileTb[next].next = INVA;
	FileTb[next].mode = flag_imode = mode; yylineno = 1;  sx = next;
	switch( mode ){

		case 'N': case'I':		// Data = FileName || /dev/stdin

// ファイル名（パス名）を加工せずに、そのままの文字列でオープンするかどうかを判定するフラグを設定します。
// このフラグは、絶対パス名で指定されている場合、親ファイル（最初のファイル）である場合、及び、
// 親ファイルのパス情報が無い子ファイル場合に真となります。
// それらに加えて、対話モードから直接インクルードされている場合も真となります。
			flag_direct = (data[0]=='/'||next==0||FileTb[FileTb[next].prev].path==NULL);
			if( next!=0 && FileTb[FileTb[next].prev].mode=='I' ){ flag_direct = TRUE; }

			FileTb[next].name = X_SDUP(data);
			if( flag_direct )
				FileTb[next].path = X_SDUP( dirname(X_SDUP(data)) );
			else{
				FileTb[next].path = X_SCAT( FileTb[FileTb[next].prev].path , "/"                   );
				FileTb[next].path = X_SCAT( FileTb[       next      ].path , dirname(X_SDUP(data)) );
			}
			if( mode=='I' || strcmp(data,"-")==0 ){
				yyin=stdin;		FileTb[next].linv = NULL;
			}
			else{
				if( flag_direct )		// Raw      Path Name
					p_open = data;
				else{					// Relative Path Name
					p_open = FileTb[next].path;
					p_open = X_SCAT( p_open , "/"                    );
					p_open = X_SCAT( p_open , basename(X_SDUP(data)) );
				}
				if( (yyin=fopen(p_open,"r")) == NULL )
//					dying("Master!! - cannot open file \"%s\" %s",data,sloc(prev,FileTb[prev].ylin));
					dying("Master!! - cannot open file \"%s\"\n" ,data                             );

				/* :code 設定 */
				if( FileTb[0].valid==1 ) reinit_code(p_open,0);

				FileTb[next].linv = set_scriptbyfile(p_open);
			}
			yy_switch_to_buffer( yy_create_buffer(yyin,YY_BUF_SIZE) );	break;

		case 'E': case '$':		// Data = TT-Script || ${...}
			FileTb[next].path = NULL;
			FileTb[next].name = NULL;
			FileTb[next].linv = set_scriptbyargv(data);
			yy_switch_to_buffer( yy_scan_string(data)               );	break;

		default: assert(FALS);

	}
}

/************************************************************************************************/
// RESCHG_F4YY restore(pop) & change Input Stream for YYIN.
/************************************************************************************************/
void reschg_f4yy(void){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
int		prev,curr/*,next*/;				/* Index for FileTb[]									*/

// 1、現在位置(=最終位置) CURR と、直前位置 PREV を求める。
// 2、現在位置へのリンクを切断してから、直前位置へ復帰する。
// なお、原則として切断された要素の再利用は行わない。(例外あり。)

/* Void Curr Data ( We don't adjust valid, because we don't reuse Elmt in general. ) */
	curr=0; while(FileTb[curr].next!=INVA){ curr=FileTb[curr].next; } prev=FileTb[curr].prev;
	FileTb[curr].prev = INVA;			// Clear!! - Void Elmt
	FileTb[prev].next = INVA;			// Clear!! - Void Elmt

// ただし、切断された要素が'$'{} 評価モードであり、かつ、それが最後のエレメントであったときは、
// 切断された要素の再利用を行なう。(実行時バッファーオーバーフロー対策)
	if( FileTb[curr].mode=='$' && FileTb[0].valid-1==curr ) FileTb[0].valid--;

/* Exec Change ( Goto Prev Data ) */
	yy_delete_buffer(YY_CURRENT_BUFFER);
	yy_switch_to_buffer(FileTb[prev].ybuf);
	flag_imode = FileTb[prev].mode  ;
	yylineno   = FileTb[prev].ylin+1; sx = prev;	/*** +1 for :r line ***/
}

/************************************************************************************************/
// SLOC() return <ErrLOC+ErrSRC> string for Scanner & Parser Phase. [ Use GL_COLM,GL_SKIP & Call ELOC() ]
// ELOC() return <ErrLOC+ErrSRC> string for TT-Engine Exec   Phase. [ Use LAST_CT,EPOS                  ]
// 以下の２パターンについても適切に処理をします。（参考：空スクリプトはエラーにはなりません。）
// (A) 改行付き行  末の直後に、文法エラーが発生しているパターン。
// (B) 改行無し文字列において、文法エラーが発生しているパターン。
/************************************************************************************************/
char *sloc(int fileid,int line){
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	**linv;		static ctree c_tmp;	// This must be static, because DIAG() will use this data.
/* Check Pattern (A) */
	linv   = FileTb[fileid].linv; if( linv==NULL ){ last_ct=NULL; return eloc(); }
/* Set Dummy */
// 文法エラーは、先読みトークンを読み込み＆認識した時点で発生します。この時、位置情報は先読みトーク
// ンの次を指し示しています。このため、エラーの発生位置を先読みトークンの先頭に戻す必要があります。
	c_tmp.op   = c_tmp.init           = 0x00;
	c_tmp.l    = c_tmp.r    = c_tmp.x = NULL;
	c_tmp.file = fileid;
	c_tmp.line = (gl_skip<0) ? line-1                         :line           ;		// 改行された？行    の後退
	c_tmp.colm = (gl_skip<0) ? strlen2(linv[line-2])+1+gl_skip:gl_colm-gl_skip;		// 改行された？カラムの後退
	if( flag_vfile<0 )							// Virtual File { /dev/stdin | ****** }
		c_tmp.colm = (gl_skip<0) ? strlen2( linv[0])+1+gl_skip:gl_colm-gl_skip;		// 改行された？カラムの後退
	last_ct = &c_tmp;
	epos    = 0;
	return eloc();
}

char *eloc(void){						// Format = "[File="%s",Line=%d]\n" + "> src\n" + ">  ^ \n"
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
char	*ans, tmp[BUFSIZ];			ctree	*ct=lptra(last_ct,epos);
int		i,j,len;
/* Make Format (Line= 1 ) */
// Virtual File であっても、ファイル名・行番号・カラムの位置情報は正しく設定されています。しかし、
// 標準入力から読み込まれたスクリプトは、直近１行のみが linv[0] に上書き保存されているだけです。
	if( ct==NULL ) return X_SDUP("\n");			// No Data!!
	sprintf(tmp,"[File=\"%s\",Line=%d]\n",basename(fn(ct->file)),ct->line); ans=X_SDUP(tmp);	/* ANS=1     */
	len = strlen2(ans);							// Start Position of Line=2
/* Make Format (Line=2&3) */
	if( flag_vfile<0 )							// Virtual File { /dev/stdin | ****** }
		sprintf(tmp,"> %s",fv(ct->file)[0           ]);
	else
		sprintf(tmp,"> %s",fv(ct->file)[(ct->line)-1]);
	if( tmp[strlen2(tmp)-1] == '\n' ){                                 ans=X_SCAT(ans,tmp ); }	/* ANS=1+2   */
	else{                                         ans=X_SCAT(ans,tmp); ans=X_SCAT(ans,"\n"); }	/* ANS=1+2   */
	for( i=len,j=0 ; j<(ct->colm)+2 ; i++,j++ ){// Rewirte TMP[]  [ +2 for "> " ]
		if( j==(ct->colm)+2-1 )					// Yes-Error Colm [ +2 for "> " ]
			sprintf(&tmp[j],"%s%c%s\n",C_YEL(2),'^',C_DEF(2));
		else{									// Non-Error Colum
			if( isspace(ans[i]) ){ tmp[j]=ans[i]; }		// '\f' '\n' '\r' '\v' -> AsIs
			else                 { tmp[j]=' ';    }		// '*'                 -> ' '
		}
	}
	return ans=X_SCAT(ans,tmp);																	/* ANS=1+2+3 */
}

/************************************************************************************************/
// PARAM1() return 1st param value in ":CMD" or 0 if not exist. ( "PARAM1,PARAM2" )
// PARAM2() return 2nd param value in ":CMD" or 0 if not exist. ( "PARAM1,PARAM2" )
/************************************************************************************************/
tint param1(char *ptr){					// Dec | Hex - Auto Select -
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( ptr==NULL                                ){ return(0); } while( isblank(*ptr) ) ptr++;
	return( ptr[0]=='0'&&(ptr[1]=='X'||ptr[1]=='x') ? strtol(ptr,(char **)NULL,16):atol(ptr) );
}

tint param2(char *ptr){					// Dec | Hex - Auto Select -
/*--1---2---3---4---5---6---7---8---9---A---B---C---D---E---F---G---H---I---J---K---L---M---N---*/
	if( ptr==NULL || (ptr=strchr(ptr,','))==NULL ){ return(0); } while( isblank(*ptr) ) ptr++;
	return( ptr[0]=='0'&&(ptr[1]=='X'||ptr[1]=='x') ? strtol(ptr,(char **)NULL,16):atol(ptr) );
}
