/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.dm;

import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.DocumentParser;
import net.xfra.qizxopen.dm.FONIDM;
import net.xfra.qizxopen.dm.FONIDocument;
import net.xfra.qizxopen.dm.Node;
import net.xfra.qizxopen.util.Util;
import org.xml.sax.SAXException;

public class DocumentManager
extends DocumentParser {
    private static final int MIN_CACHE_SIZE = 131072;
    private static final String CACHE_SIZE_PROP = "net.xfra.qizxopen.docman.cachesize";
    private long cacheSize = 0x800000L;
    private Vector cache = new Vector();
    protected URL baseURL;

    public DocumentManager(URL uRL) {
        this.init(uRL);
    }

    public DocumentManager(String string) throws IOException {
        this.init(Util.uriToURL(string));
    }

    public String getBaseURI() {
        return this.baseURL.toString();
    }

    public synchronized void setCacheSize(long l) {
        this.cacheSize = Math.max(l, 131072L);
    }

    protected URL resolveLocation(String string) throws IOException {
        return new URL(this.baseURL, string);
    }

    private void init(URL uRL) {
        block2: {
            super.init();
            this.baseURL = uRL;
            String string = System.getProperty(CACHE_SIZE_PROP);
            if (string == null) break block2;
            try {
                this.setCacheSize(Long.parseLong(string));
            }
            catch (Exception exception) {}
        }
    }

    public Node findDocumentNode(String string) throws DataModelException {
        FONIDocument fONIDocument = this.findDocument(string);
        FONIDM fONIDM = new FONIDM(fONIDocument);
        return fONIDM.documentNode();
    }

    public FONIDocument findDocument(String string) throws DataModelException {
        try {
            URL uRL = this.resolveLocation(string);
            FONIDocument fONIDocument = this.getCachedDocument(uRL.toString());
            if (fONIDocument == null) {
                try {
                    fONIDocument = this.parseDocument(uRL);
                }
                catch (SAXException sAXException) {
                    throw new DataModelException("XML parsing error in " + string + ": " + sAXException.getMessage(), sAXException.getException());
                }
            }
            if (fONIDocument == null) {
                throw new DataModelException(string + " (document cannot be located)");
            }
            this.cacheDocument(fONIDocument);
            return fONIDocument;
        }
        catch (IOException iOException) {
            throw new DataModelException("document cannot be opened: " + string, iOException);
        }
    }

    protected synchronized FONIDocument getCachedDocument(String string) {
        int n = 0;
        int n2 = this.cache.size();
        while (n < n2) {
            FONIDocument fONIDocument = (FONIDocument)this.cache.get(n);
            if (string.equals(fONIDocument.getBaseURI())) {
                this.cache.remove(n);
                this.cache.insertElementAt(fONIDocument, 0);
                return fONIDocument;
            }
            ++n;
        }
        return null;
    }

    protected synchronized void cacheDocument(FONIDocument fONIDocument) {
        if (!this.cache.contains(fONIDocument)) {
            this.cache.insertElementAt(fONIDocument, 0);
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.cache.size();
        while (n2 < n3) {
            FONIDocument fONIDocument2 = (FONIDocument)this.cache.get(n2);
            int n4 = fONIDocument2.estimateMemorySize();
            if ((long)(n + n4) > this.cacheSize) {
                this.cache.setSize(n2);
                break;
            }
            n += n4;
            ++n2;
        }
    }
}

