/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.dm;

import com.sun.resolver.CatalogManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.xfra.qizxopen.dm.FONIDM;
import net.xfra.qizxopen.dm.FONIDocument;
import net.xfra.qizxopen.dm.FONIWriter;
import net.xfra.qizxopen.dm.IDocument;
import net.xfra.qizxopen.dm.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DocumentParser {
    protected SAXParserFactory factory;
    protected EntityResolver entityResolver;
    static final String SAXLEX = "http://xml.org/sax/properties/lexical-handler";

    public DocumentParser() {
        this.init();
    }

    protected void init() {
        this.factory = SAXParserFactory.newInstance();
        this.factory.setNamespaceAware(true);
        System.setProperty("entityExpansionLimit", "1000000000");
        try {
            Class<?> clazz = Class.forName("com.sun.resolver.tools.CatalogResolver");
            CatalogManager.ignoreMissingProperties((boolean)true);
            this.entityResolver = (EntityResolver)clazz.newInstance();
        }
        catch (Exception exception) {}
    }

    public XMLReader newParser() throws SAXException {
        try {
            SAXParser sAXParser = this.factory.newSAXParser();
            return sAXParser.getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException("cannot create parser", parserConfigurationException);
        }
    }

    public static Node parse(InputSource inputSource) throws SAXException, IOException {
        DocumentParser documentParser = new DocumentParser();
        IDocument iDocument = new IDocument();
        documentParser.parseDocument(inputSource, iDocument);
        FONIDM fONIDM = new FONIDM(iDocument);
        return fONIDM.documentNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FONIDocument parseDocument(URL uRL) throws SAXException, IOException {
        InputStream inputStream = uRL.openStream();
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(uRL.toExternalForm());
        FONIDocument fONIDocument = null;
        try {
            fONIDocument = this.parseDocument(inputSource);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return fONIDocument;
    }

    public FONIDocument parseDocument(InputSource inputSource) throws SAXException, IOException {
        IDocument iDocument = new IDocument();
        this.parseDocument(inputSource, iDocument);
        return iDocument;
    }

    public void parseDocument(InputSource inputSource, FONIWriter fONIWriter) throws SAXException, IOException {
        this.parseDocument(inputSource, fONIWriter, this.newParser());
    }

    public void parseDocument(InputSource inputSource, FONIWriter fONIWriter, XMLReader xMLReader) throws SAXException, IOException {
        try {
            xMLReader.setProperty(SAXLEX, fONIWriter);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.entityResolver != null) {
            xMLReader.setEntityResolver(this.entityResolver);
        } else {
            xMLReader.setEntityResolver(fONIWriter);
        }
        xMLReader.setDTDHandler(fONIWriter);
        xMLReader.setContentHandler(fONIWriter);
        xMLReader.setErrorHandler(fONIWriter);
        long l = System.currentTimeMillis();
        xMLReader.parse(inputSource);
    }
}

