/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.dm;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.Node;
import net.xfra.qizxopen.dm.XMLEventReceiverBase;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;

public class XMLSerializer
extends XMLEventReceiverBase {
    public static final String METHOD = "method";
    public static final String ENCODING = "encoding";
    public static final String VERSION = "version";
    public static final String OMIT_XML_DECLARATION = "omit-xml-declaration";
    public static final String STANDALONE = "standalone";
    public static final String DOCTYPE_SYSTEM = "doctype-system";
    public static final String DOCTYPE_PUBLIC = "doctype-public";
    public static final String MEDIA_TYPE = "media-type";
    public static final String ESCAPE_URI_ATTRIBUTES = "escape-uri-attributes";
    public static final String INCLUDE_CONTENT_TYPE = "include-content-type";
    public static final String INDENT = "indent";
    public static final String INDENT_VALUE = "indent-value";
    static Namespace XHTML = Namespace.get("http://www.w3.org/1999/xhtml");
    protected BufferedWriter out = new BufferedWriter(new OutputStreamWriter(System.out));
    protected String outputFile = null;
    protected Method method = new XMLMethod();
    protected boolean omitXmlDecl = false;
    protected boolean escapeUriAttr = true;
    protected boolean includeContentType = true;
    protected boolean standalone = false;
    protected boolean indents = true;
    protected boolean dummy = false;
    protected int maxDepth = -1;
    protected int indentValue = 2;
    protected String encoding = "UTF-8";
    protected String version = "1.0";
    protected String mediaType;
    protected String publicId = null;
    protected String systemId = null;
    protected boolean enableIndent;
    protected boolean firstElement;
    protected String indent = "  ";
    protected String PI_END = "?>";
    protected String EMPTY_END = "/>";

    public XMLSerializer() {
    }

    public XMLSerializer(String string) throws DataModelException {
        this.setOption(METHOD, string);
    }

    public XMLSerializer(Writer writer) {
        this.setOutput(writer);
    }

    public void output(Node node) throws DataModelException {
        this.reset();
        this.startDocument();
        this.depth = 0;
        this.traverse(node, true);
        this.endDocument();
        this.terminate();
    }

    public void setOutput(OutputStream outputStream, String string) {
        OutputStreamWriter outputStreamWriter = string == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, Charset.forName(string));
        this.out = new BufferedWriter(outputStreamWriter);
    }

    public void setOutput(Writer writer) {
        this.out = new BufferedWriter(writer);
    }

    public BufferedWriter getOutput() {
        return this.out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOption(String string, String string2) throws DataModelException {
        if (string.equalsIgnoreCase(METHOD)) {
            if (string2.equalsIgnoreCase("XML")) {
                this.method = new XMLMethod();
                return;
            } else if (string2.equalsIgnoreCase("XHTML")) {
                this.method = new HTMLMethod(true);
                return;
            } else if (string2.equalsIgnoreCase("HTML")) {
                this.method = new HTMLMethod(false);
                this.omitXmlDecl = true;
                return;
            } else {
                if (!string2.equalsIgnoreCase("TEXT")) throw new DataModelException("invalid method: " + string2);
                this.method = new TextMethod();
            }
            return;
        } else if (string.equalsIgnoreCase(ENCODING)) {
            this.encoding = string2;
            return;
        } else if (string.equalsIgnoreCase(VERSION)) {
            this.version = string2;
            return;
        } else if (string.equalsIgnoreCase(OMIT_XML_DECLARATION)) {
            this.omitXmlDecl = this.boolOption(string, string2);
            return;
        } else if (string.equalsIgnoreCase(STANDALONE)) {
            this.standalone = this.boolOption(string, string2);
            return;
        } else if (string.equalsIgnoreCase(DOCTYPE_SYSTEM)) {
            this.systemId = string2;
            return;
        } else if (string.equalsIgnoreCase(DOCTYPE_PUBLIC)) {
            this.publicId = string2;
            return;
        } else if (string.equalsIgnoreCase(MEDIA_TYPE)) {
            this.mediaType = string2;
            return;
        } else if (string.equalsIgnoreCase(ESCAPE_URI_ATTRIBUTES)) {
            this.escapeUriAttr = this.boolOption(string, string2);
            return;
        } else if (string.equalsIgnoreCase(INCLUDE_CONTENT_TYPE)) {
            this.includeContentType = this.boolOption(string, string2);
            return;
        } else if (string.equalsIgnoreCase(INDENT)) {
            this.indents = this.boolOption(string, string2);
            return;
        } else if (string.equalsIgnoreCase(INDENT_VALUE)) {
            this.indentValue = Integer.parseInt(string2);
            return;
        } else {
            if (!string.equalsIgnoreCase("dummy-display")) throw new DataModelException("invalid option: " + string);
            this.dummy = this.boolOption(string, string2);
        }
    }

    protected boolean boolOption(String string, String string2) throws DataModelException {
        if (string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("true") || string2.equals("1")) {
            return true;
        }
        if (string2.equalsIgnoreCase("no") || string2.equalsIgnoreCase("false") || string2.equals("0")) {
            return false;
        }
        throw new DataModelException("invalid value of option '" + string + "': " + string2);
    }

    public void setDepth(int n) {
        this.maxDepth = n;
    }

    public void setIndent(int n) {
        this.indents = n > 0;
        this.indentValue = n;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void traverse(Node node) throws DataModelException {
        this.traverse(node, false);
    }

    public void reset() {
        super.reset();
        this.enableIndent = false;
        this.firstElement = true;
        String string = this.indent = this.indents ? "                ".substring(0, Math.min(this.indentValue, 16)) : null;
        if (this.standalone || !"UTF-8".equals(this.encoding)) {
            this.omitXmlDecl = false;
        }
    }

    public void terminate() throws DataModelException {
        this.println();
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new DataModelException("IO error", iOException);
        }
    }

    public void startDocument() throws DataModelException {
        super.startDocument();
        if (this.omitXmlDecl || this.method.onlyText()) {
            return;
        }
        this.print("<?xml version='");
        this.print(this.version);
        this.print('\'');
        this.print(" encoding='" + this.encoding + '\'');
        this.print("?>");
        this.println();
    }

    public void endDocument() throws DataModelException {
        super.endDocument();
    }

    protected void flushElement(boolean bl) {
        if (!this.elementStarted || this.method.onlyText()) {
            return;
        }
        if (this.firstElement) {
            if (!(this.omitXmlDecl || this.publicId == null && this.systemId == null)) {
                this.print("<!DOCTYPE ");
                this.print(this.tagName.getLocalName());
                if (this.publicId != null) {
                    this.print(" PUBLIC \"");
                    this.print(this.publicId);
                    this.print("\"");
                    if (this.systemId != null) {
                        this.print(" \"");
                        this.print(this.systemId);
                        this.print("\"");
                    }
                } else if (this.systemId != null) {
                    this.print(" SYSTEM \"");
                    this.print(this.systemId);
                    this.print("\"");
                }
                this.print(">");
                this.println();
            }
            this.firstElement = false;
        }
        this.doIndent();
        this.print('<');
        this.printQName(this.tagName, false);
        int n = 0;
        while (n < this.attrCnt) {
            this.print(' ');
            this.printQName(this.attrNames[n], true);
            this.print("=\"");
            this.method.outputAttr(this.attrValues[n], this.attrNames[n]);
            this.print('\"');
            ++n;
        }
        int n2 = this.nsCnt;
        while (n2 > 0) {
            this.print(" xmlns");
            Namespace namespace = this.prefixes.getLastNamespace(n2);
            String string = this.prefixes.getLastPrefix(n2);
            if (string.length() > 0) {
                this.print(':');
                this.print(string);
            }
            this.print("=\"");
            this.method.outputAttr(namespace.toString(), null);
            this.print("\"");
            --n2;
        }
        this.print(bl ? this.method.endOfEmptyTag() : ">");
        this.elementStarted = false;
        this.enableIndent = true;
        this.spaceNeeded = false;
        this.method.afterStartTag();
    }

    public void endElement(QName qName) throws DataModelException {
        if (this.method.onlyText()) {
            return;
        }
        boolean bl = this.elementStarted;
        if (this.elementStarted) {
            bl = this.method.isMinimized(qName);
            this.flushElement(bl);
        }
        if (!bl) {
            this.doIndent();
            this.print("</");
            this.printQName(qName, false);
            this.print('>');
        }
        super.endElement(qName);
        this.enableIndent = true;
        this.spaceNeeded = false;
    }

    public void text(String string) {
        if (this.trace) {
            System.err.println("-- text |" + string + '|');
        }
        if (this.elementStarted) {
            this.flushElement(false);
        }
        int n = string.length();
        if (this.indent != null) {
            while (--n >= 0) {
                if (!Character.isWhitespace(string.charAt(n))) break;
            }
        }
        this.enableIndent = n < 0;
        this.method.outputText(string);
        this.spaceNeeded = false;
    }

    public void atom(String string) {
        if (this.trace) {
            System.err.println("-- atom " + string);
        }
        if (this.elementStarted) {
            this.flushElement(false);
        }
        if (this.spaceNeeded) {
            this.print(" ");
        }
        this.method.outputText(string);
        this.spaceNeeded = true;
        this.enableIndent = false;
    }

    public void pi(String string, String string2) {
        if (this.method.onlyText()) {
            return;
        }
        if (this.elementStarted) {
            this.flushElement(false);
        }
        this.doIndent();
        this.print("<?");
        this.print(string);
        this.print(' ');
        this.print(string2);
        this.print(this.method.endOfPI());
    }

    public void comment(String string) {
        if (this.method.onlyText()) {
            return;
        }
        if (this.elementStarted) {
            this.flushElement(false);
        }
        this.doIndent();
        this.print("<!--");
        this.print(string);
        this.print("-->");
    }

    void printQName(QName qName, boolean bl) {
        Namespace namespace = qName.getNamespace();
        if (namespace == Namespace.XML) {
            this.print("xml:");
            this.print(qName.getLocalName());
        } else {
            String string = this.prefixes.convertToPrefix(namespace);
            if (string == null) {
                if (namespace == Namespace.NONE) {
                    string = "";
                } else {
                    if (this.prefixHints == null || (string = this.prefixHints.convertToPrefix(namespace)) == null) {
                        int n = 1;
                        while (this.prefixes.convertToNamespace(string = "ns" + n) != null) {
                            ++n;
                        }
                    }
                    this.prefixes.addMapping(string, namespace);
                    ++this.nsCnt;
                }
            }
            if (string.length() > 0) {
                this.print(string);
                this.print(':');
            }
            this.print(qName.getLocalName());
        }
    }

    protected void doIndent() {
        if (this.enableIndent && this.indent != null) {
            this.println();
            int n = 1;
            while (n < this.depth) {
                this.print(this.indent);
                ++n;
            }
            this.enableIndent = false;
        }
    }

    protected void print(String string) {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            return;
        }
        try {
            if (!this.dummy) {
                this.out.write(string);
            }
            this.volume += (long)string.length();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void print(char c) {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            return;
        }
        try {
            if (!this.dummy) {
                this.out.write(c);
            }
            ++this.volume;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void println() {
        if (this.maxVolume > 0L && this.volume > this.maxVolume) {
            return;
        }
        try {
            if (!this.dummy) {
                this.out.newLine();
            }
            ++this.volume;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    class TextMethod
    extends XMLMethod {
        TextMethod() {
        }

        public boolean onlyText() {
            return true;
        }

        public void outputText(String string) {
            XMLSerializer.this.print(string);
        }
    }

    class HTMLMethod
    extends XMLMethod {
        boolean xhtml;
        boolean noEscape = false;

        HTMLMethod(boolean bl) {
            this.xhtml = bl;
        }

        boolean isHTML(Namespace namespace) {
            return namespace == XHTML || !this.xhtml && namespace == Namespace.NONE;
        }

        public String endOfEmptyTag() {
            return this.xhtml ? " />" : ">";
        }

        public boolean isMinimized(QName qName) {
            if (!this.isHTML(qName.getNamespace())) {
                return false;
            }
            String string = qName.getLocalName();
            switch (Character.toLowerCase(string.charAt(0))) {
                case 'a': {
                    return string.equalsIgnoreCase("area");
                }
                case 'b': {
                    return string.equalsIgnoreCase("br") || string.equalsIgnoreCase("base") || string.equalsIgnoreCase("basefont");
                }
                case 'c': {
                    return string.equalsIgnoreCase("col");
                }
                case 'f': {
                    return string.equalsIgnoreCase("frame");
                }
                case 'h': {
                    return string.equalsIgnoreCase("hr");
                }
                case 'i': {
                    return string.equalsIgnoreCase("img") || string.equalsIgnoreCase("input") || string.equalsIgnoreCase("isindex");
                }
                case 'l': {
                    return string.equalsIgnoreCase("link");
                }
                case 'm': {
                    return string.equalsIgnoreCase("meta");
                }
                case 'p': {
                    return string.equalsIgnoreCase("param");
                }
            }
            return false;
        }

        public void afterStartTag() {
            if (this.isHTML(XMLSerializer.this.tagName.getNamespace())) {
                String string = XMLSerializer.this.tagName.getLocalName();
                if (XMLSerializer.this.includeContentType && string.equalsIgnoreCase("head")) {
                    XMLSerializer.this.print("<meta http-equiv='Content-Type' content='text/html; charset=" + XMLSerializer.this.encoding + "'" + this.endOfEmptyTag());
                }
                if (!this.xhtml && (string.equalsIgnoreCase("script") || string.equalsIgnoreCase("style"))) {
                    this.noEscape = true;
                }
            }
        }

        public void outputText(String string) {
            if (this.noEscape) {
                XMLSerializer.this.print(string);
                this.noEscape = false;
                return;
            }
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c = string.charAt(n);
                switch (c) {
                    case '\n': {
                        XMLSerializer.this.println();
                        break;
                    }
                    case '\r': {
                        XMLSerializer.this.print("&#13;");
                        break;
                    }
                    case '&': {
                        XMLSerializer.this.print("&amp;");
                        break;
                    }
                    case '<': {
                        XMLSerializer.this.print("&lt;");
                        break;
                    }
                    case '>': {
                        XMLSerializer.this.print("&gt;");
                        break;
                    }
                    case '\u00a0': {
                        XMLSerializer.this.print("&nbsp;");
                        break;
                    }
                    default: {
                        XMLSerializer.this.print(c);
                    }
                }
                ++n;
            }
        }

        public void outputAttr(String string, QName qName) {
            boolean bl = false;
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c = string.charAt(n);
                switch (c) {
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        if (!bl) {
                            XMLSerializer.this.print(' ');
                        }
                        bl = true;
                        break;
                    }
                    case '&': {
                        XMLSerializer.this.print("&amp;");
                        break;
                    }
                    case '<': {
                        if (this.xhtml) {
                            XMLSerializer.this.print("&lt;");
                            break;
                        }
                        XMLSerializer.this.print(c);
                        break;
                    }
                    default: {
                        XMLSerializer.this.print(c);
                        bl = false;
                    }
                }
                ++n;
            }
        }

        public String endOfPI() {
            return this.xhtml ? "?>" : ">";
        }
    }

    class XMLMethod
    implements Method {
        XMLMethod() {
        }

        public boolean onlyText() {
            return false;
        }

        public String endOfEmptyTag() {
            return "/>";
        }

        public void afterStartTag() {
        }

        public boolean isMinimized(QName qName) {
            return true;
        }

        public void outputText(String string) {
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c = string.charAt(n);
                switch (c) {
                    case '\n': {
                        XMLSerializer.this.println();
                        break;
                    }
                    case '\r': {
                        XMLSerializer.this.print("&#13;");
                        break;
                    }
                    case '&': {
                        XMLSerializer.this.print("&amp;");
                        break;
                    }
                    case '<': {
                        XMLSerializer.this.print("&lt;");
                        break;
                    }
                    case '>': {
                        XMLSerializer.this.print("&gt;");
                        break;
                    }
                    default: {
                        XMLSerializer.this.print(c);
                    }
                }
                ++n;
            }
        }

        public void outputAttr(String string, QName qName) {
            int n = 0;
            int n2 = string.length();
            while (n < n2) {
                char c = string.charAt(n);
                switch (c) {
                    case '\t': {
                        XMLSerializer.this.print("&#9;");
                        break;
                    }
                    case '\n': {
                        XMLSerializer.this.print("&#10;");
                        break;
                    }
                    case '\r': {
                        XMLSerializer.this.print("&#13;");
                        break;
                    }
                    case '&': {
                        XMLSerializer.this.print("&amp;");
                        break;
                    }
                    case '<': {
                        XMLSerializer.this.print("&lt;");
                        break;
                    }
                    default: {
                        XMLSerializer.this.print(c);
                    }
                }
                ++n;
            }
        }

        public String endOfPI() {
            return "?>";
        }
    }

    static interface Method {
        public boolean onlyText();

        public boolean isMinimized(QName var1);

        public void afterStartTag();

        public String endOfEmptyTag();

        public String endOfPI();

        public void outputAttr(String var1, QName var2);

        public void outputText(String var1);
    }
}

