/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.ext;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.ext.SqlExecQuery;
import net.xfra.qizxopen.ext.SqlExecUpdate;
import net.xfra.qizxopen.ext.SqlRawExec;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.time.DateTimeBase;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.EventDrivenBuilder;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.BaseValue;
import net.xfra.qizxopen.xquery.dt.DecimalValue;
import net.xfra.qizxopen.xquery.dt.DoubleValue;
import net.xfra.qizxopen.xquery.dt.FloatValue;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.SingleWrappedObject;
import net.xfra.qizxopen.xquery.dt.StringValue;
import net.xfra.qizxopen.xquery.dt.WrappedObjectType;
import net.xfra.qizxopen.xquery.impl.PredefinedModule;

public class SqlConnection {
    public static String NS = "java:net.xfra.qizxopen.ext.SqlConnection";
    public static ItemType TYPE_CONNECTION = new WrappedObjectType(class$java$sql$Connection == null ? (class$java$sql$Connection = SqlConnection.class$("java.sql.Connection")) : class$java$sql$Connection);
    public static ItemType TYPE_RESULTSET = new WrappedObjectType(class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = SqlConnection.class$("java.sql.ResultSet")) : class$java$sql$ResultSet);
    public static ItemType TYPE_PSTATEMENT = new WrappedObjectType(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = SqlConnection.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement);
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$java$sql$PreparedStatement;

    public static void plugHook(PredefinedModule predefinedModule) throws XQueryException {
        if (predefinedModule.simpleFunctionLookup(QName.get(NS, "execute")) != null) {
            return;
        }
        predefinedModule.declareFunction(new SqlExecQuery());
        predefinedModule.declareFunction(new SqlExecUpdate());
        predefinedModule.declareFunction(new SqlRawExec());
    }

    public static void registerDriver(String string) throws Exception {
        Class.forName(string).newInstance();
    }

    public static Connection getConnection(String string, String string2, String string3) throws SQLException {
        Connection connection = DriverManager.getConnection(string, string2, string3);
        return connection;
    }

    public static void close(Connection connection) throws SQLException {
        connection.close();
    }

    public static PreparedStatement prepare(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class Stat {
        PreparedStatement stat;
        ParameterMetaData meta;

        Stat(PreparedStatement preparedStatement) {
            this.stat = preparedStatement;
        }

        void setArg(int n, Item item) throws TypeException, SQLException {
            ItemType itemType = item.getType();
            if (item instanceof StringValue) {
                this.stat.setString(n, item.asString());
            } else if (Type.INTEGER.isSuperType(itemType)) {
                long l = item.asInteger();
                this.stat.setLong(n, l);
            } else if (Type.NUMERIC.isSuperType(itemType)) {
                if (itemType == Type.DOUBLE) {
                    this.stat.setDouble(n, ((DoubleValue)item).asDouble());
                } else if (itemType == Type.DECIMAL) {
                    this.stat.setBigDecimal(n, ((DecimalValue)item).getValue());
                } else if (itemType == Type.FLOAT) {
                    this.stat.setFloat(n, ((FloatValue)item).asFloat());
                } else {
                    System.err.println("OOPS NUMERIC: " + item);
                }
            } else if (item instanceof MomentValue) {
                DateTimeBase dateTimeBase = ((MomentValue)item).getValue();
                this.stat.setDate(n, new Date((long)dateTimeBase.getMillisecondsFromEpoch()));
            } else if (item == null) {
                if (this.meta == null) {
                    this.meta = this.stat.getParameterMetaData();
                }
                this.stat.setNull(n, this.meta.getParameterType(n));
            }
        }
    }

    public static class Result
    extends RawResult {
        EventDrivenBuilder builder = new EventDrivenBuilder();

        Result(ResultSet resultSet) {
            super(resultSet);
        }

        public ItemType getType() {
            return Type.NODE;
        }

        public Item asItem() throws TypeException {
            return this.asNode();
        }

        public boolean isNode() {
            return true;
        }

        public Node asNode() throws TypeException {
            try {
                int n;
                if (this.meta == null) {
                    this.meta = this.rset.getMetaData();
                    n = this.meta.getColumnCount();
                    this.colNames = new QName[n];
                    int n2 = 1;
                    while (n2 <= n) {
                        this.colNames[n2 - 1] = QName.get(this.meta.getColumnLabel(n2));
                        ++n2;
                    }
                }
                this.builder.reset();
                this.builder.startElement(RawResult.ROW);
                n = 0;
                while (n < this.colNames.length) {
                    this.builder.startElement(this.colNames[n]);
                    String string = this.rset.getString(n + 1);
                    if (string != null) {
                        this.builder.atom(string);
                    }
                    this.builder.endElement(this.colNames[n]);
                    ++n;
                }
                this.builder.endElement(RawResult.ROW);
                return this.builder.crop();
            }
            catch (SQLException sQLException) {
                throw new TypeException("error in row construction", sQLException);
            }
            catch (DataModelException dataModelException) {
                throw new TypeException("error in row construction", dataModelException);
            }
        }

        public Value bornAgain() {
            try {
                this.rset.beforeFirst();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return new Result(this.rset);
        }
    }

    public static class RawResult
    extends BaseValue {
        static QName ROW = QName.get("row");
        ResultSet rset;
        ResultSetMetaData meta = null;
        QName[] colNames;

        RawResult(ResultSet resultSet) {
            this.rset = resultSet;
        }

        public boolean next() {
            try {
                return this.rset.next();
            }
            catch (SQLException sQLException) {
                return false;
            }
        }

        public Item asItem() throws TypeException {
            return new SingleWrappedObject(this.rset);
        }

        public String asString() throws TypeException {
            return this.rset.toString();
        }

        public Value bornAgain() {
            try {
                this.rset.beforeFirst();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return new RawResult(this.rset);
        }
    }
}

