/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.util;

import java.io.PrintStream;
import java.lang.reflect.Field;

public class CLOptions {
    String appName;
    Option[] options = new Option[0];
    Option[] arguments = new Option[0];
    String[] args;
    int argp;
    int anonymous;
    public static final int NEXT_ARG = 1;
    public static final int STICKY_ARG = 2;
    public static final int SET_ARG = 3;
    public static final int RESET_ARG = 4;
    public static final int ALL_ARG = 5;
    public static final int HELP_ARG = 6;

    public CLOptions(String string) {
        this.appName = string;
    }

    public void declare(String string, String string2, int n, String string3) {
        Option[] optionArray = this.options;
        this.options = new Option[optionArray.length + 1];
        System.arraycopy(optionArray, 0, this.options, 0, optionArray.length);
        this.options[optionArray.length] = new Option(string, string2, n, string3);
    }

    public void declare(String string, int n, String string2) {
        String string3 = string;
        if (!Character.isJavaIdentifierStart(string3.charAt(0))) {
            string3 = string3.substring(1);
        }
        this.declare(string, string3, n, string2);
    }

    public void argument(String string, String string2, int n, String string3) {
        Option[] optionArray = this.arguments;
        this.arguments = new Option[optionArray.length + 1];
        System.arraycopy(optionArray, 0, this.arguments, 0, optionArray.length);
        this.arguments[optionArray.length] = new Option(string, string2, n, string3);
    }

    public void parse(String[] stringArray, Object object) throws Exception {
        this.args = stringArray;
        this.argp = 0;
        this.anonymous = 0;
        while (this.argp < stringArray.length) {
            String string;
            int n;
            if ((n = this.lookup(string = stringArray[this.argp++])) < 0) {
                if (this.anonymous >= this.arguments.length) {
                    if (this.arguments[this.arguments.length - 1].type <= 1) {
                        this.error("too many arguments: " + string);
                    }
                    this.anonymous = this.arguments.length - 1;
                }
                this.setField(object, "argument", this.arguments[this.anonymous++].field, string);
                continue;
            }
            switch (this.options[n].type) {
                case 1: {
                    if (this.argp >= stringArray.length) {
                        this.error(this.options[n].key + " requires an argument");
                    }
                    this.setField(object, this.options[n].key, this.options[n].field, stringArray[this.argp++]);
                    break;
                }
                case 2: {
                    String string2 = string.substring(this.options[n].key.length());
                    this.setField(object, this.options[n].key, this.options[n].field, string2);
                    break;
                }
                case 3: 
                case 4: {
                    this.setField(object, this.options[n].key, this.options[n].field, this.options[n].type == 3 ? "1" : "0");
                    break;
                }
                case 5: {
                    String[] stringArray2 = new String[stringArray.length - this.argp];
                    System.arraycopy(stringArray, this.argp, stringArray2, 0, stringArray2.length);
                    this.setField(object, this.options[n].key, this.options[n].field, stringArray2);
                    return;
                }
                case 6: {
                    this.printHelp(System.err);
                    throw new Exception();
                }
            }
        }
        if (this.anonymous < this.arguments.length && this.arguments[this.arguments.length - 1].type >= 1) {
            this.error("not enough arguments");
        }
    }

    private int lookup(String string) {
        int n = this.options.length;
        while (--n >= 0) {
            if (!this.options[n].key.equals(string) && (this.options[n].type != 2 || !string.startsWith(this.options[n].key))) continue;
            return n;
        }
        return -1;
    }

    void error(String string) throws Exception {
        System.err.println("*** " + string);
        this.printHelp(System.err);
        throw new Exception();
    }

    public void printHelp(PrintStream printStream) {
        int n;
        int n2;
        printStream.print("usage: " + this.appName + " [options]");
        int n3 = 0;
        while (n3 < this.arguments.length) {
            printStream.print(" " + this.arguments[n3].key);
            if (this.arguments[n3].type == 5) {
                printStream.print("...");
            }
            ++n3;
        }
        printStream.println();
        if (this.arguments.length > 0) {
            printStream.println(" arguments:");
            n2 = 0;
            while (n2 < this.arguments.length) {
                printStream.print("  " + this.arguments[n2].key);
                n = this.arguments[n2].key.length();
                while (n < 12) {
                    printStream.print(' ');
                    ++n;
                }
                printStream.println(' ' + this.arguments[n2].help);
                ++n2;
            }
        }
        printStream.println(" options:");
        n2 = 0;
        while (n2 < this.options.length) {
            if (this.options[n2].help != null) {
                int n4;
                n = this.options[n2].key.length();
                printStream.print("  " + this.options[n2].key);
                String string = this.options[n2].help;
                if (this.options[n2].type == 1) {
                    printStream.print(" <" + this.options[n2].field + '>');
                    n += 3 + this.options[n2].field.length();
                } else if (this.options[n2].type == 2 && (n4 = string.indexOf(33)) >= 0) {
                    String string2 = string.substring(0, n4);
                    printStream.print(string2);
                    n += string2.length();
                    string = string.substring(n4 + 1);
                }
                while (n < 22) {
                    printStream.print(' ');
                    ++n;
                }
                printStream.println(" " + string);
            }
            ++n2;
        }
    }

    void setField(Object object, String string, String string2, Object object2) throws Exception {
        Class<?> clazz = null;
        try {
            Field field = object.getClass().getField(string2);
            clazz = field.getType();
            if (clazz == Integer.TYPE) {
                field.setInt(object, Integer.parseInt((String)object2));
            } else if (clazz == Float.TYPE) {
                field.setFloat(object, Float.parseFloat((String)object2));
            } else if (clazz == Double.TYPE) {
                field.setDouble(object, Double.parseDouble((String)object2));
            } else if (clazz == Boolean.TYPE) {
                field.setBoolean(object, object2.equals("1") || ((String)object2).equalsIgnoreCase("yes") || ((String)object2).equalsIgnoreCase("true"));
            } else if (clazz.isArray()) {
                String[] stringArray = (String[])field.get(object);
                String[] stringArray2 = null;
                if (object2 instanceof String) {
                    stringArray2 = new String[stringArray.length + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray2[stringArray.length] = (String)object2;
                } else {
                    String[] stringArray3 = (String[])object2;
                    stringArray2 = new String[stringArray.length + stringArray3.length];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    System.arraycopy(stringArray3, 0, stringArray2, stringArray.length, stringArray3.length);
                }
                field.set(object, stringArray2);
            } else {
                field.set(object, object2);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException("!!! no such field " + string2);
        }
        catch (java.lang.Exception exception) {
            exception.printStackTrace();
            this.error("illegal value for " + string + ": " + exception.getMessage());
        }
    }

    public static class Exception
    extends java.lang.Exception {
    }

    protected static class Option {
        String key;
        String field;
        int type;
        String help;

        Option(String string, String string2, int n, String string3) {
            this.key = string;
            this.field = string2;
            this.type = n;
            this.help = string3;
        }
    }
}

