/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery;

import java.io.PrintWriter;
import java.util.Vector;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.fn.UserFunction;
import net.xfra.qizxopen.xquery.op.Expression;

public class ExprDump {
    PrintWriter out = new PrintWriter(System.out, true);
    int depth = -1;
    int level = 2;
    boolean indent = true;

    public ExprDump() {
    }

    public ExprDump(int n) {
        this.level = n;
    }

    public void setOutput(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public boolean pretty() {
        return this.level == 0;
    }

    public void header(Expression expression, String string) {
        this.print(string);
        if (this.level >= 2) {
            this.print(" at " + expression.location + ", type " + expression.getType());
            int n = expression.getFlags();
            if (n != 0) {
                this.print(" flags: ");
                if ((n & 8) != 0) {
                    this.print("O ");
                }
                if ((n & 2) != 0) {
                    this.print("W ");
                }
                if ((n & 4) != 0) {
                    this.print("D ");
                }
                if ((n & 0x10) != 0) {
                    this.print("U ");
                }
                if ((n & 0x20) != 0) {
                    this.print("C ");
                }
            }
        }
        this.println("");
    }

    public void displayp(String string, Expression expression) {
        ++this.depth;
        if (this.level >= 1) {
            this.print(string);
            this.out.print(" = ");
        } else {
            this.print(string);
            this.out.print(' ');
        }
        if (expression == null) {
            this.println("<null>");
        } else {
            expression.dump(this);
        }
        --this.depth;
    }

    public void display(String string, Expression expression) {
        ++this.depth;
        if (this.level >= 1) {
            this.print(string);
            this.out.print(" = ");
        }
        if (expression == null) {
            this.println("<null>");
        } else {
            expression.dump(this);
        }
        --this.depth;
    }

    public void display(String string, Type type) {
        ++this.depth;
        if (this.level >= 1) {
            this.print(string);
            this.out.print(" = ");
        }
        if (type == null) {
            this.println("<null>");
        } else {
            type.dump(this);
        }
        --this.depth;
    }

    public void display(String string, Vector vector) {
        ++this.depth;
        if (this.level >= 1) {
            this.print(string);
            this.println(" =");
        }
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.get(n);
            if (e instanceof Expression) {
                if (this.level >= 1) {
                    this.print("* ");
                }
                ((Expression)e).dump(this);
            } else if (e instanceof Type) {
                if (this.level >= 1) {
                    this.print("* ");
                }
                ((Type)e).dump(this);
            } else if (e instanceof UserFunction) {
                if (this.level >= 1) {
                    this.print("* ");
                }
                ((UserFunction)e).dump(this);
            } else if (e != null) {
                this.println(e.toString());
            } else {
                this.println("<void>");
            }
            ++n;
        }
        --this.depth;
    }

    public void display(String string, Expression[] expressionArray) {
        ++this.depth;
        if (this.level >= 1) {
            this.print(string);
            this.println(" =");
        }
        if (expressionArray != null) {
            int n = 0;
            while (n < expressionArray.length) {
                if (this.level >= 1) {
                    this.print("* ");
                }
                expressionArray[n].dump(this);
                ++n;
            }
        }
        --this.depth;
    }

    public void display(String string, QName qName) {
        ++this.depth;
        if (this.level >= 1) {
            this.print(string);
            this.out.print(" = ");
        }
        if (qName == null) {
            this.println("<null>");
        } else {
            this.println(qName.toString());
        }
        --this.depth;
    }

    public void display(String string, String string2) {
        ++this.depth;
        if (this.level >= 1) {
            this.print(string);
            this.out.print(" = ");
        }
        this.println(string2);
        --this.depth;
    }

    public void display(String string, int n) {
        ++this.depth;
        if (this.level >= 1) {
            this.print(string);
            this.out.print(" = ");
        }
        this.println("" + n);
        --this.depth;
    }

    public void depth(int n) {
        this.depth += n;
    }

    public void print(String string) {
        if (this.indent) {
            int n = 0;
            while (n < this.depth) {
                this.out.print("   ");
                ++n;
            }
        }
        this.indent = false;
        this.out.print(string);
    }

    public void println(String string) {
        this.print(string);
        this.out.println();
        this.indent = true;
    }
}

