/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import net.xfra.qizxopen.util.Util;
import net.xfra.qizxopen.xquery.Log;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.impl.Module;
import net.xfra.qizxopen.xquery.impl.Parser;

public class ModuleManager
implements ErrorListener {
    protected URL baseURL;
    private HashMap modules = new HashMap();
    private TransformerFactory xsltFactory;
    private ArrayList templateCache = new ArrayList();
    private int templateCacheSize = 3;

    public ModuleManager(URL uRL) throws IOException {
        this.baseURL = uRL;
    }

    public ModuleManager(String string) throws IOException {
        this.baseURL = Util.uriToURL(string);
    }

    public URL resolveModuleLocation(String string, String string2) throws IOException {
        if (string2 == null) {
            string2 = string.replace('.', '/') + ".xqm";
        }
        return new URL(this.baseURL, string2);
    }

    public synchronized void unloadAllModules() {
        this.modules = new HashMap();
    }

    public synchronized Module loadModule(Parser parser, String string, String string2, Log log) throws IOException, XQueryException {
        Module module = (Module)this.modules.get(string);
        if (module == null) {
            URL uRL = this.resolveModuleLocation(string, string2);
            String string3 = this.loadSource(uRL);
            Parser parser2 = new Parser(this);
            module = new Module();
            this.modules.put(string, module);
            parser2.setupFrom(parser);
            module.setBaseURI(this.baseURL.toString());
            parser2.parseLibraryModule(module, string3, uRL.toString(), log);
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String loadSource(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        String string = null;
        try {
            string = this.loadSource(inputStream);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return string;
    }

    String loadSource(InputStream inputStream) throws IOException {
        int n = inputStream.available() + 1;
        char[] cArray = new char[n];
        int n2 = 0;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        while (true) {
            int n3;
            if ((n3 = inputStreamReader.read(cArray, n2, cArray.length - n2)) < 0) {
                n3 = 0;
            }
            if ((n2 += n3) < cArray.length) break;
            char[] cArray2 = new char[n2 * 2];
            System.arraycopy(cArray, 0, cArray2, 0, n2);
            cArray = cArray2;
        }
        inputStreamReader.close();
        return new String(cArray, 0, n2);
    }

    public void setXSLTFactory(TransformerFactory transformerFactory) {
        this.xsltFactory = transformerFactory;
    }

    public TransformerFactory getXSLTFactory() {
        if (this.xsltFactory == null) {
            this.xsltFactory = TransformerFactory.newInstance();
        }
        return this.xsltFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Templates loadTemplates(String string) throws TransformerException {
        ArrayList arrayList = this.templateCache;
        synchronized (arrayList) {
            CacheSlot cacheSlot = null;
            int n = this.templateCache.size();
            while (--n >= 0) {
                cacheSlot = (CacheSlot)this.templateCache.get(n);
                if (cacheSlot != null && cacheSlot.path.equals(string)) break;
            }
            if (n >= 0) {
                return (Templates)cacheSlot.loaded;
            }
            cacheSlot = new CacheSlot();
            cacheSlot.path = string;
            this.getXSLTFactory();
            try {
                Source source = null;
                this.xsltFactory.setErrorListener(this);
                source = string.startsWith("http:") || string.startsWith("file:") ? this.xsltFactory.getURIResolver().resolve(string, null) : new StreamSource(string);
                if (source == null) {
                    throw new TransformerException("cannot find stylesheet " + string);
                }
                Templates templates = this.xsltFactory.newTemplates(source);
                cacheSlot.loaded = templates;
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new TransformerException(transformerConfigurationException.getMessage(), transformerConfigurationException.getCause());
            }
            this.templateCache.add(0, cacheSlot);
            if (this.templateCache.size() > this.templateCacheSize) {
                this.templateCache.remove(this.templateCache.size() - 1);
            }
            return (Templates)cacheSlot.loaded;
        }
    }

    public void error(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }

    public void fatalError(TransformerException transformerException) throws TransformerException {
        throw transformerException;
    }

    public void warning(TransformerException transformerException) {
    }

    static class CacheSlot {
        String path;
        Object loaded;

        CacheSlot() {
        }
    }
}

