/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.xquery.EmptyException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Log;
import net.xfra.qizxopen.xquery.ModuleManager;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.impl.Module;
import net.xfra.qizxopen.xquery.op.Expression;

public class XQuery
extends Module {
    public Expression body;

    public XQuery() {
        this.moduleNS = Module.LOCAL_NS;
    }

    public Type getType() {
        return this.body.getType();
    }

    public void dump(ExprDump exprDump) {
        exprDump.println("Query");
        exprDump.display("declarations", this.declarations);
        exprDump.display("body", this.body);
    }

    public void staticCheck(ModuleManager moduleManager, Log log) {
        this.resetLocals();
        super.staticCheck(moduleManager, log);
        this.resetLocals();
        if (this.body != null) {
            this.body = this.staticCheck(this.body, 0);
            this.allocateLocalAddress(this.lastLocal);
        }
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        try {
            return this.body == null ? Value.empty : this.body.eval(focus, evalContext);
        }
        catch (EmptyException emptyException) {
            return Value.empty;
        }
        catch (EvalException evalException) {
            if (evalException.getContext() == null) {
                evalException.setContext(evalContext);
            }
            throw evalException;
        }
    }

    public void evalAsEvents(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException, DataModelException {
        try {
            this.body.evalAsEvents(xMLEventReceiver, focus, evalContext);
        }
        catch (EmptyException emptyException) {
        }
        catch (EvalException evalException) {
            if (evalException.getContext() == null) {
                evalException.setContext(evalContext);
            }
            throw evalException;
        }
    }
}

