/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.text.Collator;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.DocumentManager;
import net.xfra.qizxopen.dm.FONIDocument;
import net.xfra.qizxopen.dm.IDocument;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.dm.XMLSerializer;
import net.xfra.qizxopen.util.FileUtil;
import net.xfra.qizxopen.util.NSPrefixMapping;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.util.Timer;
import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Log;
import net.xfra.qizxopen.xquery.ModuleManager;
import net.xfra.qizxopen.xquery.SyntaxException;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQuery;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.FONIDataModel;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.ArraySequence;
import net.xfra.qizxopen.xquery.dt.SingleBoolean;
import net.xfra.qizxopen.xquery.dt.SingleDouble;
import net.xfra.qizxopen.xquery.dt.SingleInteger;
import net.xfra.qizxopen.xquery.dt.SingleNode;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.dt.SingleWrappedObject;
import net.xfra.qizxopen.xquery.impl.DefaultEvalContext;
import net.xfra.qizxopen.xquery.impl.Module;
import net.xfra.qizxopen.xquery.impl.Parser;
import net.xfra.qizxopen.xquery.impl.PredefinedModule;
import net.xfra.qizxopen.xquery.impl.SAXSourceWrapper;
import net.xfra.qizxopen.xquery.impl.Version;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XQueryProcessor {
    public static String EXTENSIONS_URI = "net.xfra.qizxopen.ext.Xfn";
    public static Namespace EXTENSIONS_NS = Namespace.get(EXTENSIONS_URI);
    public static final String XSLT_OUTPUT_FILE = "output-file";
    static PredefinedModule OwnPredefined = XQueryProcessor.newOwnPredefinedModule();
    protected DocumentManager docMan;
    protected ModuleManager moduleMan;
    protected String baseURI = ".";
    protected String docInputURI;
    protected Value input;
    protected PredefinedModule predefined = OwnPredefined;
    protected HashMap globals = new HashMap();
    protected HashMap collations;
    protected HashMap properties = new HashMap();
    protected String defaultCollation = null;
    protected String implicitTimezone = null;
    protected PrintWriter defaultOutput = new PrintWriter(System.out, true);
    protected Log log;
    protected NSPrefixMapping extraNS;
    protected DefaultEvalContext execContext;

    public XQueryProcessor() {
        this.init();
    }

    public XQueryProcessor(String string, String string2) throws IOException {
        this.setDocumentManager(new DocumentManager(string2));
        this.setModuleManager(new ModuleManager(string));
        this.init();
    }

    public XQueryProcessor(XQueryProcessor xQueryProcessor) {
        this.docMan = xQueryProcessor.getDocumentManager();
        this.moduleMan = xQueryProcessor.getModuleManager();
        this.predefined = xQueryProcessor.predefined;
        this.collations = xQueryProcessor.collations;
        this.defaultCollation = xQueryProcessor.defaultCollation;
        this.implicitTimezone = xQueryProcessor.implicitTimezone;
        this.properties = (HashMap)xQueryProcessor.properties.clone();
        this.extraNS = xQueryProcessor.extraNS == null ? null : xQueryProcessor.extraNS.copy();
        this.setSysProperty(":processor", this);
    }

    private void init() {
        this.predefineNamespace("qizx", EXTENSIONS_NS.getURI());
        this.predefineNamespace("x", EXTENSIONS_NS.getURI());
        this.predefineNamespace("sqlx", "java:net.xfra.qizxopen.ext.SqlConnection");
        this.predefineNamespace("sql", "java:java.sql");
        this.predefineNamespace("sqlc", "java:java.sql.Connection");
        this.predefineNamespace("sqlr", "java:java.sql.ResultSet");
        this.predefineNamespace("sqlp", "java:java.sql.PreparedStatement");
        this.setSysProperty(":processor", this);
        this.setSysProperty("version", "1.0");
        this.setSysProperty("vendor", "Xavier Franc");
        this.setSysProperty("vendor-url", "http://www.xfra.net/qizxopen/");
        this.setSysProperty("product-name", "Qizx/open");
        this.setSysProperty("product-version", Version.get());
    }

    public String getVersion() {
        return Version.get();
    }

    public void setModuleManager(ModuleManager moduleManager) {
        this.moduleMan = moduleManager;
    }

    public ModuleManager getModuleManager() {
        return this.moduleMan;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.docMan = documentManager;
    }

    public DocumentManager getDocumentManager() {
        return this.docMan;
    }

    public void setInput(String string) throws XQueryException {
        this.setInput(new InputSource(new StringReader(string)));
    }

    public void setInput(InputSource inputSource) throws XQueryException {
        if (this.docMan == null) {
            throw new EvalException("no Document Manager defined");
        }
        this.docInputURI = null;
        try {
            FONIDocument fONIDocument = this.docMan.parseDocument(inputSource);
            FONIDataModel fONIDataModel = new FONIDataModel(fONIDocument);
            this.input = new SingleNode(fONIDataModel.getDocumentNode());
        }
        catch (SAXException sAXException) {
            throw new XQueryException("XML parsing error: " + sAXException.getMessage(), sAXException);
        }
        catch (IOException iOException) {
            throw new XQueryException("XML input error: " + iOException.getMessage(), iOException);
        }
    }

    public void setDocumentInput(String string) throws XQueryException {
        if (this.docMan == null) {
            throw new EvalException("no Document Manager defined");
        }
        this.docInputURI = string;
    }

    public void setCollectionInput(String string) throws XQueryException {
        throw new XQueryException("setCollectionInput not implemented");
    }

    public void setDefaultOutput(PrintWriter printWriter) {
        this.defaultOutput = printWriter;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setSysProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getSysProperty(String string) {
        return this.properties.get(string);
    }

    public void resetDeclarations() {
        this.predefined = OwnPredefined;
        this.globals = new HashMap();
    }

    public void predefineGlobal(QName qName, Type type) {
        if (this.predefined == OwnPredefined) {
            this.predefined = XQueryProcessor.newOwnPredefinedModule();
        }
        this.predefined.defineGlobal(qName, type);
    }

    private static PredefinedModule newOwnPredefinedModule() {
        PredefinedModule predefinedModule = new PredefinedModule();
        predefinedModule.registerFunctionPlugger(new PredefinedModule.BasicFunctionPlugger(EXTENSIONS_NS, EXTENSIONS_URI + "%C"));
        return predefinedModule;
    }

    public void predefineGlobal(String string, Type type) {
        this.predefineGlobal(QName.get(string), type);
    }

    public void initGlobal(QName qName, Value value) {
        this.globals.put(qName, value);
        if (qName.getNamespace() == Module.LOCAL_NS) {
            this.globals.put(QName.get(qName.getLocalName()), value);
        }
    }

    public static QName toLocalNS(String string) {
        return QName.get(Module.LOCAL_NS, string);
    }

    public void initGlobal(QName qName, boolean bl) {
        this.initGlobal(qName, new SingleBoolean(bl));
    }

    public void initGlobal(QName qName, long l) {
        this.initGlobal(qName, new SingleInteger(l));
    }

    public void initGlobal(QName qName, double d) {
        this.initGlobal(qName, new SingleDouble(d));
    }

    public void initGlobal(QName qName, String string) {
        this.initGlobal(qName, new SingleString(string));
    }

    public void initGlobal(QName qName, String[] stringArray) {
        Object[] objectArray = new SingleString[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            objectArray[n] = new SingleString(stringArray[n]);
            ++n;
        }
        this.initGlobal(qName, new ArraySequence(objectArray, objectArray.length));
    }

    public void initGlobal(QName qName, Object object) {
        this.initGlobal(qName, new SingleWrappedObject(object));
    }

    public void predefineNamespace(String string, String string2) {
        if (this.extraNS == null) {
            this.extraNS = new NSPrefixMapping();
        }
        this.extraNS.addMapping(string, string2);
    }

    public void registerCollation(String string, Collator collator) {
        if (this.collations == null) {
            this.collations = new HashMap();
        }
        this.collations.put(string, collator);
    }

    public void setDefaultCollation(String string) {
        this.defaultCollation = string;
    }

    public void setImplicitTimezone(String string) {
        this.implicitTimezone = string;
    }

    public void authorizeClass(String string) {
        this.predefined.authorizeJavaClass(string);
    }

    public XQuery compileQuery(CharSequence charSequence, String string, Log log) throws XQueryException {
        if (charSequence == null) {
            throw new IllegalArgumentException("null textInput");
        }
        if (string == null) {
            throw new IllegalArgumentException("null URI");
        }
        if (log == null) {
            throw new IllegalArgumentException("null log");
        }
        if (this.moduleMan == null) {
            throw new XQueryException("no Module Manager specified");
        }
        if (this.docMan == null) {
            throw new XQueryException("no Document Manager specified");
        }
        Parser parser = new Parser(this.moduleMan);
        parser.setPredefinedModule(this.predefined);
        parser.setCollations(this.collations);
        if (this.extraNS != null) {
            parser.setPredefinedNamespaces(this.extraNS);
        }
        try {
            int n = log.getErrorCount();
            XQuery xQuery = parser.parseQuery(charSequence, string, log);
            xQuery.setBaseURI(this.docMan.getBaseURI());
            int n2 = log.getErrorCount() - n;
            if (n2 == 0) {
                xQuery.staticCheck(this.moduleMan, log);
            }
            log.flush();
            n2 = log.getErrorCount() - n;
            if (n2 > 0) {
                throw new XQueryException("static analysis: " + n2 + " error" + (n2 > 1 ? "s" : ""));
            }
            return xQuery;
        }
        catch (SyntaxException syntaxException) {
            throw new XQueryException("syntax: " + syntaxException.getMessage(), syntaxException);
        }
        catch (SecurityException securityException) {
            throw new XQueryException(securityException.getMessage(), securityException);
        }
    }

    public XQuery compileQuery(Reader reader, String string, Log log) throws XQueryException, IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(1000);
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray, 0, cArray.length)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return this.compileQuery(stringBuffer, string, log);
    }

    public XQuery compileQuery(File file, Log log) throws XQueryException, IOException {
        return this.compileQuery(new FileReader(file), file.getAbsolutePath(), log);
    }

    private DefaultEvalContext prepareQuery(XQuery xQuery) throws XQueryException {
        Integer n;
        if (xQuery == null) {
            throw new IllegalArgumentException("null query");
        }
        if (this.docMan == null) {
            throw new EvalException("no Document Manager defined");
        }
        this.execContext = new DefaultEvalContext(xQuery, xQuery.getLocalSize());
        this.execContext.setProperties(this.properties);
        this.execContext.setDocumentManager(this.docMan);
        this.execContext.setDefaultOutput(this.defaultOutput);
        this.execContext.setLog(this.log);
        try {
            if (this.implicitTimezone != null) {
                this.execContext.setImplicitTimezone(this.implicitTimezone);
            }
        }
        catch (DateTimeException dateTimeException) {
            throw new XQueryException("implicit timezone: " + dateTimeException.getMessage());
        }
        if (this.defaultCollation != null) {
            xQuery.setDefaultCollation(this.defaultCollation);
        }
        if (this.input != null) {
            this.execContext.setInput(this.input);
        } else if (this.docInputURI != null) {
            this.execContext.setInput(this.execContext.getDocument(this.docInputURI));
        }
        Object object = this.getSysProperty("sys:traceExec");
        if (object != null && object != Boolean.FALSE) {
            this.execContext.setExecTrace(true);
        }
        if ((n = (Integer)this.getSysProperty("sys:timeout")) != null) {
            final DefaultEvalContext defaultEvalContext = this.execContext;
            Timer.request(n, new Timer.Handler(){

                public void timeEvent(Timer.Request request) {
                    defaultEvalContext.setTimeOut(true);
                }
            });
        }
        xQuery.initGlobals(this.execContext, this.globals);
        return this.execContext;
    }

    public Value executeQuery(XQuery xQuery) throws XQueryException {
        this.prepareQuery(xQuery);
        Value value = xQuery.eval(null, this.execContext);
        this.execContext = null;
        return value;
    }

    public void executeQuery(XQuery xQuery, XMLEventReceiver xMLEventReceiver) throws XQueryException {
        this.prepareQuery(xQuery);
        xMLEventReceiver.reset();
        xMLEventReceiver.definePrefixHints(xQuery.getInScopeNS());
        try {
            xQuery.evalAsEvents(xMLEventReceiver, null, this.execContext);
            xMLEventReceiver.terminate();
        }
        catch (DataModelException dataModelException) {
            this.execContext.error(xQuery.body, new EvalException(dataModelException.getMessage(), dataModelException));
        }
        this.execContext = null;
    }

    public void executeQuery(XQuery xQuery, Writer writer) throws XQueryException {
        XMLSerializer xMLSerializer = new XMLSerializer();
        xMLSerializer.setOutput(writer);
        this.executeQuery(xQuery, xMLSerializer);
    }

    public void stopExecution() {
        if (this.execContext != null) {
            this.execContext.setStopped(true);
        }
    }

    public void pauseExecution(PauseHandler pauseHandler) {
        if (this.execContext != null) {
            this.execContext.setPauseHandler(pauseHandler);
        }
    }

    public Value eval(String string, Focus focus, EvalContext evalContext) throws XQueryException {
        Parser parser = new Parser(this.moduleMan);
        parser.setPredefinedModule(this.predefined);
        parser.setCollations(this.collations);
        if (this.extraNS != null) {
            parser.setPredefinedNamespaces(this.extraNS);
        }
        XQuery xQuery = parser.parseInContext(string, evalContext);
        Log log = evalContext.getLog();
        int n = log.getErrorCount();
        xQuery.staticCheck(this.moduleMan, log);
        int n2 = log.getErrorCount() - n;
        if (n2 > 0) {
            throw new XQueryException("static analysis: " + n2 + " error" + (n2 > 1 ? "s" : ""));
        }
        return xQuery.eval(focus, evalContext);
    }

    public IDocument xslTransform(Node node, String string, Properties properties, Properties properties2) throws TransformerException, XQueryException {
        Object object;
        Object object2;
        Templates templates = this.moduleMan.loadTemplates(string);
        Transformer transformer = templates.newTransformer();
        SAXSource sAXSource = null;
        Object object3 = null;
        IDocument iDocument = null;
        sAXSource = new SAXSource(new SAXSourceWrapper(node), new InputSource(new StringReader("<dummy/>")));
        String string2 = properties2.getProperty(XSLT_OUTPUT_FILE);
        if (string2 != null) {
            object3 = new StreamResult(string2);
        } else {
            iDocument = new IDocument();
            object2 = new SAXResult();
            ((SAXResult)object2).setHandler(iDocument);
            ((SAXResult)object2).setLexicalHandler(iDocument);
            ((SAXResult)object2).setSystemId(FileUtil.fileToURLName("."));
            object3 = object2;
        }
        object2 = properties2.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            if (((String)object).equals(XSLT_OUTPUT_FILE)) continue;
            transformer.setOutputProperty((String)object, properties2.getProperty((String)object));
        }
        object = properties.keys();
        while (object.hasMoreElements()) {
            String string3 = (String)object.nextElement();
            transformer.setParameter(string3, properties.get(string3));
        }
        transformer.transform(sAXSource, (Result)object3);
        return iDocument;
    }

    public static interface PauseHandler {
        public void pauseAt(EvalContext var1);
    }
}

