/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.IntegerArraySequence;
import net.xfra.qizxopen.xquery.dt.ShortType;
import net.xfra.qizxopen.xquery.dt.SingleInteger;
import net.xfra.qizxopen.xquery.op.Expression;

public class ByteType
extends ShortType {
    public String getShortName() {
        return "byte";
    }

    protected long upperBound() {
        return 127L;
    }

    protected long lowerBound() {
        return -128L;
    }

    public Value convertFromObject(Object object) {
        return new SingleInteger(((Byte)object).byteValue(), Type.BYTE);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws XQueryException {
        return new Byte((byte)expression.evalAsInteger(focus, evalContext));
    }

    public Value convertFromArray(Object object) {
        byte[] byArray = (byte[])object;
        return new IntegerArraySequence(byArray, byArray.length);
    }

    public Object convertToArray(Value value) throws XQueryException {
        return IntegerArraySequence.expandBytes(value);
    }
}

