/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.GenericValue;
import net.xfra.qizxopen.xquery.dt.SingleDouble;

public class FloatArraySequence
extends GenericValue {
    protected double[] items;
    protected int size;
    protected int index = -1;

    public FloatArraySequence(double[] dArray, int n) {
        this.items = dArray;
        this.size = n;
    }

    public FloatArraySequence(float[] fArray, int n) {
        double[] dArray = new double[n];
        int n2 = n;
        while (--n2 >= 0) {
            dArray[n2] = fArray[n2];
        }
        this.items = dArray;
        this.size = n;
    }

    public boolean next() throws XQueryException {
        if (++this.index >= this.size) {
            return false;
        }
        this.item = new SingleDouble(this.items[this.index]);
        return true;
    }

    public Value bornAgain() {
        return new FloatArraySequence(this.items, this.size);
    }

    static double[] unroll(Value value) throws XQueryException {
        double[] dArray = new double[8];
        int n = 1;
        while (value.next()) {
            if (n >= dArray.length) {
                double[] dArray2 = dArray;
                dArray = new double[dArray2.length * 2];
                System.arraycopy(dArray2, 0, dArray, 0, dArray2.length);
            }
            dArray[n++] = value.asDouble();
        }
        dArray[0] = n - 1;
        return dArray;
    }

    public static float[] expandFloats(Value value) throws XQueryException {
        double[] dArray = FloatArraySequence.unroll(value);
        int n = (int)dArray[0];
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = (float)dArray[n2 + 1];
            ++n2;
        }
        return fArray;
    }

    public static double[] expandDoubles(Value value) throws XQueryException {
        double[] dArray = FloatArraySequence.unroll(value);
        int n = (int)dArray[0];
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 1, dArray2, 0, n);
        return dArray2;
    }
}

