/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.util.Date;
import net.xfra.qizxopen.util.time.DateTime;
import net.xfra.qizxopen.util.time.DateTimeBase;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.AtomicType;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.SingleMoment;
import net.xfra.qizxopen.xquery.op.Expression;

public class MomentType
extends AtomicType {
    public String getShortName() {
        return "moment";
    }

    public Value convertFromObject(Object object) {
        Date date = (Date)object;
        return new SingleMoment(DateTime.fromDate(date, 0), Type.DATE_TIME);
    }

    public Object convertToObject(Expression expression, Focus focus, EvalContext evalContext) throws XQueryException {
        Item item = expression.evalAsItem(focus, evalContext);
        DateTimeBase dateTimeBase = ((MomentValue)item).getValue();
        return new Date((long)(1000.0 * dateTimeBase.getSecondsFromEpoch()));
    }
}

