/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.GenericValue;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.dt.SingleWrappedObject;
import net.xfra.qizxopen.xquery.dt.WrappedObjectType;
import net.xfra.qizxopen.xquery.dt.WrappedObjectValue;

public class ObjectArraySequence
extends GenericValue {
    protected Object[] items;
    protected int size;
    protected int index = -1;

    public ObjectArraySequence(Object[] objectArray, int n, ItemType itemType) {
        this.items = objectArray;
        this.size = n;
        this.itemType = itemType;
    }

    public ObjectArraySequence(Vector vector, ItemType itemType) {
        this.items = vector.toArray();
        this.size = this.items.length;
        this.itemType = itemType;
    }

    public ObjectArraySequence(ArrayList arrayList, ItemType itemType) {
        this.items = arrayList.toArray();
        this.size = this.items.length;
        this.itemType = itemType;
    }

    public ObjectArraySequence(Enumeration enumeration, ItemType itemType) {
        Object[] objectArray = new Object[4];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            if (n >= objectArray.length) {
                Object[] objectArray2 = objectArray;
                objectArray = new Object[objectArray2.length * 2];
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            }
            objectArray[n++] = enumeration.nextElement();
        }
        this.items = objectArray;
        this.size = n;
        this.itemType = itemType;
    }

    public boolean next() throws XQueryException {
        if (++this.index >= this.size) {
            return false;
        }
        this.item = this.items[this.index] instanceof String ? new SingleString((String)this.items[this.index]) : new SingleWrappedObject(this.items[this.index], this.itemType);
        return true;
    }

    public Value bornAgain() {
        return new ObjectArraySequence(this.items, this.size, this.itemType);
    }

    private static Object[] newArray(Class clazz, int n) {
        return clazz == null ? new Object[n] : (Object[])Array.newInstance(clazz, n);
    }

    public static Object[] expand(Value value, Class clazz) throws XQueryException {
        Object[] objectArray;
        Object[] objectArray2 = ObjectArraySequence.newArray(clazz, 8);
        int n = 0;
        while (value.next()) {
            if (n >= objectArray2.length) {
                objectArray = objectArray2;
                objectArray2 = ObjectArraySequence.newArray(clazz, objectArray.length * 2);
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            }
            objectArray = value.getType();
            Object object = null;
            object = objectArray == Type.STRING ? value.asString() : (objectArray instanceof WrappedObjectType ? ((WrappedObjectValue)value.asItem()).getObject() : value.asItem());
            try {
                objectArray2[n++] = object;
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new TypeException("bad item type: " + objectArray + ", in Java array[" + clazz + "]");
            }
        }
        if (n == objectArray2.length) {
            return objectArray2;
        }
        objectArray = ObjectArraySequence.newArray(clazz, n);
        System.arraycopy(objectArray2, 0, objectArray, 0, n);
        return objectArray;
    }
}

