/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.impl;

import java.io.PrintWriter;
import java.text.Collator;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.DocumentManager;
import net.xfra.qizxopen.dm.FONIDocument;
import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.util.time.Duration;
import net.xfra.qizxopen.xquery.EmptyException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Log;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.XQueryProcessor;
import net.xfra.qizxopen.xquery.dm.FONIDataModel;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.SingleDouble;
import net.xfra.qizxopen.xquery.dt.SingleInteger;
import net.xfra.qizxopen.xquery.dt.SingleItem;
import net.xfra.qizxopen.xquery.dt.SingleNode;
import net.xfra.qizxopen.xquery.dt.SingleString;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.UserFunction;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.GlobalVariable;

public class DefaultEvalContext
implements EvalContext {
    protected EvalContext upContext;
    protected UserFunction.Call called;
    protected StaticPart staticPart;
    protected Expression point;
    protected int depth;
    boolean traceExec;
    protected Value[] locals;
    public long registerInt0;
    public long registerInt1;
    public long registerInt2;
    public long registerInt3;
    public double registerDouble0;
    public double registerDouble1;
    public double registerDouble2;
    public double registerDouble3;
    public String registerString0;
    public String registerString1;
    public String registerString2;
    public String registerString3;
    public Item registerItem0;
    public Item registerItem1;
    public Item registerItem2;
    public Item registerItem3;
    public Item registerItem4;
    public Item registerItem5;
    public Item registerItem6;
    public Item registerItem7;

    public DefaultEvalContext(StaticContext staticContext, int n) {
        this.upContext = null;
        this.locals = n > 0 ? new Value[n] : null;
        this.depth = 200;
        this.staticPart = new StaticPart();
        this.staticPart.input = null;
        this.staticPart.context = staticContext;
        this.staticPart.globals = new HashMap();
        this.staticPart.documents = new HashMap();
        Calendar calendar = Calendar.getInstance();
        this.staticPart.currentDate = calendar.getTime();
        this.staticPart.implicitTimezone = calendar.get(15) / 60000;
    }

    public DefaultEvalContext(int n) {
        this.locals = n > 0 ? new Value[n] : null;
    }

    public StaticContext getStaticContext() {
        return this.staticPart.context;
    }

    public EvalContext getCallerContext() {
        return this.upContext;
    }

    public EvalContext subContext(UserFunction.Call call) throws EvalException {
        if (this.depth < 1) {
            throw new EvalException("stack overflow");
        }
        DefaultEvalContext defaultEvalContext = new DefaultEvalContext(call.getLocalSize());
        defaultEvalContext.upContext = this;
        defaultEvalContext.called = call;
        defaultEvalContext.staticPart = this.staticPart;
        defaultEvalContext.depth = this.depth - 1;
        defaultEvalContext.traceExec = this.traceExec;
        return defaultEvalContext;
    }

    public Value error(Expression expression, String string) throws EvalException {
        return this.error(expression, new EvalException(string));
    }

    public Value error(Expression expression, EvalException evalException) throws EvalException {
        this.point = expression;
        evalException.setContext(this);
        throw evalException;
    }

    public String displayFrame() {
        if (this.point != null && this.point.module == null) {
            System.err.println("NULL MODULE");
            return this.point.toString() + " at ?";
        }
        if (this.called != null && this.called.prototype == null) {
            System.err.println("NULL prototype");
            return this.point.toString() + " ?";
        }
        return "in " + (this.called == null ? "main query" : this.called.prototype.toString(this.staticPart.context)) + " in " + (this.point == null ? "?nowhere?" : this.point.module.printLocation(this.point.location));
    }

    public void printStack(Log log, int n) {
        log.info(this.point.module, this.point.location, this.displayFrame());
        if (this.upContext != null) {
            if (n > 0) {
                this.upContext.printStack(log, n - 1);
            } else {
                log.info("...");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void at(Expression expression) throws XQueryException {
        Object object;
        if (expression != null) {
            this.point = expression;
            if (this.traceExec) {
                object = null;
                object = expression instanceof Function.Call ? ((Function.Call)expression).prototype.toString(this) : expression.toString();
                System.err.println(" at " + expression.location + " " + (String)object);
            }
        }
        if (this.staticPart.stopped) {
            if (this.staticPart.pauseHandler == null) {
                this.error(expression, this.staticPart.timeout ? "time limit reached" : "stopped");
            } else {
                object = this.staticPart.pauseHandler;
                this.setPauseHandler(null);
                object.pauseAt(this);
                Object object2 = object;
                synchronized (object2) {
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void setTimeOut(boolean bl) {
        this.staticPart.stopped = bl;
        this.staticPart.timeout = bl;
    }

    public void setStopped(boolean bl) {
        this.staticPart.stopped = bl;
        this.staticPart.timeout = false;
    }

    public void setPauseHandler(XQueryProcessor.PauseHandler pauseHandler) {
        this.staticPart.pauseHandler = pauseHandler;
        this.staticPart.stopped = pauseHandler != null;
    }

    public void setExecTrace(boolean bl) {
        this.traceExec = bl;
    }

    public Expression getCurrentLocation() {
        return this.point;
    }

    public Value loadGlobal(GlobalVariable globalVariable) throws XQueryException {
        Value value = (Value)this.staticPart.globals.get(globalVariable);
        if (value == null) {
            this.error((Expression)globalVariable, "variable $" + globalVariable.name + " has no specified value");
        }
        return value.bornAgain();
    }

    public void setGlobal(GlobalVariable globalVariable, Value value) throws XQueryException {
        value = Type.ITEM.star.check(value);
        this.staticPart.globals.put(globalVariable, value);
    }

    public Value loadLocal(int n) throws XQueryException {
        switch (n) {
            case 0: {
                return new SingleInteger(this.registerInt0);
            }
            case 1: {
                return new SingleInteger(this.registerInt1);
            }
            case 2: {
                return new SingleInteger(this.registerInt2);
            }
            case 3: {
                return new SingleInteger(this.registerInt3);
            }
            case 4: {
                return new SingleDouble(this.registerDouble0);
            }
            case 5: {
                return new SingleDouble(this.registerDouble1);
            }
            case 6: {
                return new SingleDouble(this.registerDouble2);
            }
            case 7: {
                return new SingleDouble(this.registerDouble3);
            }
            case 8: {
                return new SingleString(this.registerString0);
            }
            case 9: {
                return new SingleString(this.registerString1);
            }
            case 10: {
                return new SingleString(this.registerString2);
            }
            case 11: {
                return new SingleString(this.registerString3);
            }
            case 12: {
                return new SingleItem(this.registerItem0);
            }
            case 13: {
                return new SingleItem(this.registerItem1);
            }
            case 14: {
                return new SingleItem(this.registerItem2);
            }
            case 15: {
                return new SingleItem(this.registerItem3);
            }
            case 16: {
                return new SingleItem(this.registerItem4);
            }
            case 17: {
                return new SingleItem(this.registerItem5);
            }
            case 18: {
                return new SingleItem(this.registerItem6);
            }
            case 19: {
                return new SingleItem(this.registerItem7);
            }
        }
        return this.locals[n - 20].bornAgain();
    }

    public long loadLocalInteger(int n) throws XQueryException {
        switch (n) {
            case 0: {
                return this.registerInt0;
            }
            case 1: {
                return this.registerInt1;
            }
            case 2: {
                return this.registerInt2;
            }
            case 3: {
                return this.registerInt3;
            }
            case 4: {
                return (long)this.registerDouble0;
            }
            case 5: {
                return (long)this.registerDouble1;
            }
            case 6: {
                return (long)this.registerDouble2;
            }
            case 7: {
                return (long)this.registerDouble3;
            }
            case 8: {
                return Conversion.toInteger(this.registerString0);
            }
            case 9: {
                return Conversion.toInteger(this.registerString1);
            }
            case 10: {
                return Conversion.toInteger(this.registerString2);
            }
            case 11: {
                return Conversion.toInteger(this.registerString3);
            }
            case 12: {
                return this.registerItem0.asInteger();
            }
            case 13: {
                return this.registerItem1.asInteger();
            }
            case 14: {
                return this.registerItem2.asInteger();
            }
            case 15: {
                return this.registerItem3.asInteger();
            }
            case 16: {
                return this.registerItem4.asInteger();
            }
            case 17: {
                return this.registerItem5.asInteger();
            }
            case 18: {
                return this.registerItem6.asInteger();
            }
            case 19: {
                return this.registerItem7.asInteger();
            }
        }
        Value value = this.locals[n - 20].bornAgain();
        if (!value.next()) {
            throw new TypeException("unexpected empty sequence");
        }
        long l = value.asInteger();
        if (value.next()) {
            throw new TypeException("too many items");
        }
        return l;
    }

    public double loadLocalDouble(int n) throws XQueryException {
        switch (n) {
            case 0: {
                return this.registerInt0;
            }
            case 1: {
                return this.registerInt1;
            }
            case 2: {
                return this.registerInt2;
            }
            case 3: {
                return this.registerInt3;
            }
            case 4: {
                return this.registerDouble0;
            }
            case 5: {
                return this.registerDouble1;
            }
            case 6: {
                return this.registerDouble2;
            }
            case 7: {
                return this.registerDouble3;
            }
            case 8: {
                return Conversion.toDouble(this.registerString0);
            }
            case 9: {
                return Conversion.toDouble(this.registerString1);
            }
            case 10: {
                return Conversion.toDouble(this.registerString2);
            }
            case 11: {
                return Conversion.toDouble(this.registerString3);
            }
            case 12: {
                return this.registerItem0.asDouble();
            }
            case 13: {
                return this.registerItem1.asDouble();
            }
            case 14: {
                return this.registerItem2.asDouble();
            }
            case 15: {
                return this.registerItem3.asDouble();
            }
            case 16: {
                return this.registerItem4.asDouble();
            }
            case 17: {
                return this.registerItem5.asDouble();
            }
            case 18: {
                return this.registerItem6.asDouble();
            }
            case 19: {
                return this.registerItem7.asDouble();
            }
        }
        Value value = this.locals[n - 20].bornAgain();
        if (!value.next()) {
            throw EmptyException.allowed();
        }
        double d = value.asDouble();
        if (value.next()) {
            throw new TypeException("too many items");
        }
        return d;
    }

    public String loadLocalString(int n) throws XQueryException {
        switch (n) {
            case 0: {
                return Conversion.toString(this.registerInt0);
            }
            case 1: {
                return Conversion.toString(this.registerInt1);
            }
            case 2: {
                return Conversion.toString(this.registerInt2);
            }
            case 3: {
                return Conversion.toString(this.registerInt3);
            }
            case 4: {
                return Conversion.toString(this.registerDouble0);
            }
            case 5: {
                return Conversion.toString(this.registerDouble1);
            }
            case 6: {
                return Conversion.toString(this.registerDouble2);
            }
            case 7: {
                return Conversion.toString(this.registerDouble3);
            }
            case 8: {
                return this.registerString0;
            }
            case 9: {
                return this.registerString1;
            }
            case 10: {
                return this.registerString2;
            }
            case 11: {
                return this.registerString3;
            }
            case 12: {
                return this.registerItem0.asString();
            }
            case 13: {
                return this.registerItem1.asString();
            }
            case 14: {
                return this.registerItem2.asString();
            }
            case 15: {
                return this.registerItem3.asString();
            }
            case 16: {
                return this.registerItem4.asString();
            }
            case 17: {
                return this.registerItem5.asString();
            }
            case 18: {
                return this.registerItem6.asString();
            }
            case 19: {
                return this.registerItem7.asString();
            }
        }
        Value value = this.locals[n - 20].bornAgain();
        if (!value.next()) {
            throw new TypeException("unexpected empty sequence");
        }
        String string = value.asString();
        if (value.next()) {
            throw new TypeException("too many items");
        }
        return string;
    }

    public Item loadLocalItem(int n) throws XQueryException {
        switch (n) {
            case 0: {
                return new SingleInteger(this.registerInt0);
            }
            case 1: {
                return new SingleInteger(this.registerInt1);
            }
            case 2: {
                return new SingleInteger(this.registerInt2);
            }
            case 3: {
                return new SingleInteger(this.registerInt3);
            }
            case 4: {
                return new SingleDouble(this.registerDouble0);
            }
            case 5: {
                return new SingleDouble(this.registerDouble1);
            }
            case 6: {
                return new SingleDouble(this.registerDouble2);
            }
            case 7: {
                return new SingleDouble(this.registerDouble3);
            }
            case 8: {
                return new SingleString(this.registerString0);
            }
            case 9: {
                return new SingleString(this.registerString1);
            }
            case 10: {
                return new SingleString(this.registerString2);
            }
            case 11: {
                return new SingleString(this.registerString3);
            }
            case 12: {
                return this.registerItem0;
            }
            case 13: {
                return this.registerItem1;
            }
            case 14: {
                return this.registerItem2;
            }
            case 15: {
                return this.registerItem3;
            }
            case 16: {
                return this.registerItem4;
            }
            case 17: {
                return this.registerItem5;
            }
            case 18: {
                return this.registerItem6;
            }
            case 19: {
                return this.registerItem7;
            }
        }
        Value value = this.locals[n - 20].bornAgain();
        if (!value.next()) {
            throw new TypeException("unexpected empty sequence");
        }
        Item item = value.asItem();
        if (value.next()) {
            throw new TypeException("too many items");
        }
        return item;
    }

    public void storeLocal(int n, Expression expression, Type type, Focus focus, EvalContext evalContext) throws XQueryException {
        switch (n) {
            case 0: {
                this.registerInt0 = expression.evalAsInteger(focus, evalContext);
                break;
            }
            case 1: {
                this.registerInt1 = expression.evalAsInteger(focus, evalContext);
                break;
            }
            case 2: {
                this.registerInt2 = expression.evalAsInteger(focus, evalContext);
                break;
            }
            case 3: {
                this.registerInt3 = expression.evalAsInteger(focus, evalContext);
                break;
            }
            case 4: {
                this.registerDouble0 = expression.evalAsDouble(focus, evalContext);
                break;
            }
            case 5: {
                this.registerDouble1 = expression.evalAsDouble(focus, evalContext);
                break;
            }
            case 6: {
                this.registerDouble2 = expression.evalAsDouble(focus, evalContext);
                break;
            }
            case 7: {
                this.registerDouble3 = expression.evalAsDouble(focus, evalContext);
                break;
            }
            case 8: {
                this.registerString0 = expression.evalAsString(focus, evalContext);
                break;
            }
            case 9: {
                this.registerString1 = expression.evalAsString(focus, evalContext);
                break;
            }
            case 10: {
                this.registerString2 = expression.evalAsString(focus, evalContext);
                break;
            }
            case 11: {
                this.registerString3 = expression.evalAsString(focus, evalContext);
                break;
            }
            case 12: {
                this.registerItem0 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 13: {
                this.registerItem1 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 14: {
                this.registerItem2 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 15: {
                this.registerItem3 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 16: {
                this.registerItem4 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 17: {
                this.registerItem5 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 18: {
                this.registerItem6 = expression.evalAsItem(focus, evalContext);
                break;
            }
            case 19: {
                this.registerItem7 = expression.evalAsItem(focus, evalContext);
                break;
            }
            default: {
                try {
                    Value value = expression.eval(focus, evalContext);
                    if (type != null) {
                        value = type.check(value);
                    }
                    this.locals[n - 20] = value;
                }
                catch (TypeException typeException) {
                    this.error(expression, typeException);
                }
                break;
            }
        }
    }

    public void storeLocal(int n, Value value, boolean bl) throws XQueryException {
        if (n < 20 && !bl && !value.next()) {
            throw new TypeException("unexpected empty sequence");
        }
        switch (n) {
            case 0: {
                this.registerInt0 = value.asInteger();
                break;
            }
            case 1: {
                this.registerInt1 = value.asInteger();
                break;
            }
            case 2: {
                this.registerInt2 = value.asInteger();
                break;
            }
            case 3: {
                this.registerInt3 = value.asInteger();
                break;
            }
            case 4: {
                this.registerDouble0 = value.asDouble();
                break;
            }
            case 5: {
                this.registerDouble1 = value.asDouble();
                break;
            }
            case 6: {
                this.registerDouble2 = value.asDouble();
                break;
            }
            case 7: {
                this.registerDouble3 = value.asDouble();
                break;
            }
            case 8: {
                this.registerString0 = value.asString();
                break;
            }
            case 9: {
                this.registerString1 = value.asString();
                break;
            }
            case 10: {
                this.registerString2 = value.asString();
                break;
            }
            case 11: {
                this.registerString3 = value.asString();
                break;
            }
            case 12: {
                this.registerItem0 = value.asItem();
                break;
            }
            case 13: {
                this.registerItem1 = value.asItem();
                break;
            }
            case 14: {
                this.registerItem2 = value.asItem();
                break;
            }
            case 15: {
                this.registerItem3 = value.asItem();
                break;
            }
            case 16: {
                this.registerItem4 = value.asItem();
                break;
            }
            case 17: {
                this.registerItem5 = value.asItem();
                break;
            }
            case 18: {
                this.registerItem6 = value.asItem();
                break;
            }
            case 19: {
                this.registerItem7 = value.asItem();
                break;
            }
            default: {
                this.locals[n - 20] = bl ? new SingleItem(value) : value;
            }
        }
    }

    public void storeLocalInteger(int n, long l) {
        switch (n) {
            case 0: {
                this.registerInt0 = l;
                break;
            }
            case 1: {
                this.registerInt1 = l;
                break;
            }
            case 2: {
                this.registerInt2 = l;
                break;
            }
            case 3: {
                this.registerInt3 = l;
                break;
            }
            default: {
                this.locals[n - 20] = new SingleInteger(l);
            }
        }
    }

    public void setInput(Value value) {
        this.staticPart.input = value;
    }

    public Value getInput() {
        return this.staticPart.input == null ? null : this.staticPart.input.bornAgain();
    }

    public Object getProperty(String string) {
        return this.staticPart.properties == null ? null : this.staticPart.properties.get(string);
    }

    public void setProperties(HashMap hashMap) {
        this.staticPart.properties = hashMap;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.staticPart.documentManager = documentManager;
    }

    public DocumentManager getDocumentManager() {
        return this.staticPart.documentManager;
    }

    public Value getDocument(String string) throws XQueryException {
        Node node = (Node)this.staticPart.documents.get(string);
        if (node == null) {
            try {
                FONIDocument fONIDocument = this.staticPart.documentManager.findDocument(string);
                node = new FONIDataModel(fONIDocument).getDocumentNode();
                this.staticPart.documents.put(string, node);
            }
            catch (DataModelException dataModelException) {
                Throwable throwable = dataModelException.getCause();
                if (throwable instanceof Exception) {
                    throw new EvalException(dataModelException.getMessage(), (Exception)throwable);
                }
                throw new EvalException(dataModelException.getMessage(), dataModelException);
            }
        }
        return new SingleNode(node);
    }

    public Collator getCollator(String string) throws XQueryException {
        return this.staticPart.context.getCollator(string);
    }

    public Date getCurrentDate() {
        return this.staticPart.currentDate;
    }

    public int getImplicitTimezone() {
        return this.staticPart.implicitTimezone;
    }

    public void setImplicitTimezone(int n) {
        this.staticPart.implicitTimezone = n;
    }

    public void setImplicitTimezone(String string) throws DateTimeException {
        this.staticPart.implicitTimezone = (int)(Duration.parseDuration(string).getSeconds() / 60.0);
    }

    public PrintWriter getDefaultOutput() {
        return this.staticPart.defaultOutput;
    }

    public void setDefaultOutput(PrintWriter printWriter) {
        this.staticPart.defaultOutput = printWriter;
    }

    public Log getLog() {
        return this.staticPart.log != null ? this.staticPart.log : this.staticPart.context.getLog();
    }

    public void setLog(Log log) {
        this.staticPart.log = log;
    }

    protected class StaticPart {
        StaticContext context;
        DocumentManager documentManager;
        HashMap globals;
        HashMap documents;
        HashMap properties;
        Value input;
        Date currentDate;
        int implicitTimezone;
        PrintWriter defaultOutput;
        Log log;
        boolean timeout;
        boolean stopped;
        XQueryProcessor.PauseHandler pauseHandler;

        protected StaticPart() {
        }
    }
}

