/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.CoreDataModel;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.NamedConstructor;

public class AttributeConstructor
extends NamedConstructor {
    public String value;
    public String prefix;

    public AttributeConstructor(Expression expression) {
        super(expression);
        this.type = Type.ATTRIBUTE;
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "attribute-constructor");
        exprDump.display("name", this.name);
        exprDump.display("contents", this.contents);
    }

    public Node evalAsNode(Focus focus, EvalContext evalContext) throws XQueryException {
        QName qName = this.evalName(null, focus, evalContext);
        CoreDataModel.Attribute attribute = CoreDataModel.newAttribute(qName);
        this.evalContents(attribute, focus, evalContext);
        return attribute;
    }

    public void evalAsEvents(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException, DataModelException {
        evalContext.at(this);
        QName qName = this.evalName(xMLEventReceiver, focus, evalContext);
        xMLEventReceiver.attribute(qName, this.evalContents(focus, evalContext));
    }
}

