/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.SingleBoolean;
import net.xfra.qizxopen.xquery.op.CastExpr;
import net.xfra.qizxopen.xquery.op.Expression;

public class CastableExpr
extends CastExpr {
    public CastableExpr(Expression expression, Type type) {
        super(expression, type);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "CastableExpr");
        exprDump.display("expr", this.expr);
        exprDump.display("type", this.type);
    }

    public Expression staticCheck(StaticContext staticContext) {
        this.expr = staticContext.staticCheck(this.expr, 0);
        this.type = Type.BOOLEAN;
        return this;
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        evalContext.at(this);
        return new SingleBoolean(this.evalAsBoolean(focus, evalContext));
    }

    public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws XQueryException {
        Value value = this.expr.eval(focus, evalContext);
        evalContext.at(this);
        if (!value.next()) {
            return this.isOptional;
        }
        try {
            this.targetType.cast(value, evalContext);
            return !value.next();
        }
        catch (TypeException typeException) {
            return false;
        }
    }
}

