/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.EventDrivenBuilder;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.NodeConstructor;

public class DocumentConstructor
extends NodeConstructor {
    public DocumentConstructor(Expression expression) {
        this.contents = new Expression[]{expression};
        this.type = Type.DOCUMENT;
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "DocumentConstructor");
        exprDump.display("contents", this.contents);
    }

    public Node evalAsNode(Focus focus, EvalContext evalContext) throws XQueryException {
        EventDrivenBuilder eventDrivenBuilder = new EventDrivenBuilder();
        try {
            this.evalAsEvents(eventDrivenBuilder, focus, evalContext);
            return eventDrivenBuilder.crop();
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
            return null;
        }
    }

    public void evalAsEvents(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException, DataModelException {
        evalContext.at(this);
        try {
            xMLEventReceiver.startDocument();
            int n = 0;
            while (n < this.contents.length) {
                this.contents[n].evalAsEvents(xMLEventReceiver, focus, evalContext);
                ++n;
            }
            xMLEventReceiver.endDocument();
        }
        catch (DataModelException dataModelException) {
            evalContext.error((Expression)this, "error in constructor: " + dataModelException.getMessage());
        }
    }
}

