/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import java.util.Arrays;
import java.util.Comparator;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EmptyException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.ArraySequence;
import net.xfra.qizxopen.xquery.dt.GenericValue;
import net.xfra.qizxopen.xquery.dt.IntegerValue;
import net.xfra.qizxopen.xquery.dt.StringValue;
import net.xfra.qizxopen.xquery.op.AndExpr;
import net.xfra.qizxopen.xquery.op.Comparison;
import net.xfra.qizxopen.xquery.op.Expr;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.ForClause;
import net.xfra.qizxopen.xquery.op.Join;
import net.xfra.qizxopen.xquery.op.LetClause;
import net.xfra.qizxopen.xquery.op.LocalVariable;
import net.xfra.qizxopen.xquery.op.NodeSortExpr;
import net.xfra.qizxopen.xquery.op.OrderSpec;
import net.xfra.qizxopen.xquery.op.PathExpr;
import net.xfra.qizxopen.xquery.op.ValueNeOp;
import net.xfra.qizxopen.xquery.op.VarClause;
import net.xfra.qizxopen.xquery.op.VarReference;

public class FLWRExpr
extends Expression {
    Expression[] clauses = new Expression[0];
    public Expression where;
    public boolean stableOrder;
    public boolean checked;
    OrderSpec[] orderSpecs;
    public Expression expr;
    static int genId;

    public void addClause(VarClause varClause) {
        this.clauses = Expression.addExpr(this.clauses, varClause);
    }

    public void addClause(VarClause varClause, VarClause varClause2) {
        this.clauses = Expression.addExpr(this.clauses, varClause);
        int n = this.clauses.length;
        while (--n > 0) {
            this.clauses[n] = this.clauses[n - 1];
            if (this.clauses[n] != varClause2) continue;
            this.clauses[n - 1] = varClause;
            break;
        }
    }

    VarClause getClause(int n) {
        return n < 0 || n >= this.clauses.length ? null : (VarClause)this.clauses[n];
    }

    static synchronized int generateId() {
        return ++genId;
    }

    public void addOrderSpec(OrderSpec orderSpec) {
        if (this.orderSpecs == null) {
            this.orderSpecs = new OrderSpec[]{orderSpec};
        } else {
            OrderSpec[] orderSpecArray = this.orderSpecs;
            this.orderSpecs = new OrderSpec[orderSpecArray.length + 1];
            System.arraycopy(orderSpecArray, 0, this.orderSpecs, 0, orderSpecArray.length);
            this.orderSpecs[orderSpecArray.length] = orderSpec;
        }
    }

    OrderSpec getOrderSpec(int n) {
        return n < 0 || this.orderSpecs == null || n >= this.orderSpecs.length ? null : this.orderSpecs[n];
    }

    public Expression child(int n) {
        if (n < this.clauses.length) {
            return this.clauses[n];
        }
        n -= this.clauses.length;
        if (this.where != null) {
            if (n == 0) {
                return this.where;
            }
            --n;
        }
        if (n < this.orderSpecs.length) {
            return this.orderSpecs[n];
        }
        return (n -= this.orderSpecs.length) == 0 ? this.expr : null;
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "FLOWER");
        exprDump.display("clauses", this.clauses);
        if (this.where != null) {
            exprDump.displayp("where", this.where);
        }
        if (this.orderSpecs != null) {
            exprDump.display("orderby", this.orderSpecs);
        }
        exprDump.displayp("return", this.expr);
    }

    public Expression staticCheck(StaticContext staticContext) {
        Object object;
        LocalVariable localVariable = staticContext.markLocalVariables();
        int n = 0;
        while (n < this.clauses.length) {
            ((VarClause)this.clauses[n]).owner = this;
            staticContext.staticCheck(this.clauses[n], 0);
            ++n;
        }
        if (this.where != null) {
            this.where = staticContext.staticCheck(this.where, 0);
        }
        this.expr = staticContext.staticCheck(this.expr, 0);
        this.type = this.expr.getType().getItemType().star;
        if (this.orderSpecs != null) {
            int n2 = 0;
            while (n2 < this.orderSpecs.length) {
                staticContext.staticCheck(this.orderSpecs[n2], 0);
                ++n2;
            }
        }
        if (this.where != null && (object = this.joinablePredicate(this.where)) != null) {
            LocalVariable localVariable2;
            this.where = ((JoinInfo)object).remainder;
            ForClause forClause = (ForClause)((JoinInfo)object).innerVar.owner;
            LocalVariable localVariable3 = ((JoinInfo)object).outerVar;
            while ((localVariable2 = localVariable3.before) != null) {
                if (localVariable2.name == null || Expr.depends(forClause.expr, localVariable2)) break;
                localVariable3 = localVariable2;
            }
            QName qName = QName.get("#join" + FLWRExpr.generateId());
            LocalVariable localVariable4 = new LocalVariable(qName, Type.WRAPPED_OBJECT, null);
            localVariable4.declareBefore(localVariable3);
            LetClause letClause = new LetClause(qName);
            localVariable4.owner = letClause;
            letClause.varDecl = localVariable4;
            QName qName2 = QName.get("#jtmp");
            LocalVariable localVariable5 = new LocalVariable(qName2, Type.NODE, null);
            localVariable4.addAfter(localVariable5);
            new Expr.VarReplacer(((JoinInfo)object).innerVar, localVariable5).visit(((JoinInfo)object).innerExpr);
            letClause.expr = new Join.Maker(forClause.expr, ((JoinInfo)object).innerExpr, localVariable5, ((JoinInfo)object).type);
            VarClause varClause = (VarClause)localVariable3.owner;
            FLWRExpr fLWRExpr = (FLWRExpr)varClause.owner;
            letClause.owner = fLWRExpr;
            fLWRExpr.addClause(letClause, varClause);
            forClause.expr = new Join.GetExpr(((JoinInfo)object).outerExpr, localVariable4, ((JoinInfo)object).comparison);
        }
        staticContext.popLocalVariables(localVariable);
        object = FLWRExpr.tryToRemoveWhere(this);
        return FLWRExpr.tryToRemoveLoop((FLWRExpr)object);
    }

    JoinInfo joinablePredicate(Expression expression) {
        if (expression instanceof AndExpr) {
            AndExpr andExpr = (AndExpr)expression;
            int n = andExpr.args.length;
            int n2 = 0;
            while (n2 < n) {
                JoinInfo joinInfo = this.joinablePredicate(andExpr.args[n2]);
                if (joinInfo != null) {
                    if (n == 2) {
                        joinInfo.remainder = andExpr.args[1 - n2];
                    } else {
                        AndExpr andExpr2 = new AndExpr();
                        andExpr2.args = new Expression[n - 1];
                        System.arraycopy(andExpr.args, 0, andExpr2.args, 0, n2);
                        System.arraycopy(andExpr.args, n2 + 1, andExpr2.args, n2, n - n2 - 1);
                        joinInfo.remainder = andExpr2;
                    }
                    return joinInfo;
                }
                ++n2;
            }
            return null;
        }
        if (!(expression instanceof Comparison.Exec)) {
            return null;
        }
        Comparison.Exec exec = (Comparison.Exec)expression;
        Expression expression2 = exec.args[0];
        Expression expression3 = exec.args[1];
        if (expression2 instanceof NodeSortExpr) {
            expression2 = ((NodeSortExpr)expression2).expr;
        }
        if (expression3 instanceof NodeSortExpr) {
            expression3 = ((NodeSortExpr)expression3).expr;
        }
        Expr.ForVarCollector forVarCollector = new Expr.ForVarCollector();
        forVarCollector.visit(expression2);
        if (forVarCollector.found == null || forVarCollector.found2 != null) {
            return null;
        }
        LocalVariable localVariable = forVarCollector.found;
        forVarCollector.found = null;
        forVarCollector.visit(expression3);
        if (forVarCollector.found == null || forVarCollector.found2 != null) {
            return null;
        }
        LocalVariable localVariable2 = forVarCollector.found;
        if (localVariable == localVariable2 || exec.test == ValueNeOp.TEST) {
            return null;
        }
        if (!Type.NODE.accepts(localVariable.getType().getItemType()) || !Type.NODE.accepts(localVariable2.getType().getItemType())) {
            return null;
        }
        JoinInfo joinInfo = new JoinInfo();
        joinInfo.outerVar = localVariable;
        joinInfo.innerVar = localVariable2;
        joinInfo.outerExpr = expression2;
        joinInfo.innerExpr = expression3;
        LocalVariable localVariable3 = localVariable2;
        while (localVariable3 != null && localVariable3 != localVariable) {
            localVariable3 = localVariable3.before;
        }
        if (localVariable3 == null) {
            exec.args[0] = expression3;
            exec.args[1] = expression2;
            exec.test = exec.test.reverse();
            joinInfo.outerVar = localVariable2;
            joinInfo.innerVar = localVariable;
            joinInfo.outerExpr = expression3;
            joinInfo.innerExpr = expression2;
        }
        joinInfo.comparison = exec.test;
        ItemType itemType = expression2.getType().getItemType();
        ItemType itemType2 = expression3.getType().getItemType();
        if (Type.NUMERIC.isSuperType(itemType) || Type.NUMERIC.isSuperType(itemType2)) {
            joinInfo.type = Type.NUMERIC;
        } else if (Type.STRING.accepts(itemType) && Type.STRING.accepts(itemType2)) {
            joinInfo.type = Type.STRING;
        }
        return joinInfo;
    }

    static FLWRExpr tryToRemoveWhere(FLWRExpr fLWRExpr) {
        if (fLWRExpr.clauses.length != 1 || fLWRExpr.where == null || fLWRExpr.orderSpecs != null) {
            return fLWRExpr;
        }
        VarClause varClause = fLWRExpr.getClause(0);
        if (!(varClause instanceof ForClause)) {
            return fLWRExpr;
        }
        Expression expression = varClause.expr;
        if (expression instanceof NodeSortExpr) {
            expression = ((NodeSortExpr)expression).expr;
        }
        if (!(expression instanceof PathExpr)) {
            return fLWRExpr;
        }
        LocalVariable localVariable = varClause.varDecl;
        Expr.DottingVarFinder dottingVarFinder = new Expr.DottingVarFinder(localVariable);
        if (!dottingVarFinder.visit(fLWRExpr.where)) {
            return fLWRExpr;
        }
        new Expr.VarReplacer(localVariable, null).visit(fLWRExpr.where);
        varClause.expr = Expr.addPredicate(varClause.expr, fLWRExpr.where);
        fLWRExpr.where = null;
        return fLWRExpr;
    }

    static Expression tryToRemoveLoop(FLWRExpr fLWRExpr) {
        if (fLWRExpr.clauses.length != 1 || fLWRExpr.orderSpecs != null || fLWRExpr.where != null) {
            return fLWRExpr;
        }
        VarClause varClause = fLWRExpr.getClause(0);
        if (!(varClause instanceof ForClause) || !(fLWRExpr.expr instanceof VarReference.Local)) {
            return fLWRExpr;
        }
        LocalVariable localVariable = varClause.varDecl;
        VarReference.Local local = (VarReference.Local)fLWRExpr.expr;
        if (local.decl != localVariable) {
            return fLWRExpr;
        }
        return varClause.expr;
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        Object object;
        Object object2 = new VarClause.Sequence(focus, evalContext);
        int n = 0;
        while (n < this.clauses.length) {
            object = (VarClause.Sequence)this.clauses[n].eval(focus, evalContext);
            ((VarClause.Sequence)object).setSource((Value)object2);
            object2 = object;
            ++n;
        }
        if (this.orderSpecs == null) {
            object = this.expr.getType().getItemType();
            int n2 = this.expr.getType().getOccurrence();
            if (object == Type.INTEGER && !Type.isRepeatable(n2)) {
                return new IntSequence((Value)object2, focus, evalContext);
            }
            if (object == Type.STRING && !Type.isRepeatable(n2)) {
                return new StringSequence((Value)object2, focus, evalContext);
            }
            if (n2 == 0) {
                return new ItemSequence((Value)object2, focus, evalContext);
            }
        }
        object = new Sequence((Value)object2, focus, evalContext);
        if (this.orderSpecs != null) {
            return this.sorted((Value)object, focus, evalContext);
        }
        return object;
    }

    public void evalAsEvents(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException, DataModelException {
        evalContext.at(this);
        if (this.orderSpecs != null) {
            super.evalAsEvents(xMLEventReceiver, focus, evalContext);
            return;
        }
        VarClause.Sequence sequence = new VarClause.Sequence(focus, evalContext);
        int n = 0;
        while (n < this.clauses.length) {
            VarClause.Sequence sequence2 = (VarClause.Sequence)this.clauses[n].eval(focus, evalContext);
            sequence2.setSource(sequence);
            sequence = sequence2;
            ++n;
        }
        while (sequence.next()) {
            if (this.where != null && !this.where.evalEffectiveBooleanValue(focus, evalContext)) continue;
            evalContext.at(this.expr);
            this.expr.evalAsEvents(xMLEventReceiver, focus, evalContext);
        }
    }

    private ArraySequence sorted(Value value, Focus focus, EvalContext evalContext) throws XQueryException {
        Object[] objectArray = new Object[8];
        int n = 0;
        int n2 = this.orderSpecs.length;
        while (value.next()) {
            Object object;
            Item[] itemArray = new Item[n2 + 1];
            itemArray[0] = value.asItem();
            int n3 = 0;
            while (n3 < n2) {
                object = this.orderSpecs[n3].key.eval(focus, evalContext);
                if (!object.next()) {
                    itemArray[n3 + 1] = null;
                } else {
                    itemArray[n3 + 1] = object.asAtom();
                    if (object.next()) {
                        evalContext.error((Expression)this.orderSpecs[n3], "order key must be atomic");
                    }
                }
                ++n3;
            }
            if (n >= objectArray.length) {
                object = objectArray;
                objectArray = new Object[((Object[])object).length * 2];
                System.arraycopy(object, 0, objectArray, 0, ((Object)object).length);
            }
            objectArray[n++] = itemArray;
        }
        try {
            if (n > 1) {
                Arrays.sort(objectArray, 0, n, new KeyComparison(this.orderSpecs, evalContext.getImplicitTimezone()));
            }
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof XQueryException) {
                throw (XQueryException)runtimeException.getCause();
            }
            throw runtimeException;
        }
        int n4 = n;
        while (--n4 >= 0) {
            Item[] itemArray = (Item[])objectArray[n4];
            objectArray[n4] = itemArray[0];
        }
        return new ArraySequence(objectArray, n);
    }

    static class KeyComparison
    implements Comparator {
        OrderSpec[] orderSpecs;
        int keyCnt;
        int timezone;

        KeyComparison(OrderSpec[] orderSpecArray, int n) {
            this.orderSpecs = orderSpecArray;
            this.keyCnt = orderSpecArray.length;
            this.timezone = n;
        }

        public int compare(Object object, Object object2) {
            try {
                Item[] itemArray = (Item[])object;
                Item[] itemArray2 = (Item[])object2;
                int n = 0;
                int n2 = 1;
                while (n2 <= this.keyCnt) {
                    n = this.orderSpecs[n2 - 1].compare(itemArray[n2], itemArray2[n2], this.timezone);
                    if (n != 0) break;
                    ++n2;
                }
                return n;
            }
            catch (TypeException typeException) {
                throw new RuntimeException(typeException);
            }
        }
    }

    public class StringSequence
    extends StringValue {
        Focus focus;
        EvalContext context;
        Value source;
        String curItem;

        StringSequence(Value value, Focus focus, EvalContext evalContext) {
            this.source = value;
            this.focus = focus;
            this.context = evalContext;
        }

        public Value bornAgain() {
            return new StringSequence(this.source.bornAgain(), this.focus, this.context);
        }

        public String asString() {
            return this.curItem;
        }

        public boolean next() throws XQueryException {
            while (this.source.next()) {
                if (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context)) continue;
                this.context.at(FLWRExpr.this.expr);
                try {
                    this.curItem = FLWRExpr.this.expr.evalAsOptString(this.focus, this.context);
                    return true;
                }
                catch (EmptyException emptyException) {
                    continue;
                }
                break;
            }
            return false;
        }
    }

    public class IntSequence
    extends IntegerValue {
        Focus focus;
        EvalContext context;
        Value source;
        long curItem;

        IntSequence(Value value, Focus focus, EvalContext evalContext) {
            this.source = value;
            this.focus = focus;
            this.context = evalContext;
        }

        public Value bornAgain() {
            return new IntSequence(this.source.bornAgain(), this.focus, this.context);
        }

        public long asInteger() {
            return this.curItem;
        }

        public boolean next() throws XQueryException {
            while (this.source.next()) {
                if (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context)) continue;
                this.context.at(FLWRExpr.this.expr);
                try {
                    this.curItem = FLWRExpr.this.expr.evalAsOptInteger(this.focus, this.context);
                    return true;
                }
                catch (EmptyException emptyException) {
                    continue;
                }
                break;
            }
            return false;
        }
    }

    public class ItemSequence
    extends GenericValue {
        Focus focus;
        EvalContext context;
        Value source;

        ItemSequence(Value value, Focus focus, EvalContext evalContext) {
            this.source = value;
            this.focus = focus;
            this.context = evalContext;
        }

        public Value bornAgain() {
            return new ItemSequence(this.source.bornAgain(), this.focus, this.context);
        }

        public boolean next() throws XQueryException {
            do {
                if (this.source.next()) continue;
                return false;
            } while (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context));
            this.context.at(FLWRExpr.this.expr);
            this.item = FLWRExpr.this.expr.evalAsItem(this.focus, this.context);
            return true;
        }

        public boolean nextCollection() throws XQueryException {
            do {
                if (this.source.nextCollection()) continue;
                return false;
            } while (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context));
            this.item = FLWRExpr.this.expr.evalAsItem(this.focus, this.context);
            return true;
        }
    }

    public class Sequence
    extends GenericValue {
        Focus focus;
        EvalContext context;
        Value source;
        Value current;

        Sequence(Value value, Focus focus, EvalContext evalContext) {
            this.source = value;
            this.focus = focus;
            this.context = evalContext;
            this.current = Value.empty;
        }

        public Value bornAgain() {
            return new Sequence(this.source.bornAgain(), this.focus, this.context);
        }

        public boolean next() throws XQueryException {
            while (true) {
                if (this.current.next()) {
                    if (!this.lazy) {
                        this.item = this.current.asItem();
                    }
                    return true;
                }
                do {
                    if (this.source.next()) continue;
                    return false;
                } while (FLWRExpr.this.where != null && !FLWRExpr.this.where.evalEffectiveBooleanValue(this.focus, this.context));
                this.current = FLWRExpr.this.expr.eval(this.focus, this.context);
            }
        }
    }

    public static class JoinInfo {
        LocalVariable outerVar;
        LocalVariable innerVar;
        Expression outerExpr;
        Expression innerExpr;
        Expression remainder;
        Comparison.Test comparison;
        Type type;
    }
}

