/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.LocalVariable;
import net.xfra.qizxopen.xquery.op.VarClause;

public class ForClause
extends VarClause {
    public QName position;
    public LocalVariable posDecl;

    public ForClause(QName qName) {
        super(qName);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "For");
        exprDump.display("variable", "$" + this.variable + " : " + this.varType + (exprDump.pretty() ? "" : " addr " + this.varDecl.address));
        if (this.position != null) {
            exprDump.display("position", this.position + " addr " + this.posDecl.address);
        }
        exprDump.display("expr", this.expr);
    }

    public Expression staticCheck(StaticContext staticContext) {
        if (this.checked) {
            return this;
        }
        this.checked = true;
        this.expr = staticContext.staticCheck(this.expr, 0);
        this.type = this.varType;
        if (this.varType == null) {
            this.varType = this.expr.getType().getItemType();
        } else {
            ItemType itemType = this.expr.getType().getItemType();
            if (!this.varType.accepts(itemType)) {
                staticContext.error(this, "incompatible value type %2 for variable %1", staticContext.prefixedName(this.variable), itemType.toString(staticContext));
            }
        }
        this.varDecl = staticContext.defineLocalVariable(this.variable, this.varType, this);
        this.varDecl.defineType(this.varType);
        if (this.position != null) {
            this.posDecl = staticContext.defineLocalVariable(this.position, Type.INTEGER, this);
        }
        return this;
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        return new Sequence(focus, evalContext);
    }

    public class Sequence
    extends VarClause.Sequence {
        Value current = Value.empty;
        int curPos;

        Sequence(Focus focus, EvalContext evalContext) {
            super(focus, evalContext);
        }

        public boolean next() throws XQueryException {
            while (true) {
                if (this.current.next()) {
                    try {
                        this.context.storeLocal(ForClause.this.varDecl.address, this.current, true);
                    }
                    catch (TypeException typeException) {
                        this.context.error((Expression)ForClause.this, "dynamic type mismatch on 'for' variable: " + typeException.getMessage() + ", expecting " + ForClause.this.varType);
                    }
                    ++this.curPos;
                    if (ForClause.this.position != null) {
                        this.context.storeLocalInteger(ForClause.this.posDecl.address, this.curPos);
                    }
                    return true;
                }
                if (!this.source.next()) {
                    return false;
                }
                this.current = ForClause.this.expr.eval(this.focus, this.context);
                this.curPos = 0;
            }
        }

        public boolean nextCollection() throws XQueryException {
            while (true) {
                if (this.current.nextCollection()) {
                    try {
                        this.context.storeLocal(ForClause.this.varDecl.address, this.current, true);
                    }
                    catch (TypeException typeException) {
                        this.context.error((Expression)ForClause.this, "dynamic type mismatch on 'for' variable: " + typeException.getMessage() + ", expecting " + ForClause.this.varType);
                    }
                    ++this.curPos;
                    if (ForClause.this.position != null) {
                        this.context.storeLocalInteger(ForClause.this.posDecl.address, this.curPos);
                    }
                    return true;
                }
                if (!this.source.next()) {
                    return false;
                }
                this.current = ForClause.this.expr.eval(this.focus, this.context);
                this.curPos = 0;
            }
        }

        public Value bornAgain() {
            Sequence sequence = new Sequence(this.focus, this.context);
            sequence.setSource(this.source.bornAgain());
            return sequence;
        }
    }
}

