/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.time.DateTimeBase;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.SingleDecimal;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.NumericOp;

public class MinusOp
extends NumericOp {
    static Prototype[] protos = new Prototype[]{Prototype.op("-", Type.DOUBLE.opt, class$net$xfra$qizxopen$xquery$op$MinusOp$ExecD == null ? (class$net$xfra$qizxopen$xquery$op$MinusOp$ExecD = MinusOp.class$("net.xfra.qizxopen.xquery.op.MinusOp$ExecD")) : class$net$xfra$qizxopen$xquery$op$MinusOp$ExecD).hidden().arg("op1", (Type)Type.DOUBLE.opt).arg("op2", (Type)Type.UNTYPED_ATOMIC.opt), Prototype.op("-", Type.DOUBLE.opt, class$net$xfra$qizxopen$xquery$op$MinusOp$ExecD == null ? (class$net$xfra$qizxopen$xquery$op$MinusOp$ExecD = MinusOp.class$("net.xfra.qizxopen.xquery.op.MinusOp$ExecD")) : class$net$xfra$qizxopen$xquery$op$MinusOp$ExecD).hidden().arg("op1", (Type)Type.UNTYPED_ATOMIC.opt).arg("op2", (Type)Type.DOUBLE.opt), Prototype.op("-", Type.INTEGER.opt, class$net$xfra$qizxopen$xquery$op$MinusOp$ExecI == null ? (class$net$xfra$qizxopen$xquery$op$MinusOp$ExecI = MinusOp.class$("net.xfra.qizxopen.xquery.op.MinusOp$ExecI")) : class$net$xfra$qizxopen$xquery$op$MinusOp$ExecI).arg("op1", (Type)Type.INTEGER.opt).arg("op2", (Type)Type.INTEGER.opt), Prototype.op("-", Type.DECIMAL.opt, class$net$xfra$qizxopen$xquery$op$MinusOp$ExecDec == null ? (class$net$xfra$qizxopen$xquery$op$MinusOp$ExecDec = MinusOp.class$("net.xfra.qizxopen.xquery.op.MinusOp$ExecDec")) : class$net$xfra$qizxopen$xquery$op$MinusOp$ExecDec).arg("op1", (Type)Type.DECIMAL.opt).arg("op2", (Type)Type.DECIMAL.opt), Prototype.op("-", Type.FLOAT.opt, class$net$xfra$qizxopen$xquery$op$MinusOp$ExecF == null ? (class$net$xfra$qizxopen$xquery$op$MinusOp$ExecF = MinusOp.class$("net.xfra.qizxopen.xquery.op.MinusOp$ExecF")) : class$net$xfra$qizxopen$xquery$op$MinusOp$ExecF).arg("op1", (Type)Type.FLOAT.opt).arg("op2", (Type)Type.FLOAT.opt), Prototype.op("-", Type.DOUBLE.opt, class$net$xfra$qizxopen$xquery$op$MinusOp$ExecD == null ? (class$net$xfra$qizxopen$xquery$op$MinusOp$ExecD = MinusOp.class$("net.xfra.qizxopen.xquery.op.MinusOp$ExecD")) : class$net$xfra$qizxopen$xquery$op$MinusOp$ExecD).arg("op1", (Type)Type.DOUBLE.opt).arg("op2", (Type)Type.DOUBLE.opt), Prototype.op("-", Type.DOUBLE, class$net$xfra$qizxopen$xquery$op$MinusOp$ExecTime == null ? (class$net$xfra$qizxopen$xquery$op$MinusOp$ExecTime = MinusOp.class$("net.xfra.qizxopen.xquery.op.MinusOp$ExecTime")) : class$net$xfra$qizxopen$xquery$op$MinusOp$ExecTime).arg("d1", (Type)Type.DATE_TIME).arg("d2", (Type)Type.DATE_TIME), Prototype.op("-", Type.DOUBLE, class$net$xfra$qizxopen$xquery$op$MinusOp$ExecTime == null ? (class$net$xfra$qizxopen$xquery$op$MinusOp$ExecTime = MinusOp.class$("net.xfra.qizxopen.xquery.op.MinusOp$ExecTime")) : class$net$xfra$qizxopen$xquery$op$MinusOp$ExecTime).arg("t1", (Type)Type.TIME).arg("t2", (Type)Type.TIME), Prototype.op("-", Type.INTEGER, class$net$xfra$qizxopen$xquery$op$MinusOp$ExecDate == null ? (class$net$xfra$qizxopen$xquery$op$MinusOp$ExecDate = MinusOp.class$("net.xfra.qizxopen.xquery.op.MinusOp$ExecDate")) : class$net$xfra$qizxopen$xquery$op$MinusOp$ExecDate).arg("d1", (Type)Type.DATE).arg("d2", (Type)Type.DATE)};
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$MinusOp$ExecD;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$MinusOp$ExecI;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$MinusOp$ExecDec;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$MinusOp$ExecF;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$MinusOp$ExecTime;
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$op$MinusOp$ExecDate;

    public MinusOp(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Prototype[] getProtos() {
        return protos;
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "Op -");
        exprDump.display("expr1", this.operands[0]);
        exprDump.display("expr2", this.operands[1]);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ExecDate
    extends Function.IntegerCall {
        public long evalAsInteger(Focus focus, EvalContext evalContext) throws XQueryException {
            Item item = this.args[0].evalAsItem(focus, evalContext);
            Item item2 = this.args[1].evalAsItem(focus, evalContext);
            evalContext.at(this);
            DateTimeBase dateTimeBase = ((MomentValue)item).getValue();
            DateTimeBase dateTimeBase2 = ((MomentValue)item2).getValue();
            return (int)((dateTimeBase.getSecondsFromEpoch() - dateTimeBase2.getSecondsFromEpoch()) / 86400.0);
        }
    }

    public static class ExecTime
    extends Function.DoubleCall {
        public double evalAsDouble(Focus focus, EvalContext evalContext) throws XQueryException {
            Item item = this.args[0].evalAsItem(focus, evalContext);
            Item item2 = this.args[1].evalAsItem(focus, evalContext);
            evalContext.at(this);
            DateTimeBase dateTimeBase = ((MomentValue)item).getValue();
            DateTimeBase dateTimeBase2 = ((MomentValue)item2).getValue();
            return dateTimeBase.getSecondsFromEpoch() - dateTimeBase2.getSecondsFromEpoch();
        }
    }

    public static class ExecDec
    extends Function.Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            Value value = this.args[0].eval(focus, evalContext);
            Value value2 = this.args[1].eval(focus, evalContext);
            if (!value.next() || !value2.next()) {
                return Value.empty;
            }
            evalContext.at(this);
            return new SingleDecimal(value.asDecimal().subtract(value2.asDecimal()));
        }
    }

    public static class ExecD
    extends Function.OptDoubleCall {
        public double evalAsOptDouble(Focus focus, EvalContext evalContext) throws XQueryException {
            double d = this.args[0].evalAsOptDouble(focus, evalContext);
            double d2 = this.args[1].evalAsOptDouble(focus, evalContext);
            evalContext.at(this);
            return d - d2;
        }
    }

    public static class ExecF
    extends Function.OptFloatCall {
        public float evalAsOptFloat(Focus focus, EvalContext evalContext) throws XQueryException {
            float f = this.args[0].evalAsOptFloat(focus, evalContext);
            float f2 = this.args[1].evalAsOptFloat(focus, evalContext);
            evalContext.at(this);
            return f - f2;
        }
    }

    public static class ExecI
    extends Function.OptIntegerCall {
        public long evalAsOptInteger(Focus focus, EvalContext evalContext) throws XQueryException {
            long l = this.args[0].evalAsInteger(focus, evalContext);
            long l2 = this.args[1].evalAsInteger(focus, evalContext);
            evalContext.at(this);
            if (!Conversion.isIntegerRange((double)l - (double)l2)) {
                evalContext.error((Expression)this, "integer overflow");
            }
            return l - l2;
        }
    }
}

