/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.op.BooleanExpression;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.LocalVariable;
import net.xfra.qizxopen.xquery.op.VarClause;

public class QuantifiedExpr
extends BooleanExpression {
    public boolean every;
    Expression[] varClauses = new Expression[0];
    public Expression cond;

    public QuantifiedExpr(boolean bl) {
        this.every = bl;
    }

    public void addVarClause(Expression expression) {
        this.varClauses = Expression.addExpr(this.varClauses, expression);
    }

    Expression getVarClause(int n) {
        return n < 0 || n >= this.varClauses.length ? null : this.varClauses[n];
    }

    public Expression child(int n) {
        return n < this.varClauses.length ? this.varClauses[n] : (n == this.varClauses.length ? this.cond : null);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "QuantifiedExpr");
        exprDump.display("every", "" + this.every);
        exprDump.display("varClauses", this.varClauses);
        exprDump.display("cond", this.cond);
    }

    public Expression staticCheck(StaticContext staticContext) {
        LocalVariable localVariable = staticContext.markLocalVariables();
        int n = 0;
        while (n < this.varClauses.length) {
            staticContext.staticCheck(this.getVarClause(n), 0);
            ++n;
        }
        this.cond = staticContext.staticCheck(this.cond, 0);
        this.type = Type.BOOLEAN;
        staticContext.popLocalVariables(localVariable);
        return this;
    }

    public boolean evalAsBoolean(Focus focus, EvalContext evalContext) throws XQueryException {
        VarClause.Sequence sequence = new VarClause.Sequence(focus, evalContext);
        int n = 0;
        while (n < this.varClauses.length) {
            VarClause.Sequence sequence2 = (VarClause.Sequence)this.getVarClause(n).eval(focus, evalContext);
            sequence2.setSource(sequence);
            sequence = sequence2;
            ++n;
        }
        if (this.every) {
            do {
                if (sequence.next()) continue;
                return true;
            } while (this.cond.evalEffectiveBooleanValue(focus, evalContext));
            return false;
        }
        do {
            if (sequence.next()) continue;
            return false;
        } while (!this.cond.evalEffectiveBooleanValue(focus, evalContext));
        return true;
    }
}

