/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLEventReceiver;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.GenericValue;
import net.xfra.qizxopen.xquery.op.Expression;

public class SequenceExpr
extends Expression {
    Expression[] exprs = new Expression[0];

    public void addExpr(Expression expression) {
        this.exprs = Expression.addExpr(this.exprs, expression);
    }

    Expression getExpr(int n) {
        return n < 0 || n >= this.exprs.length ? null : this.exprs[n];
    }

    public Expression child(int n) {
        return n < this.exprs.length ? this.exprs[n] : null;
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "SequenceExpr");
        exprDump.display("exprs", this.exprs);
    }

    public Expression staticCheck(StaticContext staticContext) {
        this.type = this.exprs.length == 0 ? Type.NONE.opt : null;
        int n = 0;
        int n2 = this.exprs.length;
        while (n < n2) {
            this.exprs[n] = staticContext.staticCheck(this.exprs[n], 0);
            this.type = this.type == null ? this.exprs[n].getType() : this.type.unionWith(this.exprs[n].getType());
            if (this.type == null) {
                staticContext.getLog().error(this.exprs[n].module, this.exprs[n].location, "no union type", "");
            }
            ++n;
        }
        if (this.exprs.length > 1) {
            this.type = this.type.getItemType().star;
        }
        return this;
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        return new Sequence(focus, evalContext);
    }

    public void evalAsEvents(XMLEventReceiver xMLEventReceiver, Focus focus, EvalContext evalContext) throws XQueryException, DataModelException {
        evalContext.at(this);
        int n = 0;
        int n2 = this.exprs.length;
        while (n < n2) {
            this.exprs[n].evalAsEvents(xMLEventReceiver, focus, evalContext);
            ++n;
        }
    }

    public class Sequence
    extends GenericValue {
        Focus focus;
        EvalContext context;
        Value curComp;
        int index;

        Sequence(Focus focus, EvalContext evalContext) {
            this.focus = focus;
            this.context = evalContext;
            this.curComp = Value.empty;
            this.index = -1;
        }

        public boolean next() throws XQueryException {
            while (true) {
                if (this.curComp.next()) {
                    this.item = this.curComp.asItem();
                    return true;
                }
                if (++this.index >= SequenceExpr.this.exprs.length) {
                    return false;
                }
                this.curComp = SequenceExpr.this.getExpr(this.index).eval(this.focus, this.context);
            }
        }

        public boolean nextCollection() throws XQueryException {
            while (true) {
                if (this.curComp.nextCollection()) {
                    this.item = this.curComp.asItem();
                    return true;
                }
                if (++this.index >= SequenceExpr.this.exprs.length) {
                    return false;
                }
                this.curComp = SequenceExpr.this.getExpr(this.index).eval(this.focus, this.context);
            }
        }

        public Value bornAgain() {
            return new Sequence(this.focus, this.context);
        }
    }
}

