/*
 * Decompiled with CFR 0.152.
 */
package com.sun.resolver.apps;

import java.net.MalformedURLException;
import java.net.URL;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class XParseError
implements ErrorHandler {
    private boolean showErrors = true;
    private boolean showWarnings = false;
    private int maxMessages = 10;
    private int fatalCount = 0;
    private int errorCount = 0;
    private int warningCount = 0;
    private String baseURI = "";

    public XParseError(boolean errors, boolean warnings) {
        this.showErrors = errors;
        this.showWarnings = warnings;
        String dir = System.getProperty("user.dir");
        String file = "";
        file = dir.endsWith("/") ? "file:" + dir + "file" : "file:" + dir + "/" + file;
        try {
            URL url = new URL(file);
            this.baseURI = url.toString();
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getFatalCount() {
        return this.fatalCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getMaxMessages() {
        return this.maxMessages;
    }

    public void setMaxMessages(int max) {
        this.maxMessages = max;
    }

    public void error(SAXParseException exception) {
        if (this.showErrors) {
            if (this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Error", exception);
            }
            ++this.errorCount;
        }
    }

    public void fatalError(SAXParseException exception) {
        if (this.showErrors) {
            if (this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Fatal error", exception);
            }
            ++this.errorCount;
            ++this.fatalCount;
        }
    }

    public void warning(SAXParseException exception) {
        if (this.showWarnings) {
            if (this.errorCount + this.warningCount < this.maxMessages) {
                this.message("Warning", exception);
            }
            ++this.warningCount;
        }
    }

    private void message(String type, SAXParseException exception) {
        String filename = exception.getSystemId();
        if (filename.startsWith(this.baseURI)) {
            filename = filename.substring(this.baseURI.length());
        }
        System.out.print(type + ":" + filename + ":" + exception.getLineNumber());
        if (exception.getColumnNumber() > 0) {
            System.out.print(":" + exception.getColumnNumber());
        }
        System.out.println(":" + exception.getMessage());
    }
}

