/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connector;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.connector.TaminoDataSource;
import com.softwareag.tamino.db.api.connector.spi.AbstractConnectionFactory;
import com.softwareag.tamino.db.api.connector.spi.TaminoConnectionManager;
import com.softwareag.tamino.db.api.connector.spi.TaminoConnectionRequestInfo;
import java.io.Serializable;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;

public class TaminoDataSourceImpl
implements TaminoDataSource,
Serializable,
Referenceable {
    private AbstractConnectionFactory cf;
    private ConnectionManager cm;
    private Reference reference;
    private static final String LOG_NAME = "com.softwareag.tamino.db.api.connector.TaminoDataSourceImpl";
    private static Logger logger = LoggerFactory.getLogger((String)"com.softwareag.tamino.db.api.connector.TaminoDataSourceImpl");

    public TaminoDataSourceImpl() {
        this.trace("in TaminoDataSourceImpl default constructor");
    }

    public TaminoDataSourceImpl(AbstractConnectionFactory abstractConnectionFactory, ConnectionManager connectionManager) {
        this.trace("in TaminoDataSourceImpl(AbstractConnectionFactory cf, ConnectionManager cm)");
        this.cf = abstractConnectionFactory;
        if (connectionManager == null) {
            this.trace("with connection manager, i.e. non-managed connection");
            this.cm = new TaminoConnectionManager();
        } else {
            this.trace("with connection manager, i.e. managed connection");
            this.cm = connectionManager;
        }
    }

    public TConnection getConnection() throws TServerNotAvailableException {
        this.trace("in getConnection()");
        TConnection tConnection = this.getConnectionHandle(this.cf.getUserName(), this.cf.getPassword());
        return tConnection;
    }

    public TConnection getConnection(String string, String string2) throws TServerNotAvailableException {
        this.trace("in getConnection(userName, password)");
        TConnection tConnection = this.getConnectionHandle(string, string2);
        return tConnection;
    }

    private TConnection getConnectionHandle(String string, String string2) throws TServerNotAvailableException {
        this.trace("in getConnection( userName, password)");
        this.trace("userName   :" + string);
        this.trace("password : ***");
        TaminoConnectionRequestInfo taminoConnectionRequestInfo = new TaminoConnectionRequestInfo(string, string2);
        try {
            TConnection tConnection = (TConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.cf, (ConnectionRequestInfo)taminoConnectionRequestInfo);
            return tConnection;
        }
        catch (ResourceException resourceException) {
            throw new TServerNotAvailableException("allocateConnection() failed: " + resourceException.getMessage());
        }
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    private void trace(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(Integer.toHexString(this.hashCode()) + ": " + string);
        }
    }
}

