/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connector.spi;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAdministrationAccessor;
import com.softwareag.tamino.db.api.accessor.TInvalidatableAccessor;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition2Accessor;
import com.softwareag.tamino.db.api.accessor.TSchemaDefinition3Accessor;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TSystemAccessor;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionCloseException;
import com.softwareag.tamino.db.api.connection.TGlobalTransaction;
import com.softwareag.tamino.db.api.connection.TGlobalTransactionSpecifier;
import com.softwareag.tamino.db.api.connection.TIsolationDegree;
import com.softwareag.tamino.db.api.connection.TIsolationLevel;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TTransaction;
import com.softwareag.tamino.db.api.connection.TTransactionModeChangeException;
import com.softwareag.tamino.db.api.connector.spi.TaminoManagedConnection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.resource.ResourceException;

public class TConnectionWrapper
implements TConnection {
    private static final String LOG_NAME = "com.softwareag.tamino.db.api.connector.TConnectionWrapper";
    private static Logger logger = LoggerFactory.getLogger((String)"com.softwareag.tamino.db.api.connector.TConnectionWrapper");
    private TaminoManagedConnection mc;
    private ArrayList invalidatableAccessors = null;
    private boolean closed = false;
    private boolean invalid = false;
    private static final boolean PRE_CHECK = Precondition.isEnabled((Class)(class$com$softwareag$tamino$db$api$connector$spi$TConnectionWrapper == null ? (class$com$softwareag$tamino$db$api$connector$spi$TConnectionWrapper = TConnectionWrapper.class$("com.softwareag.tamino.db.api.connector.spi.TConnectionWrapper")) : class$com$softwareag$tamino$db$api$connector$spi$TConnectionWrapper));
    private static final boolean POST_CHECK = Postcondition.isEnabled((Class)(class$com$softwareag$tamino$db$api$connector$spi$TConnectionWrapper == null ? (class$com$softwareag$tamino$db$api$connector$spi$TConnectionWrapper = TConnectionWrapper.class$("com.softwareag.tamino.db.api.connector.spi.TConnectionWrapper")) : class$com$softwareag$tamino$db$api$connector$spi$TConnectionWrapper));
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$connector$spi$TConnectionWrapper;

    public TConnectionWrapper(TaminoManagedConnection taminoManagedConnection) {
        this.mc = taminoManagedConnection;
        this.invalidatableAccessors = new ArrayList();
    }

    public TNonXMLObjectAccessor newNonXMLObjectAccessor(TAccessLocation tAccessLocation) {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)"Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        TNonXMLObjectAccessor tNonXMLObjectAccessor = this.mc.getTCon().newNonXMLObjectAccessor(tAccessLocation);
        this.invalidatableAccessors.add((TInvalidatableAccessor)tNonXMLObjectAccessor);
        return tNonXMLObjectAccessor;
    }

    public TXMLObjectAccessor newXMLObjectAccessor(TAccessLocation tAccessLocation, Object object) {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        TXMLObjectAccessor tXMLObjectAccessor = this.mc.getTCon().newXMLObjectAccessor(tAccessLocation, object);
        this.trace("accessor object is: " + tXMLObjectAccessor.toString());
        this.trace("accessor object is: " + tXMLObjectAccessor);
        this.trace("accessor object is: " + this.hashCode());
        this.invalidatableAccessors.add((TInvalidatableAccessor)tXMLObjectAccessor);
        return tXMLObjectAccessor;
    }

    public TStreamAccessor newStreamAccessor(TAccessLocation tAccessLocation) {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        TStreamAccessor tStreamAccessor = this.mc.getTCon().newStreamAccessor(tAccessLocation);
        this.invalidatableAccessors.add((TInvalidatableAccessor)tStreamAccessor);
        return tStreamAccessor;
    }

    public TSchemaDefinition2Accessor newSchemaDefinition2Accessor(Object object) {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        TSchemaDefinition2Accessor tSchemaDefinition2Accessor = this.mc.getTCon().newSchemaDefinition2Accessor(object);
        this.invalidatableAccessors.add((TInvalidatableAccessor)tSchemaDefinition2Accessor);
        return tSchemaDefinition2Accessor;
    }

    public TSchemaDefinition3Accessor newSchemaDefinition3Accessor(Object object) {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        TSchemaDefinition3Accessor tSchemaDefinition3Accessor = this.mc.getTCon().newSchemaDefinition3Accessor(object);
        this.invalidatableAccessors.add((TInvalidatableAccessor)tSchemaDefinition3Accessor);
        return tSchemaDefinition3Accessor;
    }

    public TSystemAccessor newSystemAccessor() {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        TSystemAccessor tSystemAccessor = this.mc.getTCon().newSystemAccessor();
        this.invalidatableAccessors.add((TInvalidatableAccessor)tSystemAccessor);
        return tSystemAccessor;
    }

    public TAdministrationAccessor newAdministrationAccessor() {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        TAdministrationAccessor tAdministrationAccessor = this.mc.getTCon().newAdministrationAccessor();
        this.invalidatableAccessors.add((TInvalidatableAccessor)tAdministrationAccessor);
        return tAdministrationAccessor;
    }

    public void useAutoCommitMode() throws TTransactionModeChangeException {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        if (!this.mc.isNonManaged() && !this.mc.supportsNonTx()) {
            this.trace("in localTx and XA it's not allowed to switch to autocommit mode");
            throw new TTransactionModeChangeException("no autocommit allowed in managed environment");
        }
        this.trace("type NoTransaction in managed environment or non-managed, so switch to autocommit mode");
        this.mc.getTCon().useAutoCommitMode();
    }

    public boolean usesAutoCommitMode() {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        return this.mc.getTCon().usesAutoCommitMode();
    }

    public TLocalTransaction useLocalTransactionMode() throws TTransactionModeChangeException {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)"Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        this.trace("supportsLocalTx = " + this.mc.supportsLocalTx());
        this.trace("supportsXA      = " + this.mc.supportsXA());
        this.trace("supportsNonTx   = " + this.mc.supportsNonTx());
        if (this.mc.isNonManaged()) {
            this.trace("non-managed environment");
            return this.mc.getTCon().useLocalTransactionMode();
        }
        this.trace("it's not allowed to switch to another transaction mode");
        throw new TTransactionModeChangeException("no mode change allowed in managed environment");
    }

    public boolean usesLocalTransactionMode() {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        return this.mc.getTCon().usesLocalTransactionMode();
    }

    public void reset() throws TTransactionModeChangeException {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        if (this.mc.isNonManaged()) {
            this.mc.getTCon().reset();
        } else {
            this.setIsolationDegree(null);
            this.setIsolationLevel(null);
            this.setLockMode(null);
            this.setLockwaitMode(null);
        }
    }

    public void setIsolationLevel(TIsolationLevel tIsolationLevel) {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        this.mc.getTCon().setIsolationLevel(tIsolationLevel);
    }

    public void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        this.mc.getTCon().setLockwaitMode(tLockwaitMode);
    }

    public TIsolationLevel getIsolationLevel() {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        return this.mc.getTCon().getIsolationLevel();
    }

    public TLockwaitMode getLockwaitMode() {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        return this.mc.getTCon().getLockwaitMode();
    }

    public void setIsolationDegree(TIsolationDegree tIsolationDegree) {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        this.mc.getTCon().setIsolationDegree(tIsolationDegree);
    }

    public TIsolationDegree getIsolationDegree() {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        return this.mc.getTCon().getIsolationDegree();
    }

    public void setLockMode(TLockMode tLockMode) {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        this.mc.getTCon().setLockMode(tLockMode);
    }

    public TLockMode getLockMode() {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)" Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        return this.mc.getTCon().getLockMode();
    }

    public TGlobalTransaction useGlobalTransactionMode(TGlobalTransactionSpecifier tGlobalTransactionSpecifier) throws TTransactionModeChangeException {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)"Pooled Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        return null;
    }

    public boolean usesGlobalTransactionMode() {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)"Pooled Connection already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        return false;
    }

    public void close() throws TConnectionCloseException {
        this.trace("in close()");
        if (this.isClosed()) {
            this.trace("already closed");
            return;
        }
        this.closed = true;
        this.trace("invalidate accessors");
        Iterator iterator = ((AbstractList)this.invalidatableAccessors).iterator();
        while (iterator.hasNext()) {
            this.trace("iterate through,");
            TInvalidatableAccessor tInvalidatableAccessor = (TInvalidatableAccessor)iterator.next();
            tInvalidatableAccessor.invalidate();
        }
        this.trace("and clear the List");
        this.invalidatableAccessors.clear();
        if (this.mc != null) {
            if (this.mc.isNonManaged()) {
                this.trace("issue real close in case non-Managed");
                this.mc.getTCon().close();
            }
            this.trace("notify event listener from close");
            this.mc.sendEventClose(this);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public TTransaction getTransaction() {
        Precondition.check((!this.isClosed() ? 1 : 0) != 0, (String)"Connection is already closed!");
        Precondition.check((!this.isInvalid() ? 1 : 0) != 0, (String)"Connection handle is invalid!");
        if (this.mc.isNonManaged()) {
            return this.mc.getTCon().getTransaction();
        }
        if (this.mc.supportsLocalTx()) {
            return null;
        }
        return null;
    }

    protected void invalidate() {
        this.trace("invalidate connection handle");
        this.invalid = true;
        this.trace("invalidate managed connection reference: " + this.mc.toString());
        this.mc = null;
    }

    protected void associateConnection(TaminoManagedConnection taminoManagedConnection) throws ResourceException {
        this.trace("in associateConnection");
        this.checkIfValid();
        this.trace("old managed connection: " + this.mc.toString());
        this.trace("new managed connection: " + taminoManagedConnection.toString());
        this.mc.removeTConnection(this);
        taminoManagedConnection.addTConnection(this);
        this.mc = taminoManagedConnection;
        this.trace("associateConnection done");
    }

    protected TaminoManagedConnection getMc() {
        return this.mc;
    }

    private void checkIfValid() throws ResourceException {
        this.trace("checkIfValid");
        if (this.mc == null) {
            this.trace("managed connection is null, so throw exception");
            throw new ResourceException("reference from connection to managed connection is null");
        }
        this.trace("checkIfValid done");
    }

    private boolean isInvalid() {
        return this.invalid;
    }

    private void trace(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(Integer.toHexString(this.hashCode()) + ": " + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

