/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connector.spi;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.tamino.db.api.connection.TConnectionMessages;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TTransaction;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connector.spi.TConnectionWrapper;
import com.softwareag.tamino.db.api.connector.spi.TaminoManagedConnection;

public class TLocalTransactionWrapper
implements TLocalTransaction {
    private static final String LOG_NAME = "com.softwareag.tamino.db.api.connector.TLocalTransactionWrapper";
    private static Logger logger = LoggerFactory.getLogger((String)"com.softwareag.tamino.db.api.connector.TLocalTransactionWrapper");
    private TConnectionWrapper connectionWrapper;

    public TLocalTransactionWrapper(TConnectionWrapper tConnectionWrapper) {
        this.connectionWrapper = tConnectionWrapper;
    }

    public void commit() throws TTransactionException {
        TLocalTransaction tLocalTransaction = this.getTaminoLocalTransaction();
        try {
            tLocalTransaction.commit();
            this.connectionWrapper.getMc().sendEventCommit();
        }
        catch (TTransactionException tTransactionException) {
            this.connectionWrapper.getMc().sendEventRollback();
            throw tTransactionException;
        }
    }

    public void rollback() throws TTransactionException {
        TLocalTransaction tLocalTransaction = this.getTaminoLocalTransaction();
        try {
            tLocalTransaction.rollback();
            this.connectionWrapper.getMc().sendEventRollback();
        }
        catch (TTransactionException tTransactionException) {
            this.connectionWrapper.getMc().sendEventRollback();
            throw tTransactionException;
        }
    }

    private TLocalTransaction getTaminoLocalTransaction() throws TTransactionException {
        TaminoManagedConnection taminoManagedConnection = this.connectionWrapper.getMc();
        if (taminoManagedConnection == null) {
            throw new TTransactionException(TConnectionMessages.TAJCNE0215);
        }
        TTransaction tTransaction = taminoManagedConnection.getTCon().getTransaction();
        if (tTransaction == null) {
            throw new TTransactionException(TConnectionMessages.TAJCNE0215);
        }
        if (!(tTransaction instanceof TLocalTransaction)) {
            throw new TTransactionException(TConnectionMessages.TAJCNE0215);
        }
        return (TLocalTransaction)tTransaction;
    }

    private void trace(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(Integer.toHexString(this.hashCode()) + ": " + string);
        }
    }
}

