/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connector.spi;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TLocalTransaction;
import com.softwareag.tamino.db.api.connection.TTransactionException;
import com.softwareag.tamino.db.api.connector.spi.TaminoManagedConnection;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;

public class TaminoLocalTransaction
implements LocalTransaction {
    private TConnection connection = null;
    private TaminoManagedConnection mc = null;
    private TLocalTransaction transaction = null;
    private static final String LOG_NAME = "com.softwareag.tamino.db.api.connector.spi.TaminoLocalTransaction";
    private static Logger logger = LoggerFactory.getLogger((String)"com.softwareag.tamino.db.api.connector.spi.TaminoLocalTransaction");
    private String lastCommand = "";

    public TaminoLocalTransaction(TConnection tConnection) throws ResourceException {
        this.trace("constructor TaminoLocalTransaction()");
        this.connection = tConnection;
    }

    public void setTMC(TaminoManagedConnection taminoManagedConnection) {
        this.trace("setTMC()");
        this.mc = taminoManagedConnection;
    }

    public void begin() throws ResourceException {
        this.trace("begin()");
        if (logger.isLoggable(Level.FINE)) {
            this.traceTxStatus("Begin");
        }
        this.setLocalTransaction(true);
        this.trace("don't inform event listener about begin");
        this.lastCommand = "Begin";
        this.trace("begin() done");
    }

    public void commit() throws ResourceException {
        this.trace("in commit()");
        if (logger.isLoggable(Level.FINE)) {
            this.traceTxStatus("Commit");
        }
        this.checkIfValid();
        try {
            this.trace("now call tamino commit");
            this.transaction.commit();
            this.trace("don't inform event listener about commit");
            this.setLocalTransaction(false);
        }
        catch (TTransactionException tTransactionException) {
            this.trace("caught TTransactionException");
            tTransactionException.printStackTrace();
            throw new ResourceException("TaminoAPI commit error: " + tTransactionException.getMessage());
        }
        this.lastCommand = "Commit";
        this.trace("commit() done");
    }

    public void rollback() throws ResourceException {
        this.trace("in rollback()");
        if (logger.isLoggable(Level.FINE)) {
            this.traceTxStatus("Rollback");
        }
        this.checkIfValid();
        try {
            this.trace("now call tamino rollback");
            this.transaction.rollback();
            this.trace("don't inform event listener about rollback");
            this.setLocalTransaction(false);
        }
        catch (TTransactionException tTransactionException) {
            this.trace("caught TTransactionException");
            tTransactionException.printStackTrace();
            throw new ResourceException("API rollback error: " + tTransactionException.getMessage());
        }
        this.lastCommand = "Rollback";
        this.trace("rollback() done");
    }

    private void setLocalTransaction(boolean bl) throws ResourceException {
        this.trace(" setLocalTransaction( " + bl + " )");
        if (this.connection != null) {
            if (bl) {
                if (!this.connection.usesLocalTransactionMode()) {
                    this.trace(" transaction mode is autocommit");
                    try {
                        this.trace(" set transaction mode to localtransaction");
                        this.transaction = this.connection.useLocalTransactionMode();
                    }
                    catch (TTransactionException tTransactionException) {
                        this.trace(" caught TTransactionException when setting useLocalTransactionMode: " + tTransactionException.getMessage() + " XML message is: " + tTransactionException.toXMLString());
                        tTransactionException.printStackTrace();
                        throw new ResourceException("set transaction mode error: " + tTransactionException.getMessage() + " XML message is: " + tTransactionException.toXMLString());
                    }
                } else {
                    this.trace(" transaction mode is already localtransaction");
                    this.trace(" transaction mode is localtransaction, so do nothing");
                    this.transaction = (TLocalTransaction)this.connection.getTransaction();
                }
            } else {
                this.trace("clear reference ");
                this.transaction = null;
            }
        } else {
            this.trace(" connection is null, so throw exception ");
            throw new ResourceException("   no connection object to set transaction to");
        }
    }

    private void checkIfValid() throws ResourceException {
        this.trace("checkIfValid");
        if (this.transaction == null) {
            this.trace("transaction object is null, so throw exception");
            throw new ResourceException("no transaction object");
        }
        this.trace("checkIfValid done");
    }

    private void traceTxStatus(String string) {
        if (this.lastCommand == "Begin") {
            this.trace(string + " after Begin !!!");
        }
        if (this.lastCommand == "Commit") {
            this.trace(string + " after Commit !!!");
        }
        if (this.lastCommand == "Rollback") {
            this.trace(string + " after Rollback !!!");
        }
    }

    private void trace(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(Integer.toHexString(this.hashCode()) + ": " + string);
        }
    }
}

