/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.connector.spi;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.tamino.db.api.connection.TConnection;
import com.softwareag.tamino.db.api.connection.TConnectionCloseException;
import com.softwareag.tamino.db.api.connection.TConnectionFactory;
import com.softwareag.tamino.db.api.connection.TServerNotAvailableException;
import com.softwareag.tamino.db.api.connector.cci.ConnectionImpl;
import com.softwareag.tamino.db.api.connector.spi.AbstractConnectionFactory;
import com.softwareag.tamino.db.api.connector.spi.TConnectionWrapper;
import com.softwareag.tamino.db.api.connector.spi.TaminoConnectionRequestInfo;
import com.softwareag.tamino.db.api.connector.spi.TaminoLocalTransaction;
import com.softwareag.tamino.db.api.connector.spi.TaminoMetaData;
import com.softwareag.tamino.db.api.connector.xa.XAResourceImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.SecurityException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;

public class TaminoManagedConnection
implements ManagedConnection {
    private Connection connection = null;
    private TConnection tConnection = null;
    private ManagedConnectionFactory mcf = null;
    private ConnectionRequestInfo cxRequestInfo = null;
    private TaminoLocalTransaction localTx = null;
    private boolean getLocalTransactionCalled = false;
    private XAResource xaResource;
    private boolean getXAResourceCalled = false;
    private boolean thisSupportsCCI = false;
    private boolean thisSupportsXA = false;
    private boolean thisSupportsLocalTx = false;
    private boolean thisSupportsNonTx = false;
    private boolean thisNonManaged = false;
    private String userName = null;
    private String password = null;
    private boolean destroyed = false;
    private Vector thisConnectionEventListeners;
    private Set connectionSet;
    private static final String LOG_NAME = "com.softwareag.tamino.db.api.connector.spi.TaminoManagedConnection";
    private static Logger logger = LoggerFactory.getLogger((String)"com.softwareag.tamino.db.api.connector.spi.TaminoManagedConnection");
    private PrintWriter logWriter = null;

    public TaminoManagedConnection(AbstractConnectionFactory abstractConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        this.trace("new TaminoManagedConnection()");
        this.mcf = abstractConnectionFactory;
        this.cxRequestInfo = connectionRequestInfo;
        this.setSupportsCCI(abstractConnectionFactory.supportsCCI());
        this.setSupportsXA(abstractConnectionFactory.supportsXA());
        this.setSupportsLocalTx(abstractConnectionFactory.supportsLocalTx());
        this.setNonManaged(abstractConnectionFactory.isNonManaged());
        this.trace("  supports CCI: " + this.supportsCCI());
        this.trace("  supports XA: " + this.supportsXA());
        this.trace("  supports LocalTX: " + this.supportsLocalTx());
        this.tConnection = null;
        this.connection = null;
        this.destroyed = false;
        try {
            String string = abstractConnectionFactory.getTaminoURL();
            if (string == null || string == "") {
                this.trace("missing Tamino URL, we cannot make any connection");
                throw new ResourceException("Missing Tamino URL; a Tamino URL must be specified for the Tamino Resource Adapter.");
            }
            this.setUserName(((TaminoConnectionRequestInfo)connectionRequestInfo).getUserName());
            this.setPassword(((TaminoConnectionRequestInfo)connectionRequestInfo).getPassword());
            this.trace("get new physical Connection(" + string + ", " + this.getUserName() + ",***)");
            TConnectionFactory tConnectionFactory = TConnectionFactory.getInstance();
            this.tConnection = tConnectionFactory.newConnection(string, this.getUserName(), this.getPassword());
        }
        catch (TServerNotAvailableException tServerNotAvailableException) {
            this.trace("exception when instantiating tamino connection");
            tServerNotAvailableException.printStackTrace();
            this.trace("msg is: " + tServerNotAvailableException.toXMLString());
            throw new ResourceException(tServerNotAvailableException.getMessage());
        }
        if (this.supportsLocalTx()) {
            this.localTx = new TaminoLocalTransaction(this.tConnection);
            this.localTx.setTMC(this);
        }
        if (this.supportsXA()) {
            this.xaResource = new XAResourceImpl(this);
        }
        if (!this.supportsLocalTx() && !this.supportsXA()) {
            this.setSupportsNonTx(true);
        }
        this.thisConnectionEventListeners = new Vector();
        this.connectionSet = new HashSet();
    }

    private void setSupportsCCI(boolean bl) {
        this.thisSupportsCCI = bl;
    }

    private boolean supportsCCI() {
        return this.thisSupportsCCI;
    }

    public void setSupportsXA(boolean bl) {
        this.thisSupportsXA = bl;
    }

    public boolean supportsXA() {
        return this.thisSupportsXA;
    }

    public boolean isFree() {
        boolean bl = false;
        Set set = this.connectionSet;
        synchronized (set) {
            if (this.connectionSet.isEmpty()) {
                bl = true;
            }
        }
        return bl;
    }

    private void setSupportsLocalTx(boolean bl) {
        this.thisSupportsLocalTx = bl;
    }

    public boolean supportsLocalTx() {
        return this.thisSupportsLocalTx;
    }

    private void setSupportsNonTx(boolean bl) {
        this.thisSupportsNonTx = bl;
    }

    public boolean supportsNonTx() {
        return this.thisSupportsNonTx;
    }

    private void setNonManaged(boolean bl) {
        this.thisNonManaged = bl;
    }

    public boolean isNonManaged() {
        return this.thisNonManaged;
    }

    private void setUserName(String string) {
        this.userName = string;
    }

    protected String getUserName() {
        return this.userName;
    }

    private void setPassword(String string) {
        this.password = string;
    }

    protected String getPassword() {
        return this.password;
    }

    protected boolean isDestroyed() {
        return this.destroyed;
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        this.trace("getConnection(Subject, ConnnectionRequestInfo)");
        this.checkIfDestroyed();
        TaminoConnectionRequestInfo taminoConnectionRequestInfo = ((AbstractConnectionFactory)this.mcf).determineCredentials(subject, connectionRequestInfo);
        TaminoConnectionRequestInfo taminoConnectionRequestInfo2 = ((AbstractConnectionFactory)this.mcf).determineCredentials(null, this.cxRequestInfo);
        if (taminoConnectionRequestInfo.equals(taminoConnectionRequestInfo2)) {
            this.trace("call TConnectionWrapper newConnection()");
            TConnectionWrapper tConnectionWrapper = new TConnectionWrapper(this);
            this.addTConnection(tConnectionWrapper);
            if (this.supportsCCI()) {
                this.trace("we have a CCI ConnectionHandle!!!!!!!!!!");
                this.connection = new ConnectionImpl((TConnection)tConnectionWrapper);
                return this.connection;
            }
            this.trace("we have a TConnectionHandle: " + tConnectionWrapper.toString());
            return tConnectionWrapper;
        }
        this.trace("throw SecurityException, because userName and password differ to previous one");
        throw new SecurityException("reauthentication is not supported");
    }

    public void destroy() throws ResourceException {
        this.trace("destroy()");
        if (this.isDestroyed()) {
            return;
        }
        this.cleanup();
        if (this.supportsXA()) {
            ((XAResourceImpl)this.xaResource).closeUtxProxy();
        }
        this.destroyed = true;
        try {
            this.tConnection.close();
        }
        catch (TConnectionCloseException tConnectionCloseException) {
            this.trace("caught TConnectionCloseException, msg is " + tConnectionCloseException.getMessage());
            StringWriter stringWriter = new StringWriter();
            tConnectionCloseException.printStackTrace(new PrintWriter(stringWriter));
            this.trace("stacktrace: " + stringWriter.toString());
        }
    }

    public void cleanup() throws ResourceException {
        this.trace("cleanup() issued by thread: " + Thread.currentThread().getName());
        if (this.isDestroyed()) {
            return;
        }
        Set set = this.connectionSet;
        synchronized (set) {
            Iterator iterator = this.connectionSet.iterator();
            while (iterator.hasNext()) {
                this.trace("for each handle");
                TConnectionWrapper tConnectionWrapper = (TConnectionWrapper)iterator.next();
                this.trace("invalidate handle");
                tConnectionWrapper.invalidate();
            }
            this.trace("clear the set of connection handles");
            this.connectionSet.clear();
        }
    }

    public void associateConnection(Object object) throws ResourceException {
        this.trace("associateConnection()");
        this.checkIfDestroyed();
        this.trace("connectionHandle object is: " + object.toString());
        this.trace("connectionHandle hashcode  : " + object.hashCode());
        this.trace("connectionHandle thread is: " + Thread.currentThread().getName());
        if (object instanceof TConnectionWrapper) {
            this.trace("it's a TConnection object, so associate");
            TConnectionWrapper tConnectionWrapper = (TConnectionWrapper)object;
            tConnectionWrapper.associateConnection(this);
        } else if (this.connection instanceof Connection) {
            this.trace("it's a cci connection object, so associate");
            this.connection = this.connection;
        } else {
            throw new IllegalStateException("Invalid connection object: " + this.connection);
        }
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.trace("addConnectionEventListener()");
        if (!this.thisConnectionEventListeners.contains(connectionEventListener)) {
            this.trace("add to vector of listeners");
            this.thisConnectionEventListeners.add(connectionEventListener);
        }
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.trace("removeConnectionEventListener()");
        this.trace("remove from vector of listeners");
        this.thisConnectionEventListeners.remove(connectionEventListener);
    }

    public XAResource getXAResource() throws ResourceException {
        this.trace("getXAResource() called");
        if (!this.supportsXA()) {
            throw new NotSupportedException("XA transaction not supported");
        }
        this.checkIfDestroyed();
        if (this.getLocalTransactionCalled) {
            throw new ResourceException("XA resource requested, but local transaction is active.");
        }
        this.getXAResourceCalled = true;
        this.trace("return the  XAResource object ");
        return this.xaResource;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        this.trace("getLocalTransaction()");
        if (!this.supportsLocalTx()) {
            throw new NotSupportedException("Local transaction not supported");
        }
        this.checkIfDestroyed();
        if (this.getXAResourceCalled) {
            throw new ResourceException("local transaction requested, but XA resource is active.");
        }
        this.getLocalTransactionCalled = true;
        this.trace("return the  TaminoLocalTransaction() object ");
        return this.localTx;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.trace("getMetaData()");
        return new TaminoMetaData(this);
    }

    public PrintWriter getLogWriter() throws ResourceException {
        this.trace("getLogWriter()");
        return this.logWriter;
    }

    public void setLogWriter(PrintWriter printWriter) throws ResourceException {
        this.trace("setLogWriter()");
        this.logWriter = printWriter;
    }

    private void checkIfDestroyed() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("Managed connection is destroyed");
        }
    }

    public TConnection getTCon() {
        this.trace("getTCon()");
        this.checkIfDestroyed();
        return this.tConnection;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        this.trace("getManagedConnectionFactory()");
        return this.mcf;
    }

    public void removeTConnection(TConnectionWrapper tConnectionWrapper) {
        this.trace("removeTConnectionWrapper from Set");
        Set set = this.connectionSet;
        synchronized (set) {
            this.connectionSet.remove(tConnectionWrapper);
        }
    }

    public void addTConnection(TConnectionWrapper tConnectionWrapper) {
        this.trace("addTConnectionWrapper to Set");
        Set set = this.connectionSet;
        synchronized (set) {
            this.connectionSet.add(tConnectionWrapper);
        }
    }

    public void reset() {
        this.trace("reset isolation level, lockwait mode, isolation degree and lock mode");
        this.tConnection.setIsolationLevel(null);
        this.tConnection.setLockwaitMode(null);
        this.tConnection.setIsolationDegree(null);
        this.tConnection.setLockMode(null);
    }

    private void sendEvent(Vector vector, int n, Object object) {
        this.trace("sendEvent: " + this.getEventString(n));
        ConnectionEventListener connectionEventListener = null;
        Vector vector2 = vector;
        synchronized (vector2) {
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                connectionEventListener = (ConnectionEventListener)iterator.next();
                switch (n) {
                    case 2: {
                        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, n);
                        connectionEventListener.localTransactionStarted(connectionEvent);
                        break;
                    }
                    case 3: {
                        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, n);
                        connectionEventListener.localTransactionCommitted(connectionEvent);
                        break;
                    }
                    case 4: {
                        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, n);
                        connectionEventListener.localTransactionRolledback(connectionEvent);
                        break;
                    }
                    case 1: {
                        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, n);
                        connectionEvent.setConnectionHandle(object);
                        connectionEventListener.connectionClosed(connectionEvent);
                        break;
                    }
                    case 5: {
                        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, n);
                        connectionEventListener.connectionErrorOccurred(connectionEvent);
                    }
                }
            }
        }
    }

    protected void sendEventBegin() {
        this.sendEvent(this.thisConnectionEventListeners, 2, null);
    }

    protected void sendEventCommit() {
        this.sendEvent(this.thisConnectionEventListeners, 3, null);
    }

    protected void sendEventRollback() {
        this.sendEvent(this.thisConnectionEventListeners, 4, null);
    }

    private void sendEventConnectionErrorOccurred() {
        this.sendEvent(this.thisConnectionEventListeners, 5, null);
    }

    protected void sendEventClose(Object object) {
        this.trace("sendEventClose()");
        Vector vector = null;
        Vector vector2 = this.thisConnectionEventListeners;
        synchronized (vector2) {
            vector = (Vector)this.thisConnectionEventListeners.clone();
        }
        this.trace("vector cloned()");
        this.sendEvent(vector, 1, object);
    }

    private String getEventString(int n) {
        String string = "unknown event";
        switch (n) {
            case 2: {
                string = "LOCAL_TRANSACTION_STARTED";
                break;
            }
            case 3: {
                string = "LOCAL_TRANSACTION_COMMITTED";
                break;
            }
            case 4: {
                string = "LOCAL_TRANSACTION_ROLLEDBACK";
                break;
            }
            case 1: {
                string = "CONNECTION_CLOSED";
                break;
            }
            case 5: {
                string = "CONNECTION_ERROR_OCCURRED";
            }
        }
        return string;
    }

    private void trace(String string) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(Integer.toHexString(this.hashCode()) + ": " + string);
        }
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }
}

