/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.config.PropertySetter;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.AppenderAttachable;
import org.apache.log4j.spi.Configurator;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RendererSupport;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.SAXErrorHandler;
import org.apache.log4j.xml.XMLWatchdog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DOMConfigurator
implements Configurator {
    static final String CONFIGURATION_TAG = "log4j:configuration";
    static final String OLD_CONFIGURATION_TAG = "configuration";
    static final String RENDERER_TAG = "renderer";
    static final String APPENDER_TAG = "appender";
    static final String APPENDER_REF_TAG = "appender-ref";
    static final String PARAM_TAG = "param";
    static final String LAYOUT_TAG = "layout";
    static final String CATEGORY = "category";
    static final String LOGGER = "logger";
    static final String LOGGER_REF = "logger-ref";
    static final String CATEGORY_FACTORY_TAG = "categoryFactory";
    static final String NAME_ATTR = "name";
    static final String CLASS_ATTR = "class";
    static final String VALUE_ATTR = "value";
    static final String ROOT_TAG = "root";
    static final String ROOT_REF = "root-ref";
    static final String LEVEL_TAG = "level";
    static final String PRIORITY_TAG = "priority";
    static final String FILTER_TAG = "filter";
    static final String ERROR_HANDLER_TAG = "errorHandler";
    static final String REF_ATTR = "ref";
    static final String ADDITIVITY_ATTR = "additivity";
    static final String THRESHOLD_ATTR = "threshold";
    static final String CONFIG_DEBUG_ATTR = "configDebug";
    static final String INTERNAL_DEBUG_ATTR = "debug";
    static final String RENDERING_CLASS_ATTR = "renderingClass";
    static final String RENDERED_CLASS_ATTR = "renderedClass";
    static final String EMPTY_STR = "";
    static final Class[] ONE_STRING_PARAM = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DOMConfigurator.class$("java.lang.String")) : class$java$lang$String};
    static final String dbfKey = "javax.xml.parsers.DocumentBuilderFactory";
    Hashtable appenderBag = new Hashtable();
    Properties props;
    LoggerRepository repository;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$log4j$spi$ErrorHandler;
    static /* synthetic */ Class class$org$apache$log4j$spi$Filter;
    static /* synthetic */ Class class$org$apache$log4j$spi$LoggerFactory;

    protected Appender findAppenderByName(Document document, String string) {
        Appender appender = (Appender)this.appenderBag.get(string);
        if (appender != null) {
            return appender;
        }
        Element element = null;
        NodeList nodeList = document.getElementsByTagName(APPENDER_TAG);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem(NAME_ATTR);
            if (!string.equals(node2.getNodeValue())) continue;
            element = (Element)node;
            break;
        }
        if (element == null) {
            LogLog.error("No appender named [" + string + "] could be found.");
            return null;
        }
        appender = this.parseAppender(element);
        this.appenderBag.put(string, appender);
        return appender;
    }

    protected Appender findAppenderByReference(Element element) {
        String string = this.subst(element.getAttribute(REF_ATTR));
        Document document = element.getOwnerDocument();
        return this.findAppenderByName(document, string);
    }

    protected Appender parseAppender(Element element) {
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        LogLog.debug("Class name: [" + string + ']');
        try {
            Object t = Loader.loadClass(string).newInstance();
            Appender appender = (Appender)t;
            PropertySetter propertySetter = new PropertySetter(appender);
            appender.setName(this.subst(element.getAttribute(NAME_ATTR)));
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                if (element2.getTagName().equals(PARAM_TAG)) {
                    this.setParameter(element2, propertySetter);
                    continue;
                }
                if (element2.getTagName().equals(LAYOUT_TAG)) {
                    appender.setLayout(this.parseLayout(element2));
                    continue;
                }
                if (element2.getTagName().equals(FILTER_TAG)) {
                    this.parseFilters(element2, appender);
                    continue;
                }
                if (element2.getTagName().equals(ERROR_HANDLER_TAG)) {
                    this.parseErrorHandler(element2, appender);
                    continue;
                }
                if (!element2.getTagName().equals(APPENDER_REF_TAG)) continue;
                String string2 = this.subst(element2.getAttribute(REF_ATTR));
                if (appender instanceof AppenderAttachable) {
                    AppenderAttachable appenderAttachable = (AppenderAttachable)((Object)appender);
                    LogLog.debug("Attaching appender named [" + string2 + "] to appender named [" + appender.getName() + "].");
                    appenderAttachable.addAppender(this.findAppenderByReference(element2));
                    continue;
                }
                LogLog.error("Requesting attachment of appender named [" + string2 + "] to appender named [" + appender.getName() + "] which does not implement org.apache.log4j.spi.AppenderAttachable.");
            }
            propertySetter.activate();
            return appender;
        }
        catch (Exception exception) {
            LogLog.error("Could not create an Appender. Reported error follows.", exception);
            return null;
        }
    }

    protected void parseErrorHandler(Element element, Appender appender) {
        ErrorHandler errorHandler = (ErrorHandler)OptionConverter.instantiateByClassName(this.subst(element.getAttribute(CLASS_ATTR)), class$org$apache$log4j$spi$ErrorHandler == null ? (class$org$apache$log4j$spi$ErrorHandler = DOMConfigurator.class$("org.apache.log4j.spi.ErrorHandler")) : class$org$apache$log4j$spi$ErrorHandler, null);
        if (errorHandler != null) {
            errorHandler.setAppender(appender);
            PropertySetter propertySetter = new PropertySetter(errorHandler);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals(PARAM_TAG)) {
                    this.setParameter(element2, propertySetter);
                    continue;
                }
                if (string.equals(APPENDER_REF_TAG)) {
                    errorHandler.setBackupAppender(this.findAppenderByReference(element2));
                    continue;
                }
                if (string.equals(LOGGER_REF)) {
                    object = element2.getAttribute(REF_ATTR);
                    Logger logger = this.repository.getLogger((String)object);
                    errorHandler.setLogger(logger);
                    continue;
                }
                if (!string.equals(ROOT_REF)) continue;
                object = this.repository.getRootLogger();
                errorHandler.setLogger((Logger)object);
            }
            propertySetter.activate();
            appender.setErrorHandler(errorHandler);
        }
    }

    protected void parseFilters(Element element, Appender appender) {
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        Filter filter = (Filter)OptionConverter.instantiateByClassName(string, class$org$apache$log4j$spi$Filter == null ? (class$org$apache$log4j$spi$Filter = DOMConfigurator.class$("org.apache.log4j.spi.Filter")) : class$org$apache$log4j$spi$Filter, null);
        if (filter != null) {
            PropertySetter propertySetter = new PropertySetter(filter);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2;
                String string2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(string2 = (element2 = (Element)node).getTagName()).equals(PARAM_TAG)) continue;
                this.setParameter(element2, propertySetter);
            }
            propertySetter.activate();
            LogLog.debug("Adding filter of type [" + filter.getClass() + "] to appender named [" + appender.getName() + "].");
            appender.addFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseCategory(Element element) {
        Object object;
        Logger logger;
        String string = this.subst(element.getAttribute(NAME_ATTR));
        String string2 = this.subst(element.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(string2)) {
            LogLog.debug("Retreiving an instance of org.apache.log4j.Logger.");
            logger = this.repository.getLogger(string);
        } else {
            LogLog.debug("Desired logger sub-class: [" + string2 + ']');
            try {
                object = Loader.loadClass(string2);
                Method method = ((Class)object).getMethod("getLogger", ONE_STRING_PARAM);
                logger = (Logger)method.invoke(null, string);
            }
            catch (Exception exception) {
                LogLog.error("Could not retrieve category [" + string + "]. Reported error follows.", exception);
                return;
            }
        }
        object = logger;
        synchronized (object) {
            boolean bl = OptionConverter.toBoolean(this.subst(element.getAttribute(ADDITIVITY_ATTR)), true);
            LogLog.debug("Setting [" + logger.getName() + "] additivity to [" + bl + "].");
            logger.setAdditivity(bl);
            this.parseChildrenOfLoggerElement(element, logger, false);
        }
    }

    protected void parseCategoryFactory(Element element) {
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        if (EMPTY_STR.equals(string)) {
            LogLog.error("Category Factory tag class attribute not found.");
            LogLog.debug("No Category Factory configured.");
        } else {
            LogLog.debug("Desired category factory: [" + string + ']');
            Object object = OptionConverter.instantiateByClassName(string, class$org$apache$log4j$spi$LoggerFactory == null ? (class$org$apache$log4j$spi$LoggerFactory = DOMConfigurator.class$("org.apache.log4j.spi.LoggerFactory")) : class$org$apache$log4j$spi$LoggerFactory, null);
            PropertySetter propertySetter = new PropertySetter(object);
            Element element2 = null;
            Node node = null;
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(element2 = (Element)node).getTagName().equals(PARAM_TAG)) continue;
                this.setParameter(element2, propertySetter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRoot(Element element) {
        Logger logger;
        Logger logger2 = logger = this.repository.getRootLogger();
        synchronized (logger2) {
            this.parseChildrenOfLoggerElement(element, logger, true);
        }
    }

    protected void parseChildrenOfLoggerElement(Element element, Logger logger, boolean bl) {
        PropertySetter propertySetter = new PropertySetter(logger);
        logger.removeAllAppenders();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element2 = (Element)node;
            String string = element2.getTagName();
            if (string.equals(APPENDER_REF_TAG)) {
                Element element3 = (Element)node;
                Appender appender = this.findAppenderByReference(element3);
                String string2 = this.subst(element3.getAttribute(REF_ATTR));
                if (appender != null) {
                    LogLog.debug("Adding appender named [" + string2 + "] to category [" + logger.getName() + "].");
                } else {
                    LogLog.debug("Appender named [" + string2 + "] not found.");
                }
                logger.addAppender(appender);
                continue;
            }
            if (string.equals(LEVEL_TAG)) {
                this.parseLevel(element2, logger, bl);
                continue;
            }
            if (string.equals(PRIORITY_TAG)) {
                this.parseLevel(element2, logger, bl);
                continue;
            }
            if (!string.equals(PARAM_TAG)) continue;
            this.setParameter(element2, propertySetter);
        }
        propertySetter.activate();
    }

    protected Layout parseLayout(Element element) {
        String string = this.subst(element.getAttribute(CLASS_ATTR));
        LogLog.debug("Parsing layout of class: \"" + string + "\"");
        try {
            Object t = Loader.loadClass(string).newInstance();
            Layout layout = (Layout)t;
            PropertySetter propertySetter = new PropertySetter(layout);
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element2;
                String string2;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(string2 = (element2 = (Element)node).getTagName()).equals(PARAM_TAG)) continue;
                this.setParameter(element2, propertySetter);
            }
            propertySetter.activate();
            return layout;
        }
        catch (Exception exception) {
            LogLog.error("Could not create the Layout. Reported error follows.", exception);
            return null;
        }
    }

    protected void parseRenderer(Element element) {
        String string = this.subst(element.getAttribute(RENDERING_CLASS_ATTR));
        String string2 = this.subst(element.getAttribute(RENDERED_CLASS_ATTR));
        if (this.repository instanceof RendererSupport) {
            RendererMap.addRenderer((RendererSupport)((Object)this.repository), string2, string);
        }
    }

    protected void parseLevel(Element element, Logger logger, boolean bl) {
        String string = logger.getName();
        if (bl) {
            string = ROOT_TAG;
        }
        String string2 = this.subst(element.getAttribute(VALUE_ATTR));
        LogLog.debug("Level value for " + string + " is  [" + string2 + "].");
        if ("inherited".equalsIgnoreCase(string2) || "null".equalsIgnoreCase(string2)) {
            if (bl) {
                LogLog.error("Root level cannot be inherited. Ignoring directive.");
            } else {
                logger.setLevel(null);
            }
        } else {
            String string3 = this.subst(element.getAttribute(CLASS_ATTR));
            if (EMPTY_STR.equals(string3)) {
                logger.setLevel(OptionConverter.toLevel(string2, Level.DEBUG));
            } else {
                LogLog.debug("Desired Level sub-class: [" + string3 + ']');
                try {
                    Class clazz = Loader.loadClass(string3);
                    Method method = clazz.getMethod("toLevel", ONE_STRING_PARAM);
                    Level level = (Level)method.invoke(null, string2);
                    logger.setLevel(level);
                }
                catch (Exception exception) {
                    LogLog.error("Could not create level [" + string2 + "]. Reported error follows.", exception);
                    return;
                }
            }
        }
        LogLog.debug(string + " level set to " + logger.getLevel());
    }

    protected void setParameter(Element element, PropertySetter propertySetter) {
        String string = this.subst(element.getAttribute(NAME_ATTR));
        String string2 = element.getAttribute(VALUE_ATTR);
        string2 = this.subst(OptionConverter.convertSpecialChars(string2));
        propertySetter.setProperty(string, string2);
    }

    public static void configure(Element element) {
        DOMConfigurator dOMConfigurator = new DOMConfigurator();
        dOMConfigurator.doConfigure(element, LogManager.getLoggerRepository());
    }

    public static void configureAndWatch(String string) {
        DOMConfigurator.configureAndWatch(string, 60000L);
    }

    public static void configureAndWatch(String string, long l) {
        XMLWatchdog xMLWatchdog = new XMLWatchdog(string);
        xMLWatchdog.setDelay(l);
        xMLWatchdog.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doConfigure(String string, LoggerRepository loggerRepository) {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        this.doConfigure(fileInputStream, loggerRepository);
        Object var6_4 = null;
        if (fileInputStream == null) return;
        try {
            fileInputStream.close();
            return;
        }
        catch (IOException iOException) {
            LogLog.error("Could not close [" + string + "].", iOException);
        }
        return;
        {
            catch (IOException iOException) {
                LogLog.error("Could not open [" + string + "].", iOException);
                Object var6_5 = null;
                if (fileInputStream == null) return;
                try {
                    fileInputStream.close();
                    return;
                }
                catch (IOException iOException2) {
                    LogLog.error("Could not close [" + string + "].", iOException2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                LogLog.error("Could not close [" + string + "].", iOException);
            }
            throw throwable;
        }
    }

    public void doConfigure(URL uRL, LoggerRepository loggerRepository) {
        try {
            this.doConfigure(uRL.openStream(), loggerRepository);
        }
        catch (IOException iOException) {
            LogLog.error("Could not open [" + uRL + "].", iOException);
        }
    }

    public void doConfigure(InputStream inputStream, LoggerRepository loggerRepository) throws FactoryConfigurationError {
        this.doConfigure(new InputSource(inputStream), loggerRepository);
    }

    public void doConfigure(Reader reader, LoggerRepository loggerRepository) throws FactoryConfigurationError {
        this.doConfigure(new InputSource(reader), loggerRepository);
    }

    protected void doConfigure(InputSource inputSource, LoggerRepository loggerRepository) throws FactoryConfigurationError {
        DocumentBuilderFactory documentBuilderFactory = null;
        this.repository = loggerRepository;
        try {
            LogLog.debug("System property is :" + OptionConverter.getSystemProperty(dbfKey, null));
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            LogLog.debug("Standard DocumentBuilderFactory search succeded.");
            LogLog.debug("DocumentBuilderFactory is: " + documentBuilderFactory.getClass().getName());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            Exception exception = factoryConfigurationError.getException();
            LogLog.debug("Could not instantiate a DocumentBuilderFactory.", exception);
            throw factoryConfigurationError;
        }
        try {
            documentBuilderFactory.setValidating(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new SAXErrorHandler());
            documentBuilder.setEntityResolver(new Log4jEntityResolver());
            inputSource.setSystemId("dummy://log4j.dtd");
            Document document = documentBuilder.parse(inputSource);
            this.parse(document.getDocumentElement());
        }
        catch (Exception exception) {
            LogLog.error("Could not parse input source [" + inputSource + "].", exception);
        }
    }

    public void doConfigure(Element element, LoggerRepository loggerRepository) {
        this.repository = loggerRepository;
        this.parse(element);
    }

    public static void configure(String string) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(string, LogManager.getLoggerRepository());
    }

    public static void configure(URL uRL) throws FactoryConfigurationError {
        new DOMConfigurator().doConfigure(uRL, LogManager.getLoggerRepository());
    }

    protected void parse(Element element) {
        int n;
        String string = element.getTagName();
        if (!string.equals(CONFIGURATION_TAG)) {
            if (string.equals(OLD_CONFIGURATION_TAG)) {
                LogLog.warn("The <configuration> element has been deprecated.");
                LogLog.warn("Use the <log4j:configuration> element instead.");
            } else {
                LogLog.error("DOM element is - not a <log4j:configuration> element.");
                return;
            }
        }
        String string2 = this.subst(element.getAttribute(INTERNAL_DEBUG_ATTR));
        LogLog.debug("debug attribute= \"" + string2 + "\".");
        if (!string2.equals(EMPTY_STR) && !string2.equals("null")) {
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string2, true));
        } else {
            LogLog.debug("Ignoring debug attribute.");
        }
        String string3 = this.subst(element.getAttribute(CONFIG_DEBUG_ATTR));
        if (!string3.equals(EMPTY_STR) && !string3.equals("null")) {
            LogLog.warn("The \"configDebug\" attribute is deprecated.");
            LogLog.warn("Use the \"debug\" attribute instead.");
            LogLog.setInternalDebugging(OptionConverter.toBoolean(string3, true));
        }
        String string4 = this.subst(element.getAttribute(THRESHOLD_ATTR));
        LogLog.debug("Threshold =\"" + string4 + "\".");
        if (!EMPTY_STR.equals(string4) && !"null".equals(string4)) {
            this.repository.setThreshold(string4);
        }
        String string5 = null;
        Element element2 = null;
        Node node = null;
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        for (n = 0; n < n2; ++n) {
            node = nodeList.item(n);
            if (node.getNodeType() != 1 || !(string5 = (element2 = (Element)node).getTagName()).equals(CATEGORY_FACTORY_TAG)) continue;
            this.parseCategoryFactory(element2);
        }
        for (n = 0; n < n2; ++n) {
            node = nodeList.item(n);
            if (node.getNodeType() != 1) continue;
            element2 = (Element)node;
            string5 = element2.getTagName();
            if (string5.equals(CATEGORY) || string5.equals(LOGGER)) {
                this.parseCategory(element2);
                continue;
            }
            if (string5.equals(ROOT_TAG)) {
                this.parseRoot(element2);
                continue;
            }
            if (!string5.equals(RENDERER_TAG)) continue;
            this.parseRenderer(element2);
        }
    }

    protected String subst(String string) {
        try {
            return OptionConverter.substVars(string, this.props);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogLog.warn("Could not perform variable substitution.", illegalArgumentException);
            return string;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

