/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.common.instrumentation.logging;

import com.softwareag.common.instrumentation.logging.LogNothing;
import com.softwareag.common.instrumentation.logging.LogParmsClassMethodMessage;
import com.softwareag.common.instrumentation.logging.LogParmsClassMethodMessageParams;
import com.softwareag.common.instrumentation.logging.LogParmsEnter;
import com.softwareag.common.instrumentation.logging.LogParmsEnterWithParams;
import com.softwareag.common.instrumentation.logging.LogParmsExit;
import com.softwareag.common.instrumentation.logging.LogParmsExitWithResult;
import com.softwareag.common.instrumentation.logging.LogParmsMessageParams;
import com.softwareag.common.instrumentation.logging.LogParmsObjArray;
import com.softwareag.common.instrumentation.logging.Logger;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;

public class Log4jLogger
implements Logger {
    protected Category cat;
    protected static int useCount = 0;
    public static final String OPTION_LOGGING_SWITCH = "com.softwareag.LoggingOn";
    public static final String OPTION_AUTO_INIT = "autoFilter";
    private static final String LAYOUT_PATTERN = "%-5p [%t] %20c - %m%n";
    public static final String RESOURCE_BUNDLE_NAME = "log4j";
    private String revNumber = "";
    private static boolean logStatusKnown = false;
    private static boolean loggingAlwaysOff = true;
    private static boolean loggingOn = false;
    private static boolean autoFilter = false;
    private static String autoFilterName;

    private static void setLogStatusKnown(boolean bl) {
        logStatusKnown = bl;
    }

    private static boolean isLogStatusKnown() {
        return logStatusKnown;
    }

    protected static void setSwitchLogging(boolean bl) {
        loggingOn = bl && !Log4jLogger.isLoggingAlwaysOff();
    }

    protected static boolean isLoggingAlwaysOff() {
        Log4jLogger.readLogStatus();
        return loggingAlwaysOff;
    }

    protected static boolean isLoggingOn() {
        Log4jLogger.readLogStatus();
        return loggingOn;
    }

    protected Log4jLogger(String string) {
        this.cat = Category.getInstance((String)string);
    }

    public static Logger getLogger(String string) {
        if (useCount == 0) {
            Log4jLogger.readLogStatus();
            if (!Log4jLogger.isLoggingAlwaysOff() && autoFilter) {
                Log4jLogger.autoInitLog4j(autoFilterName);
            }
        }
        ++useCount;
        if (Log4jLogger.isLoggingAlwaysOff()) {
            return new LogNothing();
        }
        return new Log4jLogger(string);
    }

    public static Logger getLogger(String string, String string2) {
        Logger logger = Log4jLogger.getLogger(string);
        if (!Log4jLogger.isLoggingAlwaysOff() && logger instanceof Log4jLogger) {
            ((Log4jLogger)logger).setRevisionNumber(string2);
        }
        return logger;
    }

    private void setRevisionNumber(String string) {
        int n = string.indexOf(":");
        this.revNumber = "$" + string.substring(n + 1, string.length() - 1).trim();
    }

    private static void readLogStatus() {
        if (!Log4jLogger.isLogStatusKnown()) {
            try {
                Log4jLogger.setLogStatusKnown(true);
                String string = System.getProperty(OPTION_LOGGING_SWITCH);
                if (string == null) {
                    loggingAlwaysOff = true;
                } else {
                    Boolean bl = new Boolean(string);
                    loggingAlwaysOff = false;
                    Log4jLogger.setSwitchLogging(bl);
                }
                string = System.getProperty(OPTION_AUTO_INIT);
                if (string != null) {
                    autoFilter = true;
                    autoFilterName = new String(string);
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static void autoInitLog4j(String string) {
        BasicConfigurator.configure();
        Category category = Category.getRoot();
        PatternLayout patternLayout = new PatternLayout(LAYOUT_PATTERN);
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)patternLayout, "System.out");
        category.addAppender((Appender)consoleAppender);
        category.setPriority(Priority.FATAL);
        Category category2 = Category.getInstance((String)string);
        category2.setPriority(Priority.INFO);
    }

    protected static void setLevel(String string, int n) {
        Category category = Category.exists((String)string);
        if (category != null) {
            category.setPriority(Priority.toPriority((int)n));
        }
    }

    public boolean isLoggable(int n) {
        if (!loggingOn) {
            return false;
        }
        return this.cat.isEnabledFor(Priority.toPriority((int)n));
    }

    public void setLevel(int n) {
        this.cat.setPriority(Priority.toPriority((int)n));
    }

    public void entering(String string, String string2) {
        this.cat.debug((Object)new LogParmsEnter(string + this.revNumber, string2));
    }

    public void entering(String string, String string2, Object[] objectArray) {
        this.cat.debug((Object)new LogParmsEnterWithParams(string + this.revNumber, string2, objectArray));
    }

    public void exiting(String string, String string2) {
        this.cat.debug((Object)new LogParmsExit(string + this.revNumber, string2));
    }

    public void exiting(String string, String string2, Object object) {
        this.cat.debug((Object)new LogParmsExitWithResult(string + this.revNumber, string2, object));
    }

    public void fine(String string) {
        this.cat.debug((Object)string);
    }

    public void fine(String string, Object[] objectArray) {
        this.cat.debug((Object)(string + new LogParmsObjArray(objectArray).toString()));
    }

    public void fine(String string, String string2, String string3) {
        this.cat.debug((Object)new LogParmsClassMethodMessage(string + this.revNumber, string2, string3));
    }

    public void fine(String string, String string2, String string3, Object[] objectArray) {
        this.cat.debug((Object)new LogParmsClassMethodMessageParams(string + this.revNumber, string2, string3, objectArray));
    }

    public void info(String string) {
        this.cat.info((Object)string);
    }

    public void info(String string, Object[] objectArray) {
        this.cat.info((Object)new LogParmsMessageParams(string, objectArray));
    }

    public void info(String string, String string2, String string3) {
        this.cat.info((Object)new LogParmsClassMethodMessage(string + this.revNumber, string2, string3));
    }

    public void info(String string, String string2, String string3, Object[] objectArray) {
        this.cat.info((Object)new LogParmsClassMethodMessageParams(string + this.revNumber, string2, string3, objectArray));
    }

    public void log(int n, String string, String string2, String string3, Throwable throwable) {
        this.cat.log(Priority.toPriority((int)n), (Object)new LogParmsClassMethodMessage(string + this.revNumber, string2, string3), throwable);
    }

    public void log(int n, String string, Throwable throwable) {
        this.cat.log(Priority.toPriority((int)n), (Object)string, throwable);
    }

    public void severe(String string) {
        this.cat.error((Object)string);
    }

    public void severe(String string, Object[] objectArray) {
        this.cat.error((Object)new LogParmsMessageParams(string, objectArray));
    }

    public void severe(String string, String string2, String string3) {
        this.cat.error((Object)new LogParmsClassMethodMessage(string, string2, string3));
    }

    public void severe(String string, String string2, String string3, Object[] objectArray) {
        this.cat.error((Object)new LogParmsClassMethodMessageParams(string + this.revNumber, string2, string3, objectArray));
    }

    public void throwing(String string, String string2, Throwable throwable) {
        this.cat.debug((Object)new LogParmsClassMethodMessage(string + this.revNumber, string2, "THROW"), throwable);
    }

    public void warning(String string) {
        this.cat.warn((Object)string);
    }

    public void warning(String string, Object[] objectArray) {
        this.cat.warn((Object)new LogParmsMessageParams(string, objectArray));
    }

    public void warning(String string, String string2, String string3) {
        this.cat.warn((Object)new LogParmsClassMethodMessage(string + this.revNumber, string2, string3));
    }

    public void warning(String string, String string2, String string3, Object[] objectArray) {
        this.cat.warn((Object)new LogParmsClassMethodMessageParams(string + this.revNumber, string2, string3, objectArray));
    }
}

