/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.common.resourceutilities.message;

public class MessageCode {
    public static final String FORMAT_MISMATCH = "Code string has not expected format 'PPPCCSxxxx': ";
    public static final String PRODUCT_IDENTIFIER_MISMATCH = "Product identifier string must be a three letter String: ";
    public static final String COMPONENT_IDENTIFIER_MISMATCH = "Component identifier string must be a two letter String: ";
    public static final String SEVERITY_MISMATCH = "Severity must not be null";
    public static final String NUMBER_MISMATCH = "Number string must be a four digit String: ";
    protected String productIdentifier = null;
    protected String componentIdentifier = null;
    protected Severity severity = null;
    protected String number = null;
    protected String stringRepresentation = null;

    public MessageCode(String string, String string2, Severity severity, String string3) throws IllegalArgumentException {
        MessageCode.checkProductIdentifier(string);
        MessageCode.checkComponentIdentifier(string2);
        MessageCode.checkSeverity(severity);
        MessageCode.checkNumber(string3);
        this.productIdentifier = string;
        this.componentIdentifier = string2;
        this.severity = severity;
        this.number = string3;
    }

    public MessageCode(String string) throws IllegalArgumentException {
        if (string == null || string.length() != 10) {
            throw new IllegalArgumentException(FORMAT_MISMATCH + string);
        }
        RuntimeException runtimeException = null;
        try {
            this.productIdentifier = string.substring(0, 3);
            this.componentIdentifier = string.substring(3, 5);
            this.severity = Severity.getSeverityForCodeChar(string.charAt(5));
            this.number = string.substring(6, 10);
        }
        catch (NullPointerException nullPointerException) {
            runtimeException = nullPointerException;
        }
        catch (NumberFormatException numberFormatException) {
            runtimeException = numberFormatException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            runtimeException = indexOutOfBoundsException;
        }
        if (runtimeException != null) {
            runtimeException.printStackTrace();
            throw new IllegalArgumentException(FORMAT_MISMATCH + string);
        }
        MessageCode.checkProductIdentifier(this.productIdentifier);
        MessageCode.checkComponentIdentifier(this.componentIdentifier);
        MessageCode.checkSeverity(this.severity);
        MessageCode.checkNumber(this.number);
    }

    public static void checkProductIdentifier(String string) throws IllegalArgumentException {
        if (string == null || string.length() != 3) {
            throw new IllegalArgumentException(PRODUCT_IDENTIFIER_MISMATCH + string);
        }
        int n = 0;
        while (n < 3) {
            if (!Character.isLetter(string.charAt(n)) || !Character.isUpperCase(string.charAt(n))) {
                throw new IllegalArgumentException(PRODUCT_IDENTIFIER_MISMATCH + string);
            }
            ++n;
        }
    }

    public static void checkComponentIdentifier(String string) throws IllegalArgumentException {
        if (string == null || string.length() != 2) {
            throw new IllegalArgumentException(COMPONENT_IDENTIFIER_MISMATCH + string);
        }
        int n = 0;
        while (n < 2) {
            if (!(Character.isLetter(string.charAt(n)) && Character.isUpperCase(string.charAt(n)) || Character.isDigit(string.charAt(n)))) {
                throw new IllegalArgumentException(COMPONENT_IDENTIFIER_MISMATCH + string);
            }
            ++n;
        }
    }

    public static void checkSeverity(Severity severity) throws IllegalArgumentException {
        if (severity == null) {
            throw new IllegalArgumentException(SEVERITY_MISMATCH);
        }
    }

    public static void checkNumber(String string) throws IllegalArgumentException {
        if (string == null || string.length() != 4) {
            throw new IllegalArgumentException(NUMBER_MISMATCH + string);
        }
        int n = 0;
        while (n < 4) {
            if (!Character.isDigit(string.charAt(n))) {
                throw new IllegalArgumentException(NUMBER_MISMATCH + string);
            }
            ++n;
        }
    }

    public String getProductIdentifier() {
        return this.productIdentifier;
    }

    public String getComponentIdentifier() {
        return this.componentIdentifier;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getNumber() {
        return this.number;
    }

    public String toString() {
        if (this.stringRepresentation == null) {
            StringBuffer stringBuffer = new StringBuffer(this.getProductIdentifier());
            stringBuffer.append(this.getComponentIdentifier());
            stringBuffer.append(this.getSeverity().getCodeChar());
            stringBuffer.append(this.getNumber());
            this.stringRepresentation = stringBuffer.toString();
        }
        return this.stringRepresentation;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MessageCode) {
            MessageCode messageCode = (MessageCode)object;
            bl = this.getProductIdentifier().equals(messageCode.getProductIdentifier());
            bl &= this.getComponentIdentifier().equals(messageCode.getComponentIdentifier());
            bl &= this.getSeverity().equals(messageCode.getSeverity());
            bl &= this.getNumber().equals(messageCode.getNumber());
        }
        return bl;
    }

    public int hashCode() {
        return this.getProductIdentifier().hashCode() + 7 * this.getComponentIdentifier().hashCode() + 13 * this.getSeverity().hashCode() + 17 * this.getNumber().hashCode();
    }

    public static class Severity
    implements Comparable {
        public static final Severity INFORMATION = new Severity(0, "Information");
        public static final Severity QUESTION = new Severity(1, "Question");
        public static final Severity WARNING = new Severity(2, "Warning");
        public static final Severity ERROR = new Severity(3, "Error");
        public static final Severity CRITICAL = new Severity(4, "Critical");
        protected static Severity[] severities = new Severity[]{INFORMATION, QUESTION, WARNING, ERROR, CRITICAL};
        protected int level = 0;
        protected String name = null;
        protected String stringRepresentation = null;

        private Severity(int n, String string) {
            this.level = n;
            this.name = string;
        }

        public int getLevel() {
            return this.level;
        }

        public String getName() {
            return this.name;
        }

        public char getCodeChar() {
            return this.getName().charAt(0);
        }

        public int compareTo(Object object) throws ClassCastException {
            return this.getLevel() - ((Severity)object).getLevel();
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof Severity) {
                bl = this.getLevel() == ((Severity)object).getLevel();
            }
            return bl;
        }

        public int hashCode() {
            return this.level;
        }

        public String toString() {
            if (this.stringRepresentation == null) {
                StringBuffer stringBuffer = new StringBuffer("Severity[");
                stringBuffer.append(this.getName());
                stringBuffer.append("]");
                this.stringRepresentation = stringBuffer.toString();
            }
            return this.stringRepresentation;
        }

        public static Severity[] getSeverities() {
            return severities;
        }

        public static Severity getSeverityForCodeChar(char c) {
            Severity severity = null;
            Severity[] severityArray = Severity.getSeverities();
            int n = 0;
            while (severity == null & n < severityArray.length) {
                if (severityArray[n].getCodeChar() == c) {
                    severity = severityArray[n];
                }
                ++n;
            }
            return severity;
        }
    }
}

