/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.common.resourceutilities.message;

import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.common.resourceutilities.message.AbstractDetailedMessage;
import com.softwareag.common.resourceutilities.message.MessageCode;
import com.softwareag.common.resourceutilities.message.MessageConstants;
import com.softwareag.common.resourceutilities.message.MessageRetrieveException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceMessage
extends AbstractDetailedMessage
implements MessageConstants {
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME);
    public static final String RESOURCE_BUNDLE_IS_NULL = "Parameter 'resourceBundle' is null";
    public static final String ID_IS_NULL = "Parameter 'id' is null";
    protected ResourceBundle resourceBundle;
    protected String id;
    protected Object[] parameters;
    protected MessageCode messageCode;
    protected String messageTitle;
    protected String messageContent;
    protected String explanationTitle;
    protected String explanationContent;
    protected String actionTitle;
    protected String actionContent;
    protected String helpID;

    public ResourceMessage(ResourceBundle resourceBundle, String string) throws MessageRetrieveException {
        this(resourceBundle, string, (Object[])null);
    }

    public ResourceMessage(ResourceBundle resourceBundle, String string, String string2) throws MessageRetrieveException {
        Object[] objectArray;
        if (string2 != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = string2;
        } else {
            objectArray = null;
        }
        this(resourceBundle, string, objectArray);
    }

    public ResourceMessage(ResourceBundle resourceBundle, String string, Object[] objectArray) throws MessageRetrieveException {
        this.resourceBundle = null;
        this.id = null;
        this.parameters = null;
        this.messageCode = null;
        this.messageTitle = null;
        this.messageContent = null;
        this.explanationTitle = null;
        this.explanationContent = null;
        this.actionTitle = null;
        this.actionContent = null;
        this.helpID = null;
        if (resourceBundle == null) {
            throw new MessageRetrieveException(resourceBundle, string, RESOURCE_BUNDLE_IS_NULL);
        }
        if (string == null) {
            throw new MessageRetrieveException(resourceBundle, string, ID_IS_NULL);
        }
        this.resourceBundle = resourceBundle;
        this.id = string;
        this.parameters = objectArray;
        this.messageContent = ResourceMessage.getResourceString(resourceBundle, string, null);
        this.messageTitle = ResourceMessage.getResourceString(resourceBundle, string, "_TITLE");
        this.explanationContent = ResourceMessage.getResourceString(resourceBundle, string, "_EXPLANATION");
        this.explanationTitle = ResourceMessage.getResourceString(resourceBundle, string, "_EXPLANATION_TITLE");
        this.actionContent = ResourceMessage.getResourceString(resourceBundle, string, "_ACTION");
        this.actionTitle = ResourceMessage.getResourceString(resourceBundle, string, "_ACTION_TITLE");
        this.helpID = ResourceMessage.getResourceString(resourceBundle, string, "_HELP_ID");
        if (this.messageContent != null) {
            int n = this.messageContent.indexOf(" ");
            if (n > 1) {
                String string2 = this.messageContent.substring(0, n);
                try {
                    this.messageCode = new MessageCode(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.throwing(LOG_NAME, "Failure parsing message code", illegalArgumentException);
                    }
                    throw new MessageRetrieveException(resourceBundle, string, "Parsing the MessageCode failed", illegalArgumentException);
                }
                this.messageContent = this.messageContent.length() > n ? this.messageContent.substring(n + 1) : "";
            }
            if (objectArray != null && objectArray.length > 0) {
                this.messageContent = MessageFormat.format(this.messageContent, objectArray);
            }
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String getID() {
        return this.id;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public MessageCode getMessageCode() {
        return this.messageCode;
    }

    public String getMessageTitle() {
        return this.messageTitle;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public String getExplanationTitle() {
        return this.explanationTitle;
    }

    public String getExplanationContent() {
        return this.explanationContent;
    }

    public String getActionTitle() {
        return this.actionTitle;
    }

    public String getActionContent() {
        return this.actionContent;
    }

    public String getHelpID() {
        return this.helpID;
    }

    public void setDetails(String string) {
        super.setDetails(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ResourceMessage[");
        stringBuffer.append("resourceBundle=");
        stringBuffer.append(this.getResourceBundle());
        stringBuffer.append(", id=");
        stringBuffer.append(this.getID());
        stringBuffer.append(", parameters=");
        stringBuffer.append(this.getParameters() != null ? Arrays.asList(this.getParameters()) : null);
        stringBuffer.append(", messageCode=");
        stringBuffer.append(this.getMessageCode());
        stringBuffer.append(", messageTitle=");
        stringBuffer.append(this.getMessageTitle());
        stringBuffer.append(", messageContent=");
        stringBuffer.append(this.getMessageContent());
        stringBuffer.append(", explanationTitle=");
        stringBuffer.append(this.getExplanationTitle());
        stringBuffer.append(", explanationContent=");
        stringBuffer.append(this.getExplanationContent());
        stringBuffer.append(", actionTitle=");
        stringBuffer.append(this.getActionTitle());
        stringBuffer.append(", actionContent=");
        stringBuffer.append(this.getActionContent());
        stringBuffer.append(", helpID=");
        stringBuffer.append(this.getHelpID());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected static String getResourceString(ResourceBundle resourceBundle, String string, String string2) throws MessageRetrieveException {
        String string3 = null;
        if (string2 == null) {
            try {
                string3 = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.throwing(LOG_NAME, "Resource not found", missingResourceException);
                }
                throw new MessageRetrieveException(resourceBundle, string, "Resource for id '" + string + "' not found in ResourceBundle", missingResourceException);
            }
        }
        try {
            string3 = resourceBundle.getString(string + string2);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string3;
    }
}

