/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessor;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.common.TDatabase;
import com.softwareag.tamino.db.api.connection.TLockMode;
import com.softwareag.tamino.db.api.connection.TLockwaitMode;
import com.softwareag.tamino.db.api.connection.TTransactionParameters;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;

public abstract class TAbstractAccessor
implements TAccessor {
    private TSharedAccessorProperties sharedAccessorProperties = null;
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$accessor$TAbstractAccessor == null ? (class$com$softwareag$tamino$db$api$accessor$TAbstractAccessor = TAbstractAccessor.class$("com.softwareag.tamino.db.api.accessor.TAbstractAccessor")) : class$com$softwareag$tamino$db$api$accessor$TAbstractAccessor);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$accessor$TAbstractAccessor == null ? (class$com$softwareag$tamino$db$api$accessor$TAbstractAccessor = TAbstractAccessor.class$("com.softwareag.tamino.db.api.accessor.TAbstractAccessor")) : class$com$softwareag$tamino$db$api$accessor$TAbstractAccessor);
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$accessor$TAbstractAccessor;

    protected TAbstractAccessor() {
        this.sharedAccessorProperties = new TSharedAccessorProperties();
    }

    protected TAbstractAccessor(TAbstractAccessor tAbstractAccessor) {
        this.sharedAccessorProperties = tAbstractAccessor.sharedAccessorProperties;
    }

    protected TAbstractAccessor(TAccessLocation tAccessLocation, TInvocation tInvocation) {
        this.sharedAccessorProperties = new TSharedAccessorProperties(tAccessLocation, tInvocation);
    }

    public void invalidate() {
        this.sharedAccessorProperties.isValid = false;
    }

    public synchronized void setAccessLocation(TAccessLocation tAccessLocation) {
        this.sharedAccessorProperties.accessLocation = tAccessLocation;
    }

    public synchronized TAccessLocation getAccessLocation() {
        return (TAccessLocation)this.sharedAccessorProperties.accessLocation.clone();
    }

    protected synchronized TInvocation getInvocation() {
        return this.sharedAccessorProperties.invocation;
    }

    protected TDatabase getDatabase() {
        return this.sharedAccessorProperties.invocation.getDatabase();
    }

    protected synchronized String getAccessCollection() {
        return this.sharedAccessorProperties.accessLocation.getCollection();
    }

    public synchronized void setLockwaitMode(TLockwaitMode tLockwaitMode) {
        this.sharedAccessorProperties.transactionParameters.setLockwaitMode(tLockwaitMode);
    }

    public synchronized TLockwaitMode getLockwaitMode() {
        return this.sharedAccessorProperties.transactionParameters.getLockwaitMode();
    }

    public synchronized void setLockMode(TLockMode tLockMode) {
        this.sharedAccessorProperties.transactionParameters.setLockMode(tLockMode);
    }

    public synchronized TLockMode getLockMode() {
        return this.sharedAccessorProperties.transactionParameters.getLockMode();
    }

    public TInputStream invoke(TCommandStatement tCommandStatement) throws TInvocationException {
        Precondition.check(this.sharedAccessorProperties.isValid, "Accessor has been invalidated. Use no longer possible!");
        this.sharedAccessorProperties.transactionParameters.writeTo(tCommandStatement);
        return this.sharedAccessorProperties.invocation.invoke(tCommandStatement);
    }

    public TInputStream invoke(TCommandStatement tCommandStatement, String string) throws TInvocationException {
        Precondition.check(this.sharedAccessorProperties.isValid, "Accessor has been invalidated. Use no longer possible!");
        this.sharedAccessorProperties.transactionParameters.writeTo(tCommandStatement);
        return this.sharedAccessorProperties.invocation.invoke(tCommandStatement, string);
    }

    public TInputStream invoke(TCommandStatement tCommandStatement, String string, String string2, String string3) throws TInvocationException {
        Precondition.check(this.sharedAccessorProperties.isValid, "Accessor has been invalidated. Use no longer possible!");
        this.sharedAccessorProperties.transactionParameters.writeTo(tCommandStatement);
        return this.sharedAccessorProperties.invocation.invoke(tCommandStatement, string, string2, string3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class TSharedAccessorProperties {
        private boolean isValid = true;
        private TAccessLocation accessLocation = null;
        private TInvocation invocation = null;
        private TTransactionParameters transactionParameters = new TTransactionParameters();

        private TSharedAccessorProperties() {
        }

        private TSharedAccessorProperties(TAccessLocation tAccessLocation, TInvocation tInvocation) {
            this();
            this.accessLocation = tAccessLocation;
            this.invocation = tInvocation;
        }
    }
}

