/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.tamino.db.api.accessor.TDefineException;
import com.softwareag.tamino.db.api.accessor.TDeleteException;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TUndefineException;
import com.softwareag.tamino.db.api.accessor.TUpdateException;
import com.softwareag.tamino.db.api.accessor.TXQueryException;
import com.softwareag.tamino.db.api.common.TAccessFailureException;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseHandle;

public class TAccessFailureVerifier {
    private static TAccessFailureVerifier singleton = null;

    public static synchronized TAccessFailureVerifier getInstance() {
        if (singleton == null) {
            singleton = new TAccessFailureVerifier();
        }
        return singleton;
    }

    public void verifyInsertResponse(TResponse tResponse) throws TInsertException {
        TAccessFailureException tAccessFailureException = this.verify(tResponse);
        if (tAccessFailureException != null) {
            throw new TInsertException(tAccessFailureException);
        }
    }

    public void verifyUpdateResponse(TResponse tResponse) throws TUpdateException {
        TAccessFailureException tAccessFailureException = this.verify(tResponse);
        if (tAccessFailureException != null) {
            throw new TUpdateException(tAccessFailureException);
        }
    }

    public void verifyDeleteResponse(TResponse tResponse) throws TDeleteException {
        TAccessFailureException tAccessFailureException = this.verify(tResponse);
        if (tAccessFailureException != null) {
            throw new TDeleteException(tAccessFailureException);
        }
    }

    public void verifyQueryResponse(TResponse tResponse) throws TQueryException {
        TAccessFailureException tAccessFailureException = this.verify(tResponse);
        if (tAccessFailureException != null) {
            throw new TQueryException(tAccessFailureException);
        }
    }

    public void verifyXQueryResponse(TResponse tResponse) throws TXQueryException {
        TAccessFailureException tAccessFailureException = this.verify(tResponse);
        if (tAccessFailureException != null) {
            throw new TXQueryException(tAccessFailureException);
        }
    }

    public void verifyDefineResponse(TResponse tResponse) throws TDefineException {
        TAccessFailureException tAccessFailureException = this.verify(tResponse);
        if (tAccessFailureException != null) {
            throw new TDefineException(tAccessFailureException);
        }
    }

    public void verifyUndefineResponse(TResponse tResponse) throws TUndefineException {
        TAccessFailureException tAccessFailureException = this.verify(tResponse);
        if (tAccessFailureException != null) {
            throw new TUndefineException(tAccessFailureException);
        }
    }

    protected TAccessFailureException verify(TResponse tResponse) {
        TAccessFailureException tAccessFailureException = null;
        String string = tResponse.getReturnValue();
        if (!string.equals("0") && !string.equals("")) {
            tAccessFailureException = this.newAccessFailureException((TResponseHandle)tResponse);
        }
        return tAccessFailureException;
    }

    private TAccessFailureException newAccessFailureException(TResponseHandle tResponseHandle) {
        String string = tResponseHandle.getReturnValue();
        String string2 = tResponseHandle.getMessageCode();
        String string3 = tResponseHandle.getMessageText();
        String string4 = tResponseHandle.getMessageLine();
        return new TAccessFailureException(string, string2, string3, string4);
    }
}

