/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessFailureVerifier;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TDeleteException;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryBuilder;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TRetrieveException;
import com.softwareag.tamino.db.api.accessor.TUpdateException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.objectModel.TNonXMLObject;
import com.softwareag.tamino.db.api.response.THeaderEnlister;
import com.softwareag.tamino.db.api.response.TObjectContentItem;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseHandle;

public class TNonXMLObjectAccessorImpl
extends TAbstractAccessor
implements TNonXMLObjectAccessor {
    private TResponseBuilder responseBuilder = null;
    private TAccessFailureVerifier accessFailureVerifier = TAccessFailureVerifier.getInstance();
    private THeaderEnlister headerEnlister = THeaderEnlister.getInstance();
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$accessor$TNonXMLObjectAccessorImpl == null ? (class$com$softwareag$tamino$db$api$accessor$TNonXMLObjectAccessorImpl = TNonXMLObjectAccessorImpl.class$("com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessorImpl")) : class$com$softwareag$tamino$db$api$accessor$TNonXMLObjectAccessorImpl);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$accessor$TNonXMLObjectAccessorImpl == null ? (class$com$softwareag$tamino$db$api$accessor$TNonXMLObjectAccessorImpl = TNonXMLObjectAccessorImpl.class$("com.softwareag.tamino.db.api.accessor.TNonXMLObjectAccessorImpl")) : class$com$softwareag$tamino$db$api$accessor$TNonXMLObjectAccessorImpl);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.28 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$accessor$TNonXMLObjectAccessorImpl;

    public TNonXMLObjectAccessorImpl(TAccessLocation tAccessLocation, TInvocation tInvocation, TResponseBuilder tResponseBuilder) {
        super(tAccessLocation, tInvocation);
        this.responseBuilder = tResponseBuilder;
    }

    public synchronized TResponse insert(TNonXMLObject tNonXMLObject) throws TInsertException {
        Precondition.check(tNonXMLObject != null, "TNonXMLObject == null, please pass a valid instance.");
        Precondition.check(tNonXMLObject.getCollection().equals("") || tNonXMLObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the xmlObject's collection " + tNonXMLObject.getCollection() + "!");
        Precondition.check(!tNonXMLObject.getDoctype().equals(""), "TNonXMLObject does not contain doctype information!");
        Precondition.check(!tNonXMLObject.getContentType().equals(""), "TNonXMLObject does not contain content type information!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Insert");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.PROCESS, new TCommandValue(tNonXMLObject));
        TResponse tResponse = null;
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection(), tNonXMLObject.getDoctype(), tNonXMLObject.getDocname());
            tResponse = this.responseBuilder.buildForNonXML(tInputStream);
            TObjectContentItem tObjectContentItem = (TObjectContentItem)((TResponseHandle)tResponse).getInfoContent().getItem(0, TObjectContentItem.SPECIFIER);
            if (tObjectContentItem != null) {
                tNonXMLObject.setId(tObjectContentItem.getId());
                tNonXMLObject.setCollection(tObjectContentItem.getCollection());
                tNonXMLObject.setDoctype(tObjectContentItem.getDoctype());
                this.headerEnlister.enlistLastModified(tResponse, (TDataObject)tNonXMLObject);
            }
        }
        catch (TInvocationException tInvocationException) {
            throw new TInsertException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TInsertException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyInsertResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse update(TNonXMLObject tNonXMLObject) throws TUpdateException {
        Precondition.check(tNonXMLObject != null, "TNonXMLObject == null, please pass a valid instance.");
        Precondition.check(tNonXMLObject.getCollection().equals("") || tNonXMLObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the xmlObject's collection " + tNonXMLObject.getCollection() + "!");
        Precondition.check(!tNonXMLObject.getDoctype().equals(""), "TNonXMLObject does not contain doctype information!");
        Precondition.check(tNonXMLObject.hasId() || tNonXMLObject.hasDocname(), "Either id or docname has to be given on TNonXMLObject instance!");
        Precondition.check(!tNonXMLObject.getContentType().equals(""), "TNonXMLObject does not contain content type information!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Update");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.PROCESS, new TCommandValue(tNonXMLObject));
        TResponse tResponse = null;
        try {
            String string = tNonXMLObject.getDocname();
            string = !string.equals("") ? string : "@" + tNonXMLObject.getId();
            TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection(), tNonXMLObject.getDoctype(), string);
            tResponse = this.responseBuilder.buildForNonXML(tInputStream);
            TObjectContentItem tObjectContentItem = (TObjectContentItem)((TResponseHandle)tResponse).getInfoContent().getItem(0, TObjectContentItem.SPECIFIER);
            if (tObjectContentItem != null) {
                tNonXMLObject.setId(tObjectContentItem.getId());
                tNonXMLObject.setCollection(tObjectContentItem.getCollection());
                tNonXMLObject.setDoctype(tObjectContentItem.getDoctype());
                this.headerEnlister.enlistLastModified(tResponse, (TDataObject)tNonXMLObject);
            }
        }
        catch (TInvocationException tInvocationException) {
            throw new TUpdateException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TUpdateException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyUpdateResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse delete(TNonXMLObject tNonXMLObject) throws TDeleteException {
        Precondition.check(tNonXMLObject != null, "TNonXMLObject == null, please pass a valid instance.");
        Precondition.check(tNonXMLObject.getCollection().equals("") || tNonXMLObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the xmlObject's collection " + tNonXMLObject.getCollection() + "!");
        Precondition.check(!tNonXMLObject.getDoctype().equals(""), "TNonXMLObject does not contain doctype information!");
        Precondition.check(tNonXMLObject.hasDocname() || tNonXMLObject.hasId(), "TNonXMLObject does neither contain docname nor id information!");
        TQuery tQuery = null;
        tQuery = tNonXMLObject.hasId() ? TQueryBuilder.getInstance().buildFromId(tNonXMLObject.getDoctype(), tNonXMLObject.getId()) : TQueryBuilder.getInstance().buildFromDocname(tNonXMLObject.getDoctype(), tNonXMLObject.getDocname());
        TResponse tResponse = this.delete(tQuery);
        this.headerEnlister.enlistLastModified(tResponse, (TDataObject)tNonXMLObject);
        return tResponse;
    }

    public synchronized TResponse delete(TQuery tQuery) throws TDeleteException {
        Precondition.check(tQuery != null, "XPath statement is not given!");
        Precondition.check(!tQuery.getExpression().equals(""), "XPath statement is not given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Delete By Query");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DELETE, new TCommandValue(tQuery.getExpression()));
        TResponse tResponse = null;
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection());
            tResponse = this.responseBuilder.buildForNonXML(tInputStream);
        }
        catch (TInvocationException tInvocationException) {
            throw new TDeleteException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TDeleteException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyDeleteResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse query(TQuery tQuery) throws TQueryException {
        Precondition.check(tQuery != null, "XPath statement is not given!");
        Precondition.check(!tQuery.getExpression().equals(""), "XPath statement is not given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Query");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        TResponse tResponse = null;
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection());
            tResponse = this.responseBuilder.buildForNonXML(tInputStream);
        }
        catch (TInvocationException tInvocationException) {
            throw new TQueryException(tInvocationException);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TQueryException(tResponseBuildException);
        }
        this.accessFailureVerifier.verifyQueryResponse(tResponse);
        return tResponse;
    }

    public synchronized TNonXMLObject retrieve(TNonXMLObject tNonXMLObject) throws TRetrieveException {
        Precondition.check(tNonXMLObject != null, "TNonXMLObject == null, please pass a valid instance.");
        Precondition.check(!tNonXMLObject.getDoctype().equals(""), "No doctype information given!");
        Precondition.check(tNonXMLObject.hasId() || tNonXMLObject.hasDocname(), "Either no id or docname is given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("retrieve");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.RETRIEVE, new TCommandValue("?"));
        String string = tNonXMLObject.getDocname();
        string = !string.equals("") ? string : "@" + tNonXMLObject.getId();
        try {
            TInputStream tInputStream = this.invoke(tCommandStatement, this.getAccessCollection(), tNonXMLObject.getDoctype(), string);
            tNonXMLObject.readFrom(tInputStream);
            this.headerEnlister.enlistAll(tInputStream, (TDataObject)tNonXMLObject);
            return tNonXMLObject;
        }
        catch (TInvocationException tInvocationException) {
            throw new TRetrieveException(tInvocationException);
        }
        catch (TStreamReadException tStreamReadException) {
            throw new TRetrieveException(tStreamReadException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

