/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Postcondition;
import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.common.instrumentation.logging.Level;
import com.softwareag.common.instrumentation.logging.Logger;
import com.softwareag.common.instrumentation.logging.LoggerFactory;
import com.softwareag.common.instrumentation.logging.LoggerUtil;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAdminException;
import com.softwareag.tamino.db.api.accessor.TCursorException;
import com.softwareag.tamino.db.api.accessor.TDefineException;
import com.softwareag.tamino.db.api.accessor.TDefineMode;
import com.softwareag.tamino.db.api.accessor.TDeleteException;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TRetrieveException;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TUndefineException;
import com.softwareag.tamino.db.api.accessor.TUpdateException;
import com.softwareag.tamino.db.api.accessor.TXQuery;
import com.softwareag.tamino.db.api.accessor.TXQueryException;
import com.softwareag.tamino.db.api.command.TCommand;
import com.softwareag.tamino.db.api.command.TCommandParameter;
import com.softwareag.tamino.db.api.command.TCommandParameterValue;
import com.softwareag.tamino.db.api.command.TCommandStatement;
import com.softwareag.tamino.db.api.command.TCommandValue;
import com.softwareag.tamino.db.api.common.TPreference;
import com.softwareag.tamino.db.api.invocation.TInvocation;
import com.softwareag.tamino.db.api.invocation.TInvocationException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import com.softwareag.tamino.db.api.objectModel.TDataObject;

public class TStreamAccessorImpl
extends TAbstractAccessor
implements TStreamAccessor {
    private TPreference preference = TPreference.getInstance();
    private static final boolean PRE_CHECK = Precondition.isEnabled(class$com$softwareag$tamino$db$api$accessor$TStreamAccessorImpl == null ? (class$com$softwareag$tamino$db$api$accessor$TStreamAccessorImpl = TStreamAccessorImpl.class$("com.softwareag.tamino.db.api.accessor.TStreamAccessorImpl")) : class$com$softwareag$tamino$db$api$accessor$TStreamAccessorImpl);
    private static final boolean POST_CHECK = Postcondition.isEnabled(class$com$softwareag$tamino$db$api$accessor$TStreamAccessorImpl == null ? (class$com$softwareag$tamino$db$api$accessor$TStreamAccessorImpl = TStreamAccessorImpl.class$("com.softwareag.tamino.db.api.accessor.TStreamAccessorImpl")) : class$com$softwareag$tamino$db$api$accessor$TStreamAccessorImpl);
    private static final String LOG_NAME = LoggerUtil.getThisClassName();
    private static Logger logger = LoggerFactory.getLogger(LOG_NAME, "$Revision: 1.22 $");
    static /* synthetic */ Class class$com$softwareag$tamino$db$api$accessor$TStreamAccessorImpl;

    public TStreamAccessorImpl(TAccessLocation tAccessLocation, TInvocation tInvocation) {
        super(tAccessLocation, tInvocation);
    }

    public TStreamAccessorImpl(TAbstractAccessor tAbstractAccessor) {
        super(tAbstractAccessor);
    }

    public synchronized TInputStream insert(TDataObject tDataObject) throws TInsertException {
        Precondition.check(tDataObject != null, "No dataObject given!");
        Precondition.check(tDataObject.getCollection().equals("") || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("insert");
        }
        String string = tDataObject.getId();
        tDataObject.setId(null);
        String string2 = tDataObject.getDocname();
        tDataObject.setDocname(null);
        String string3 = tDataObject.getDoctype();
        try {
            try {
                TInputStream tInputStream = null;
                tInputStream = string2.length() > 0 ? this.process(tDataObject, string3, string2) : this.process(tDataObject, null, null);
                tDataObject.setCollection(this.getAccessCollection());
                TInputStream tInputStream2 = tInputStream;
                Object var8_8 = null;
                tDataObject.setId(string);
                tDataObject.setDocname(string2);
                return tInputStream2;
            }
            catch (TInvocationException tInvocationException) {
                throw new TInsertException(tInvocationException);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            tDataObject.setId(string);
            tDataObject.setDocname(string2);
            throw throwable;
        }
    }

    public synchronized TInputStream update(TDataObject tDataObject) throws TUpdateException {
        Precondition.check(tDataObject != null, "No dataObject given!");
        Precondition.check(tDataObject.getCollection().equals("") || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        Precondition.check(tDataObject.hasId() || tDataObject.hasDocname(), "Update not possible. TXMLObject instance does not contain an ino:id!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("update");
        }
        String string = tDataObject.getId();
        String string2 = tDataObject.getDocname();
        tDataObject.setDocname(null);
        String string3 = tDataObject.getDoctype();
        try {
            try {
                TInputStream tInputStream = null;
                tInputStream = string.length() == 0 && string2.length() > 0 ? this.process(tDataObject, string3, string2) : this.process(tDataObject, null, null);
                tDataObject.setCollection(this.getAccessCollection());
                TInputStream tInputStream2 = tInputStream;
                Object var8_8 = null;
                tDataObject.setId(string);
                tDataObject.setDocname(string2);
                return tInputStream2;
            }
            catch (TInvocationException tInvocationException) {
                throw new TUpdateException(tInvocationException);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            tDataObject.setId(string);
            tDataObject.setDocname(string2);
            throw throwable;
        }
    }

    public synchronized TInputStream delete(TDataObject tDataObject) throws TDeleteException {
        Precondition.check(tDataObject != null, "data object must be not null");
        Precondition.check(tDataObject.hasDoctype(), "Delete not possible. TXMLObject instance does not contain doctype information.");
        Precondition.check(!tDataObject.hasCollection() || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        Precondition.check(tDataObject.hasId() || tDataObject.hasDocname(), "Delete not possible. TXMLObject instance does not have an ino:id.");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("delete");
        }
        String string = null;
        string = tDataObject.hasId() ? tDataObject.getDoctype() + "[@" + TInoNamespace.ID + "=\"" + tDataObject.getId() + "\"]" : tDataObject.getDoctype() + "[@" + TInoNamespace.DOCNAME + "=\"" + tDataObject.getDocname() + "\"]";
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DELETE, new TCommandValue(string));
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TDeleteException(tInvocationException);
        }
    }

    public synchronized TInputStream delete(TQuery tQuery) throws TDeleteException {
        Precondition.check(tQuery != null && !tQuery.getExpression().equals(""), "No query given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("delete");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DELETE, new TCommandValue(tQuery.getExpression()));
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TDeleteException(tInvocationException);
        }
    }

    public synchronized TInputStream query(TQuery tQuery) throws TQueryException {
        Precondition.check(tQuery != null && tQuery.getExpression().length() > 0, "No query given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("query");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TQueryException(tInvocationException);
        }
    }

    public synchronized TInputStream retrieve(TDataObject tDataObject) throws TRetrieveException {
        Precondition.check(!tDataObject.getDoctype().equals(""), "No doctype information given!");
        Precondition.check(!tDataObject.getId().equals("") || !tDataObject.getDocname().equals(""), "Either no id or docname is given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("query");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.RETRIEVE, new TCommandValue("?"));
        String string = tDataObject.getDocname();
        string = !string.equals("") ? string : "@" + tDataObject.getId();
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), tDataObject.getDoctype(), string);
        }
        catch (TInvocationException tInvocationException) {
            throw new TRetrieveException(tInvocationException);
        }
    }

    public synchronized TInputStream define(TDataObject tDataObject) throws TDefineException {
        return this.define(tDataObject, new TDefineMode(false, false));
    }

    public TInputStream define(TDataObject tDataObject, boolean bl) throws TDefineException {
        return this.define(tDataObject, new TDefineMode(bl, false));
    }

    public TInputStream define(TDataObject tDataObject, TDefineMode tDefineMode) throws TDefineException {
        Precondition.check(tDataObject != null, "No dataObject given!");
        Precondition.check(tDefineMode != null, "No defineMode given!");
        Precondition.check(tDataObject.getCollection().equals("") || tDataObject.getCollection().equals(this.getAccessCollection()), "The accessor's collection " + this.getAccessCollection() + " does not match the dataObject's collection " + tDataObject.getCollection() + "!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("define");
        }
        String string = tDataObject.getId();
        tDataObject.setId(null);
        String string2 = tDataObject.getDocname();
        tDataObject.setDocname(null);
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.DEFINE, new TCommandValue(tDataObject));
        StringBuffer stringBuffer = new StringBuffer();
        if (tDefineMode.isTest()) {
            stringBuffer.append(TCommandParameterValue.TEST);
        }
        if (tDefineMode.isValidate()) {
            stringBuffer.append(",");
            stringBuffer.append(TCommandParameterValue.VALIDATE);
        }
        if (tDefineMode.getValue() != null) {
            stringBuffer.append(",");
            stringBuffer.append(tDefineMode.getValue());
        }
        if (stringBuffer.length() > 0) {
            tCommandStatement.addCommandParameter(TCommandParameter.MODE, new TCommandParameterValue(stringBuffer.toString()));
        }
        try {
            try {
                TInputStream tInputStream = this.invoke(tCommandStatement);
                Object var9_9 = null;
                tDataObject.setId(string);
                tDataObject.setDocname(string2);
                return tInputStream;
            }
            catch (TInvocationException tInvocationException) {
                throw new TDefineException(tInvocationException);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            tDataObject.setId(string);
            tDataObject.setDocname(string2);
            throw throwable;
        }
    }

    public synchronized TInputStream undefine(String string, String string2) throws TUndefineException {
        Precondition.check(string != null && !string.equals(""), "No collection information given!");
        String string3 = string;
        if (string2 != null && !string2.equals("")) {
            string3 = string3 + "/" + string2;
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.UNDEFINE, new TCommandValue(string3));
        try {
            return this.invoke(tCommandStatement);
        }
        catch (TInvocationException tInvocationException) {
            throw new TUndefineException(tInvocationException);
        }
    }

    public synchronized TInputStream openCursor(TQuery tQuery) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Open cursor is not supported here. Change to local transaction mode!");
        Precondition.check(tQuery != null && !tQuery.getExpression().equals(""), "No query given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("openCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.OPEN);
        tCommandStatement.addCommand(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public TInputStream openCursor(TXQuery tXQuery) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Open cursor is not supported here. Change to local transaction mode!");
        Precondition.check(tXQuery != null && !tXQuery.getExpression().equals(""), "No xquery given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("openCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.OPEN);
        tCommandStatement.addCommand(TCommand.XQUERY, new TCommandValue(tXQuery.getExpression()));
        tCommandStatement.addCommandParameter(TCommandParameter.SENSITIVE, new TCommandParameterValue("no"));
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream openCursor(TQuery tQuery, int n, int n2) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Open cursor is not supported here. Change to local transaction mode!");
        Precondition.check(tQuery != null && !tQuery.getExpression().equals(""), "No query given!");
        Precondition.check(n >= 1, "Cursor position need to be equal or greater than 1!");
        Precondition.check(n2 > 0, "Fetch quantity needs to be greater than 0!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("openCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.OPEN);
        tCommandStatement.addCommand(TCommand.XQL, new TCommandValue(tQuery.getExpression()));
        tCommandStatement.addCommandParameter(TCommandParameter.SCROLL, new TCommandParameterValue("yes"));
        tCommandStatement.addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        tCommandStatement.addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        tCommandStatement.addCommandParameter(TCommandParameter.COUNT, TCommandParameterValue.CHEAP);
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public TInputStream openCursor(TXQuery tXQuery, int n, int n2) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Open cursor is not supported here. Change to local transaction mode!");
        Precondition.check(tXQuery != null && !tXQuery.getExpression().equals(""), "XQuery statement needs to be given!");
        Precondition.check(n >= 1, "Cursor position need to be equal or greater than 1!");
        Precondition.check(n2 > 0, "Fetch quantity needs to be greater than 0!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("openCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.OPEN);
        tCommandStatement.addCommand(TCommand.XQUERY, new TCommandValue(tXQuery.getExpression()));
        tCommandStatement.addCommandParameter(TCommandParameter.SCROLL, new TCommandParameterValue("yes"));
        tCommandStatement.addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        tCommandStatement.addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        tCommandStatement.addCommandParameter(TCommandParameter.COUNT, TCommandParameterValue.CHEAP);
        tCommandStatement.addCommandParameter(TCommandParameter.SENSITIVE, new TCommandParameterValue("no"));
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream fetchCursor(String string, int n, int n2) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Fetch cursor is not supported here. Change to local transaction mode and open cursor first!");
        Precondition.check(string != null, "No cursorHandle given!");
        Precondition.check(n >= 1, "Cursor position need to be equal or greater than 1!");
        Precondition.check(n2 > 0, "Fetch quantity needs to be greater than 0!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("fetchCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.FETCH);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        tCommandStatement.addCommandParameter(TCommandParameter.POSITION, new TCommandParameterValue(n));
        tCommandStatement.addCommandParameter(TCommandParameter.QUANTITY, new TCommandParameterValue(n2));
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream closeCursor(String string) throws TCursorException {
        Precondition.check(this.getInvocation().supports(TCommand.CURSOR), "Close cursor is not supported here. Change to local transaction mode and open cursor first!");
        Precondition.check(string != null, "No cursor hanlde given!");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("closeCursor");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.CURSOR, TCommandValue.CLOSE);
        tCommandStatement.addCommandParameter(TCommandParameter.HANDLE, new TCommandParameterValue(string));
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TCursorException(tInvocationException);
        }
    }

    public synchronized TInputStream xquery(TXQuery tXQuery) throws TXQueryException {
        Precondition.check(tXQuery != null && tXQuery.getExpression().length() > 0, "No xquery expression given.");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("xquery");
        }
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.XQUERY, new TCommandValue(tXQuery.getExpression()));
        try {
            return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
        }
        catch (TInvocationException tInvocationException) {
            throw new TXQueryException(tInvocationException);
        }
    }

    public TInputStream admin(String string) throws TAdminException {
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.ADMIN, new TCommandValue(string));
        try {
            return this.invoke(tCommandStatement);
        }
        catch (TInvocationException tInvocationException) {
            throw new TAdminException(tInvocationException);
        }
    }

    private synchronized TInputStream process(TDataObject tDataObject, String string, String string2) throws TInvocationException {
        TCommandStatement tCommandStatement = new TCommandStatement(TCommand.PROCESS, new TCommandValue(tDataObject));
        if (string != null && string2 != null) {
            return this.invoke(tCommandStatement, this.getAccessCollection(), string, string2);
        }
        return this.invoke(tCommandStatement, this.getAccessCollection(), null, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

