/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.accessor;

import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.accessor.TAbstractAccessor;
import com.softwareag.tamino.db.api.accessor.TAccessFailureVerifier;
import com.softwareag.tamino.db.api.accessor.TAccessLocation;
import com.softwareag.tamino.db.api.accessor.TAccessorMessages;
import com.softwareag.tamino.db.api.accessor.TCursorException;
import com.softwareag.tamino.db.api.accessor.TDeleteException;
import com.softwareag.tamino.db.api.accessor.TInsertException;
import com.softwareag.tamino.db.api.accessor.TQuery;
import com.softwareag.tamino.db.api.accessor.TQueryException;
import com.softwareag.tamino.db.api.accessor.TRetrieveException;
import com.softwareag.tamino.db.api.accessor.TStreamAccessor;
import com.softwareag.tamino.db.api.accessor.TUpdateException;
import com.softwareag.tamino.db.api.accessor.TXMLObjectAccessor;
import com.softwareag.tamino.db.api.accessor.TXQuery;
import com.softwareag.tamino.db.api.accessor.TXQueryException;
import com.softwareag.tamino.db.api.io.TInputStream;
import com.softwareag.tamino.db.api.io.TStreamReadException;
import com.softwareag.tamino.db.api.objectModel.TDataObject;
import com.softwareag.tamino.db.api.objectModel.TXMLObject;
import com.softwareag.tamino.db.api.response.THeaderEnlister;
import com.softwareag.tamino.db.api.response.TObjectContentItem;
import com.softwareag.tamino.db.api.response.TResponse;
import com.softwareag.tamino.db.api.response.TResponseBuildException;
import com.softwareag.tamino.db.api.response.TResponseBuilder;
import com.softwareag.tamino.db.api.response.TResponseHandle;

public class TXMLObjectAccessorImpl
extends TAbstractAccessor
implements TXMLObjectAccessor {
    private TStreamAccessor streamAccessor = null;
    private TResponseBuilder responseBuilder = null;
    private TAccessFailureVerifier accessFailureVerifier = TAccessFailureVerifier.getInstance();
    private THeaderEnlister headerEnlister = THeaderEnlister.getInstance();

    public TXMLObjectAccessorImpl(TStreamAccessor tStreamAccessor, TResponseBuilder tResponseBuilder) {
        super((TAbstractAccessor)((Object)tStreamAccessor));
        this.streamAccessor = tStreamAccessor;
        this.responseBuilder = tResponseBuilder;
    }

    public synchronized TResponse insert(TXMLObject tXMLObject) throws TInsertException {
        TResponse tResponse = null;
        try {
            tResponse = this.responseBuilder.buildForXML(this.streamAccessor.insert(tXMLObject));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TInsertException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        TObjectContentItem tObjectContentItem = (TObjectContentItem)((TResponseHandle)tResponse).getInfoContent().getItem(0, TObjectContentItem.SPECIFIER);
        if (tObjectContentItem != null) {
            tXMLObject.setId(tObjectContentItem.getId());
            tXMLObject.setCollection(tObjectContentItem.getCollection());
            tXMLObject.setDoctype(tObjectContentItem.getDoctype());
            this.headerEnlister.enlistLastModified(tResponse, (TDataObject)tXMLObject);
        }
        this.accessFailureVerifier.verifyInsertResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse update(TXMLObject tXMLObject) throws TUpdateException {
        TResponse tResponse = null;
        try {
            tResponse = this.responseBuilder.buildForXML(this.streamAccessor.update(tXMLObject));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TUpdateException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        TObjectContentItem tObjectContentItem = (TObjectContentItem)((TResponseHandle)tResponse).getInfoContent().getItem(0, TObjectContentItem.SPECIFIER);
        if (tObjectContentItem != null) {
            tXMLObject.setId(tObjectContentItem.getId());
            tXMLObject.setCollection(tObjectContentItem.getCollection());
            tXMLObject.setDoctype(tObjectContentItem.getDoctype());
            this.headerEnlister.enlistLastModified(tResponse, (TDataObject)tXMLObject);
        }
        this.accessFailureVerifier.verifyUpdateResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse delete(TXMLObject tXMLObject) throws TDeleteException {
        TResponse tResponse = null;
        try {
            tResponse = this.responseBuilder.buildForXML(this.streamAccessor.delete(tXMLObject));
            this.headerEnlister.enlistLastModified(tResponse, (TDataObject)tXMLObject);
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TDeleteException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        this.accessFailureVerifier.verifyDeleteResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse delete(TQuery tQuery) throws TDeleteException {
        TResponse tResponse = null;
        try {
            tResponse = this.responseBuilder.buildForXML(this.streamAccessor.delete(tQuery));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TDeleteException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        this.accessFailureVerifier.verifyDeleteResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse query(TQuery tQuery) throws TQueryException {
        TResponse tResponse = null;
        try {
            tResponse = this.responseBuilder.buildForXML(this.streamAccessor.query(tQuery));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TQueryException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        this.accessFailureVerifier.verifyQueryResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse xquery(TXQuery tXQuery) throws TXQueryException {
        Precondition.check(tXQuery != null && !tXQuery.getExpression().equals(""), "No TXQuery expression given!");
        TResponse tResponse = null;
        try {
            tResponse = this.responseBuilder.buildForXML(this.streamAccessor.xquery(tXQuery));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TXQueryException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        this.accessFailureVerifier.verifyXQueryResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse query(TQuery tQuery, int n) throws TQueryException {
        Precondition.check(tQuery != null && !tQuery.getExpression().equals(""), "No TQuery expression given!");
        Precondition.check(n > 0, "Quantity must be greater than 0!");
        TResponse tResponse = null;
        try {
            tResponse = this.responseBuilder.buildForXML(this.streamAccessor.openCursor(tQuery, 1, n));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TQueryException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        catch (TCursorException tCursorException) {
            throw new TQueryException(TAccessorMessages.TAJACE0001, (Exception)tCursorException);
        }
        if (tResponse.getReturnValue().equals("8306")) {
            ((TResponseHandle)tResponse).getInfoContent().clear();
        }
        this.accessFailureVerifier.verifyQueryResponse(tResponse);
        return tResponse;
    }

    public synchronized TResponse xquery(TXQuery tXQuery, int n) throws TXQueryException {
        Precondition.check(tXQuery != null && !tXQuery.getExpression().equals(""), "No TXQuery expression given!");
        Precondition.check(n > 0, "Quantity must be greater than 0!");
        TResponse tResponse = null;
        try {
            tResponse = this.responseBuilder.buildForXML(this.streamAccessor.openCursor(tXQuery, 1, n));
        }
        catch (TResponseBuildException tResponseBuildException) {
            throw new TXQueryException(TAccessorMessages.TAJACE0001, (Exception)tResponseBuildException);
        }
        catch (TCursorException tCursorException) {
            throw new TXQueryException(TAccessorMessages.TAJACE0001, (Exception)tCursorException);
        }
        if (tResponse.getReturnValue().equals("8306")) {
            ((TResponseHandle)tResponse).getInfoContent().clear();
        }
        this.accessFailureVerifier.verifyXQueryResponse(tResponse);
        return tResponse;
    }

    public synchronized TXMLObject retrieve(TXMLObject tXMLObject) throws TRetrieveException {
        try {
            String string = tXMLObject.getId();
            String string2 = tXMLObject.getDocname();
            TInputStream tInputStream = this.streamAccessor.retrieve(tXMLObject);
            tXMLObject.readFrom(tInputStream);
            tXMLObject.setId(string);
            tXMLObject.setDocname(string2);
            tXMLObject.setCollection(this.getAccessCollection());
            this.headerEnlister.enlistLastModified(tInputStream, (TDataObject)tXMLObject);
        }
        catch (TStreamReadException tStreamReadException) {
            throw new TRetrieveException(tStreamReadException);
        }
        return tXMLObject;
    }

    public synchronized void setAccessLocation(TAccessLocation tAccessLocation) {
        this.streamAccessor.setAccessLocation(tAccessLocation);
        super.setAccessLocation(tAccessLocation);
    }
}

