/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.common;

import com.softwareag.tamino.db.api.common.TAccessFailureMessage;
import com.softwareag.tamino.db.api.common.TCommonMessages;
import com.softwareag.tamino.db.api.common.TException;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.message.TResourceId;
import com.softwareag.tamino.db.api.namespace.TInoNamespace;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TAccessFailureException
extends TException
implements TAccessFailureMessage {
    private String returnValue = "";
    private String code = "";
    private String text = "";
    private String line = "";

    public TAccessFailureException(String string, String string2, String string3, String string4) {
        super("Tamino access failure (" + string2 + ", " + string3 + (string4 != null && string4.length() > 0 ? ", " + string4 : "") + ")");
        this.returnValue = TString.stringize(string);
        this.code = TString.stringize(string2);
        this.text = TString.stringize(string3);
        this.line = TString.stringize(string4);
    }

    public TAccessFailureException(InputStream inputStream) {
        super("Tamino access failure.");
        this.retrieveAccessFailureDetails(inputStream);
    }

    private String retrieveAccessFailureDetails(InputStream inputStream) {
        TResourceId tResourceId = TCommonMessages.TAJCME0102;
        this.returnValue = tResourceId.getResourceMessage().getMessageCode().getNumber();
        this.code = tResourceId.getResourceMessage().getMessageCode().toString();
        this.text = tResourceId.getResourceMessage().getMessageContent();
        this.line = tResourceId.getResourceMessage().getMessageTitle();
        try {
            inputStream.mark(2048);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element = document.getDocumentElement();
            String string = TInoNamespace.getInstance().getUri();
            NodeList nodeList = element.getElementsByTagNameNS(string, TInoNamespace.MESSAGE.getName());
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node;
                Element element2 = (Element)nodeList.item(n);
                this.returnValue = element2.getAttributeNS(string, TInoNamespace.RETURN_VALUE.getName());
                NodeList nodeList2 = element2.getElementsByTagNameNS(string, TInoNamespace.MESSAGE_LINE.getName());
                if (nodeList2.getLength() > 0) {
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        Element element3 = (Element)nodeList2.item(n2);
                        this.line = element3.getFirstChild() != null ? element3.getFirstChild().getNodeValue() : "";
                        ++n2;
                    }
                }
                if ((node = element2.getElementsByTagNameNS(string, TInoNamespace.MESSAGE_TEXT.getName()).item(0)) != null) {
                    this.code = ((Element)node).getAttributeNS(string, TInoNamespace.CODE.getName());
                    this.text = node.getFirstChild().getNodeValue();
                }
                ++n;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.line = "ParserConfigurationException: " + parserConfigurationException.getMessage();
        }
        catch (SAXException sAXException) {
            try {
                inputStream.reset();
                this.text = this.text + " " + this.getContent(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.line = "SAXException: " + sAXException.getMessage();
        }
        catch (IOException iOException) {
            this.line = "IOException: " + iOException.getMessage();
        }
        return "Tamino access failure (" + this.code + ", " + this.text + (this.line != null && this.line.length() > 0 ? ", " + this.line : "") + ")";
    }

    private String getContent(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(2048);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        int n = 0;
        while (n > -1) {
            n = inputStreamReader.read();
            if (n <= -1) continue;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessageText() {
        return this.text;
    }

    public String getMessageLine() {
        return this.line;
    }

    protected Element getAdditionalXMLMessageContent(Document document) {
        Element element = document.createElement("additional");
        Element element2 = document.createElement("returnValue");
        element2.appendChild(document.createTextNode(this.returnValue != null ? this.returnValue : "No return value"));
        element.appendChild(element2);
        Element element3 = document.createElement("code");
        element3.appendChild(document.createTextNode(this.code != null ? this.code : "No code"));
        element.appendChild(element3);
        Element element4 = document.createElement("text");
        element4.appendChild(document.createTextNode(this.text != null ? this.text : "No text"));
        element.appendChild(element4);
        Element element5 = document.createElement("line");
        element5.appendChild(document.createTextNode(this.line != null ? this.line : "no line"));
        element.appendChild(element5);
        return element;
    }

    public boolean matchesReturnValue(String string) {
        return this.returnValue.equals(string);
    }

    public boolean matchesReturnValue(String string, String string2) {
        try {
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            int n3 = Integer.parseInt(this.returnValue);
            return n3 >= n && n3 <= n2;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

