/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.common;

import com.softwareag.common.instrumentation.contract.Precondition;
import com.softwareag.tamino.db.api.common.TUri;
import com.softwareag.tamino.db.api.common.TVersion;
import java.net.MalformedURLException;

public class TDatabase {
    private static final TVersion SHEFFIELD_VERSION = new TVersion("2.3.*.*");
    private static final TVersion ABOVE_SHEFFIELD_VERSION = new TVersion("2.3.0.0");
    private static final TVersion NEWCASTLE_VERSION = new TVersion("3.1.*.*");
    private static final TVersion ABOVE_NEWCASTLE_VERSION = new TVersion("3.1.0.0");
    private static final TVersion YORK_VERSION = new TVersion("3.1.0.504");
    private static final TVersion ABOVE_YORK_VERSION = new TVersion("3.1.0.504");
    private static final TVersion WASHINGTON_VERSION = new TVersion("4.1.*.*");
    private static final TVersion ABOVE_WASHINGTON_VERSION = new TVersion("4.1.0.0");
    private TUri thisDatabaseUri = null;
    private TVersion thisVersion = null;

    public TDatabase(String string) throws MalformedURLException {
        this.thisDatabaseUri = new TUri(string);
    }

    public String getDatabaseURI() {
        return this.thisDatabaseUri.getUri();
    }

    public String getProtocol() {
        return this.thisDatabaseUri.getScheme();
    }

    public void setVersion(String string) {
        Precondition.check(this.thisVersion == null, "You may not set the version a second time!");
        this.thisVersion = new TVersion(string);
    }

    public TVersion getVersion() {
        return this.thisVersion;
    }

    public String toString() {
        return this.getDatabaseURI();
    }

    public boolean isSheffield() {
        return this.isOfVersion(SHEFFIELD_VERSION);
    }

    public boolean isAboveSheffield() {
        return this.isAboveVersion(ABOVE_SHEFFIELD_VERSION);
    }

    public boolean isNewcastle() {
        return this.isOfVersion(NEWCASTLE_VERSION);
    }

    public boolean isAboveNewcastle() {
        return this.isAboveVersion(ABOVE_NEWCASTLE_VERSION);
    }

    public boolean isYork() {
        return this.isNewcastle() && this.isAboveYork();
    }

    public boolean isAboveYork() {
        return this.isAboveVersion(ABOVE_YORK_VERSION);
    }

    public boolean isWashington() {
        return this.isOfVersion(WASHINGTON_VERSION);
    }

    public boolean isAboveWashington() {
        return this.isAboveVersion(ABOVE_WASHINGTON_VERSION);
    }

    public boolean isBelowWashington() {
        return !this.isWashington() && !this.isAboveWashington();
    }

    private boolean isOfVersion(TVersion tVersion) {
        return this.thisVersion.equals(tVersion);
    }

    private boolean isAboveVersion(TVersion tVersion) {
        return this.thisVersion.compareTo(tVersion) == 1;
    }
}

