/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.common;

import com.softwareag.common.resourceutilities.message.Message;
import com.softwareag.common.resourceutilities.message.ResourceMessage;
import com.softwareag.tamino.db.api.common.TAccessFailureException;
import com.softwareag.tamino.db.api.common.TIdentity;
import com.softwareag.tamino.db.api.common.TString;
import com.softwareag.tamino.db.api.message.TResourceId;
import com.softwareag.tamino.db.api.objectModel.dom.TDOMWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TException
extends Exception {
    private Message thisMessage = null;
    private Throwable thisCause = null;
    private boolean originalStackTraceRequiered = false;

    public TException() {
    }

    public TException(String string) {
        super(string);
    }

    public TException(String string, Throwable throwable) {
        super(string);
        this.thisCause = throwable;
    }

    public TException(TResourceId tResourceId) {
        super(tResourceId.getResourceMessage().getMessageContent());
        this.thisMessage = tResourceId.getResourceMessage();
    }

    public TException(TResourceId tResourceId, Throwable throwable) {
        super(tResourceId.getResourceMessage().getMessageContent());
        this.thisCause = throwable;
        this.thisMessage = tResourceId.getResourceMessage();
    }

    public TException(Throwable throwable) {
        this.thisCause = throwable;
    }

    public String getMessageCode() {
        if (this.thisMessage != null) {
            return this.thisMessage.getMessageCode().toString();
        }
        return "?";
    }

    public String getMessageContent() {
        if (this.thisMessage != null) {
            return this.thisMessage.getMessageContent();
        }
        return "?";
    }

    public synchronized String getXMLMessage() {
        String string = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.appendChild(this.getXMLMessage(document));
            TDOMWriter tDOMWriter = new TDOMWriter();
            StringWriter stringWriter = new StringWriter();
            tDOMWriter.write(document, stringWriter);
            string = stringWriter.toString();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            string = "Error building the XML exception output. Retrieved a ParserConfigurationException: " + parserConfigurationException;
        }
        catch (IOException iOException) {
            string = "Error building the XML exception output. Retrieved a IOException: " + iOException;
        }
        return string;
    }

    protected Element getXMLMessage(Document document) {
        Element element = document.createElement("exception");
        element.setAttribute("name", this.getClass().getName());
        element.setAttribute("tag", TIdentity.getInstance().getCVSTagName());
        element.setAttribute("java", TIdentity.getInstance().getJavaVersion());
        element.setAttribute("os", TIdentity.getInstance().getOSNameAndVersion());
        element.appendChild(this.getXMLMessageContent(document));
        element.appendChild(this.getXMLStacktrace(this, document));
        Element element2 = this.getXMLNestedException(document);
        if (element2 != null) {
            element.appendChild(element2);
        }
        return element;
    }

    private Element getXMLMessageContent(Document document) {
        Element element;
        Element element2 = document.createElement("message");
        if (this.thisMessage != null) {
            element2.appendChild(this.thisMessage.toXML(document));
        } else if (super.getMessage() != null) {
            element = document.createElement("text");
            element.appendChild(document.createTextNode(super.getMessage()));
            element2.appendChild(element);
        }
        element = this.getAdditionalXMLMessageContent(document);
        if (element != null) {
            element2.appendChild(element);
        }
        return element2;
    }

    protected Element getAdditionalXMLMessageContent(Document document) {
        return null;
    }

    private Element getXMLStacktrace(Throwable throwable, Document document) {
        Element element = document.createElement("stacktrace");
        try {
            StringWriter stringWriter = new StringWriter();
            TException tException = this;
            synchronized (tException) {
                this.originalStackTraceRequiered = true;
                throwable.printStackTrace(new PrintWriter(stringWriter));
                this.originalStackTraceRequiered = false;
            }
            String string = stringWriter.toString();
            int n = 0;
            int n2 = 0;
            while ((n = string.indexOf("at ", n2)) != -1 && n2 != -1) {
                n2 = string.indexOf(10, n + 1);
                n2 = n2 != -1 ? n2 : string.indexOf(41, n + 1);
                Element element2 = document.createElement("at");
                element.appendChild(element2);
                String string2 = n + 3 < n2 - 1 ? string.substring(n + 3, n2 - 1) : "";
                element2.appendChild(document.createTextNode(string2));
            }
        }
        catch (Throwable throwable2) {
            element.appendChild(document.createTextNode(" Warning! Could not retrieve the stacktrace because of " + throwable2));
        }
        return element;
    }

    private Element getXMLNestedException(Document document) {
        if (this.thisCause != null) {
            if (this.thisCause instanceof TException) {
                return ((TException)this.thisCause).getXMLMessage(document);
            }
            Element element = document.createElement("exception");
            element.setAttribute("name", this.thisCause.getClass().getName());
            Element element2 = document.createElement("messsage");
            Element element3 = document.createElement("text");
            Element element4 = this.getXMLStacktrace(this.thisCause, document);
            element3.appendChild(document.createTextNode(TString.stringize(this.thisCause.getMessage())));
            element2.appendChild(element3);
            element.appendChild(element2);
            element.appendChild(element4);
            return element;
        }
        return null;
    }

    public ResourceMessage getResourceMessage() {
        return null;
    }

    public Message getExceptionMessage() {
        return this.thisMessage;
    }

    public String getMessage() {
        if (this.thisCause != null) {
            String string = "";
            if (super.getMessage() != null) {
                string = string + super.getMessage() + "\n";
            }
            string = string + (this.thisCause.getMessage() != null ? "NestedException:" + this.thisCause.getMessage() : "NestedException without message!");
            return string;
        }
        return TString.stringize(super.getMessage());
    }

    public boolean hasNestedException() {
        return this.hasCause();
    }

    public boolean hasCause() {
        return this.thisCause != null;
    }

    public boolean hasAccessFailureException() {
        TException tException = this.getRootTCause();
        return tException instanceof TAccessFailureException;
    }

    public Throwable getNestedException() {
        return this.getCause();
    }

    public Throwable getCause() {
        return this.thisCause;
    }

    public Throwable getDeepestException() {
        return this.getRootCause();
    }

    public Throwable getRootCause() {
        if (this.thisCause != null) {
            if (this.thisCause instanceof TException && ((TException)this.thisCause).getCause() != null) {
                return ((TException)this.thisCause).getRootCause();
            }
            return this.thisCause;
        }
        return null;
    }

    public TException getDeepestTException() {
        return this.getRootTCause();
    }

    public TException getRootTCause() {
        if (this.thisCause != null && this.thisCause instanceof TException) {
            return ((TException)this.thisCause).getDeepestTException();
        }
        return this;
    }

    public TAccessFailureException getAccessFailureException() {
        TException tException = this.getRootTCause();
        if (tException instanceof TAccessFailureException) {
            return (TAccessFailureException)tException;
        }
        return null;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            TException tException = this;
            synchronized (tException) {
                if (this.thisCause != null && !this.originalStackTraceRequiered) {
                    printStream.println(this.getExceptionInformation());
                    this.thisCause.printStackTrace(printStream);
                } else {
                    super.printStackTrace(printStream);
                }
            }
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            TException tException = this;
            synchronized (tException) {
                if (this.thisCause != null && !this.originalStackTraceRequiered) {
                    printWriter.println(this.getExceptionInformation());
                    this.thisCause.printStackTrace(printWriter);
                } else {
                    super.printStackTrace(printWriter);
                }
            }
        }
    }

    private String getExceptionInformation() {
        return "Nested Exception ( " + this.thisCause.getClass().getName() + ", tag: " + TIdentity.getInstance().getCVSTagName() + ", java: " + TIdentity.getInstance().getJavaVersion() + ", os: " + TIdentity.getInstance().getOSNameAndVersion() + " ) stacktrace:\n";
    }

    public String toXMLString() {
        return this.getXMLMessage();
    }

    public String toString() {
        return this.getMessage();
    }
}

