/*
 * Decompiled with CFR 0.152.
 */
package com.softwareag.tamino.db.api.common;

public class TIdentity {
    private String tagName = null;
    private String javaVersion = null;
    private String osNameAndVersion = null;
    private static final String PRODUCT_CODE = "TAJ";
    private static final String CVS_TAG_NAME = "$Name: JavaTaminoAPI_4_1_4_42_1_1 $";
    private static final String CVS_TAG_NAME_PREFIX = "$Name:";
    private static final String CVS_TAG_NAME_POSTFIX = "$";
    private static final String UNKNOWN_TAG = "not tagged";
    private static final String JAVA_VESION_KEY = "java.version";
    private static final String OS_NAME_KEY = "os.name";
    private static final String OS_VESION_KEY = "os.version";
    private static TIdentity singleton = null;

    private TIdentity() {
    }

    public static synchronized TIdentity getInstance() {
        if (singleton == null) {
            singleton = new TIdentity();
        }
        return singleton;
    }

    public String getProductCode() {
        return PRODUCT_CODE;
    }

    public String getCVSTagName() {
        if (this.tagName == null) {
            this.tagName = TIdentity.getCVSTagName(CVS_TAG_NAME);
        }
        return this.tagName;
    }

    public String getJavaVersion() {
        if (this.javaVersion == null) {
            try {
                this.javaVersion = System.getProperty(JAVA_VESION_KEY, "?");
            }
            catch (Throwable throwable) {
                this.javaVersion = "unknown Java version";
            }
        }
        return this.javaVersion;
    }

    public String getOSNameAndVersion() {
        if (this.osNameAndVersion == null) {
            try {
                this.osNameAndVersion = System.getProperty(OS_NAME_KEY, "?");
            }
            catch (Throwable throwable) {
                this.osNameAndVersion = "unknown OS name";
            }
            this.osNameAndVersion = this.osNameAndVersion + " ";
            try {
                this.osNameAndVersion = this.osNameAndVersion + System.getProperty(OS_VESION_KEY, "?");
            }
            catch (Throwable throwable) {
                this.osNameAndVersion = this.osNameAndVersion + "unknown OS version";
            }
        }
        return this.osNameAndVersion;
    }

    public static String getCVSTagName(String string) {
        int n;
        if (string.startsWith(CVS_TAG_NAME_PREFIX) && (n = string.lastIndexOf(CVS_TAG_NAME_POSTFIX)) != -1) {
            try {
                String string2 = string.substring(CVS_TAG_NAME_PREFIX.length(), n).trim();
                return string2.length() == 0 ? UNKNOWN_TAG : string2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println("Product Code: " + TIdentity.getInstance().getProductCode());
        System.out.println("CVS Tag Name: " + TIdentity.getInstance().getCVSTagName());
        System.out.println("Java Version: " + TIdentity.getInstance().getJavaVersion());
        System.out.println("OS Name     : " + TIdentity.getInstance().getOSNameAndVersion());
    }
}

